import { b as is_function, L as Loader, d as get_store_value, $ as $format, w as writable, e as setupi18n } from './Index-3b1865e7.js';
import { _ as __vitePreload } from './index-ec890757.js';
import { d as cubicOut, f as fade, B as Block, a as Button } from './Button-cca92c6b.js';

/**
 * The flip function calculates the start and end position of an element and animates between them, translating the x and y values.
 * `flip` stands for [First, Last, Invert, Play](https://aerotwist.com/blog/flip-your-animations/).
 *
 * https://svelte.dev/docs/svelte-animate#flip
 * @param {Element} node
 * @param {{ from: DOMRect; to: DOMRect }} fromTo
 * @param {import('./public.js').FlipParams} params
 * @returns {import('./public.js').AnimationConfig}
 */
function flip(node, { from, to }, params = {}) {
	const style = getComputedStyle(node);
	const transform = style.transform === 'none' ? '' : style.transform;
	const [ox, oy] = style.transformOrigin.split(' ').map(parseFloat);
	const dx = from.left + (from.width * ox) / to.width - (to.left + ox);
	const dy = from.top + (from.height * oy) / to.height - (to.top + oy);
	const { delay = 0, duration = (d) => Math.sqrt(d) * 120, easing = cubicOut } = params;
	return {
		delay,
		duration: is_function(duration) ? duration(Math.sqrt(dx * dx + dy * dy)) : duration,
		easing,
		css: (t, u) => {
			const x = u * dx;
			const y = u * dy;
			const sx = t + (u * from.width) / to.width;
			const sy = t + (u * from.height) / to.height;
			return `transform: ${transform} translate(${x}px, ${y}px) scale(${sx}, ${sy});`;
		}
	};
}

/* home/runner/work/gradio/gradio/js/icons/src/Error.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$h,
	append: append$d,
	attr: attr$d,
	detach: detach$g,
	init: init$h,
	insert: insert$g,
	noop: noop$8,
	safe_not_equal: safe_not_equal$g,
	svg_element: svg_element$3
} = window.__gradio__svelte__internal;
function create_fragment$h(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element$3("svg");
			path = svg_element$3("path");
			attr$d(path, "stroke-linecap", "round");
			attr$d(path, "stroke-linejoin", "round");
			attr$d(path, "d", "M12 9v3.75m9-.75a9 9 0 11-18 0 9 9 0 0118 0zm-9 3.75h.008v.008H12v-.008z");
			attr$d(svg, "fill", "none");
			attr$d(svg, "stroke", "currentColor");
			attr$d(svg, "viewBox", "0 0 24 24");
			attr$d(svg, "width", "100%");
			attr$d(svg, "height", "100%");
			attr$d(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr$d(svg, "aria-hidden", "true");
			attr$d(svg, "stroke-width", "2");
			attr$d(svg, "stroke-linecap", "round");
			attr$d(svg, "stroke-linejoin", "round");
		},
		m(target, anchor) {
			insert$g(target, svg, anchor);
			append$d(svg, path);
		},
		p: noop$8,
		i: noop$8,
		o: noop$8,
		d(detaching) {
			if (detaching) {
				detach$g(svg);
			}
		}
	};
}

let Error$1 = class Error extends SvelteComponent$h {
	constructor(options) {
		super();
		init$h(this, options, null, create_fragment$h, safe_not_equal$g, {});
	}
};

/* home/runner/work/gradio/gradio/js/icons/src/Info.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$g,
	append: append$c,
	attr: attr$c,
	detach: detach$f,
	init: init$g,
	insert: insert$f,
	noop: noop$7,
	safe_not_equal: safe_not_equal$f,
	svg_element: svg_element$2
} = window.__gradio__svelte__internal;
function create_fragment$g(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element$2("svg");
			path = svg_element$2("path");
			attr$c(path, "stroke-linecap", "round");
			attr$c(path, "stroke-linejoin", "round");
			attr$c(path, "d", "M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z");
			attr$c(svg, "fill", "none");
			attr$c(svg, "stroke", "currentColor");
			attr$c(svg, "viewBox", "0 0 24 24");
			attr$c(svg, "width", "100%");
			attr$c(svg, "height", "100%");
			attr$c(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr$c(svg, "aria-hidden", "true");
			attr$c(svg, "stroke-width", "2");
			attr$c(svg, "stroke-linecap", "round");
			attr$c(svg, "stroke-linejoin", "round");
		},
		m(target, anchor) {
			insert$f(target, svg, anchor);
			append$c(svg, path);
		},
		p: noop$7,
		i: noop$7,
		o: noop$7,
		d(detaching) {
			if (detaching) {
				detach$f(svg);
			}
		}
	};
}

class Info extends SvelteComponent$g {
	constructor(options) {
		super();
		init$g(this, options, null, create_fragment$g, safe_not_equal$f, {});
	}
}

/* home/runner/work/gradio/gradio/js/icons/src/Warning.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$f,
	append: append$b,
	attr: attr$b,
	detach: detach$e,
	init: init$f,
	insert: insert$e,
	noop: noop$6,
	safe_not_equal: safe_not_equal$e,
	svg_element: svg_element$1
} = window.__gradio__svelte__internal;
function create_fragment$f(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element$1("svg");
			path = svg_element$1("path");
			attr$b(path, "stroke-linecap", "round");
			attr$b(path, "stroke-linejoin", "round");
			attr$b(path, "d", "M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z");
			attr$b(svg, "fill", "none");
			attr$b(svg, "stroke", "currentColor");
			attr$b(svg, "stroke-width", "2");
			attr$b(svg, "viewBox", "0 0 24 24");
			attr$b(svg, "width", "100%");
			attr$b(svg, "height", "100%");
			attr$b(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr$b(svg, "aria-hidden", "true");
			attr$b(svg, "stroke-linecap", "round");
			attr$b(svg, "stroke-linejoin", "round");
		},
		m(target, anchor) {
			insert$e(target, svg, anchor);
			append$b(svg, path);
		},
		p: noop$6,
		i: noop$6,
		o: noop$6,
		d(detaching) {
			if (detaching) {
				detach$e(svg);
			}
		}
	};
}

class Warning extends SvelteComponent$f {
	constructor(options) {
		super();
		init$f(this, options, null, create_fragment$f, safe_not_equal$e, {});
	}
}

/* home/runner/work/gradio/gradio/js/statustracker/static/ToastContent.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$e,
	add_render_callback,
	append: append$a,
	attr: attr$a,
	bubble: bubble$4,
	check_outros: check_outros$8,
	create_component: create_component$c,
	create_in_transition,
	create_out_transition,
	destroy_component: destroy_component$c,
	detach: detach$d,
	element: element$9,
	group_outros: group_outros$8,
	init: init$e,
	insert: insert$d,
	listen: listen$4,
	mount_component: mount_component$c,
	run_all,
	safe_not_equal: safe_not_equal$d,
	set_data: set_data$7,
	space: space$8,
	stop_propagation,
	text: text$8,
	transition_in: transition_in$c,
	transition_out: transition_out$c
} = window.__gradio__svelte__internal;const { createEventDispatcher: createEventDispatcher$5, onMount: onMount$3 } = window.__gradio__svelte__internal;
function create_if_block_2$4(ctx) {
	let error;
	let current;
	error = new Error$1({});

	return {
		c() {
			create_component$c(error.$$.fragment);
		},
		m(target, anchor) {
			mount_component$c(error, target, anchor);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in$c(error.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$c(error.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$c(error, detaching);
		}
	};
}

// (32:28) 
function create_if_block_1$5(ctx) {
	let info;
	let current;
	info = new Info({});

	return {
		c() {
			create_component$c(info.$$.fragment);
		},
		m(target, anchor) {
			mount_component$c(info, target, anchor);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in$c(info.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$c(info.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$c(info, detaching);
		}
	};
}

// (30:2) {#if type === "warning"}
function create_if_block$8(ctx) {
	let warning;
	let current;
	warning = new Warning({});

	return {
		c() {
			create_component$c(warning.$$.fragment);
		},
		m(target, anchor) {
			mount_component$c(warning, target, anchor);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in$c(warning.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$c(warning.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$c(warning, detaching);
		}
	};
}

function create_fragment$e(ctx) {
	let div5;
	let div0;
	let current_block_type_index;
	let if_block;
	let div0_class_value;
	let t0;
	let div3;
	let div1;
	let t1;
	let div1_class_value;
	let t2;
	let div2;
	let t3;
	let div2_class_value;
	let div3_class_value;
	let t4;
	let button;
	let span;
	let button_class_value;
	let t6;
	let div4;
	let div4_class_value;
	let div5_class_value;
	let div5_intro;
	let div5_outro;
	let current;
	let mounted;
	let dispose;
	const if_block_creators = [create_if_block$8, create_if_block_1$5, create_if_block_2$4];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*type*/ ctx[1] === "warning") return 0;
		if (/*type*/ ctx[1] === "info") return 1;
		if (/*type*/ ctx[1] === "error") return 2;
		return -1;
	}

	if (~(current_block_type_index = select_block_type(ctx))) {
		if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	}

	return {
		c() {
			div5 = element$9("div");
			div0 = element$9("div");
			if (if_block) if_block.c();
			t0 = space$8();
			div3 = element$9("div");
			div1 = element$9("div");
			t1 = text$8(/*type*/ ctx[1]);
			t2 = space$8();
			div2 = element$9("div");
			t3 = text$8(/*message*/ ctx[0]);
			t4 = space$8();
			button = element$9("button");
			span = element$9("span");
			span.textContent = "×";
			t6 = space$8();
			div4 = element$9("div");
			attr$a(div0, "class", div0_class_value = "toast-icon " + /*type*/ ctx[1] + " svelte-z3l7qj");
			attr$a(div1, "class", div1_class_value = "toast-title " + /*type*/ ctx[1] + " svelte-z3l7qj");
			attr$a(div2, "class", div2_class_value = "toast-text " + /*type*/ ctx[1] + " svelte-z3l7qj");
			attr$a(div3, "class", div3_class_value = "toast-details " + /*type*/ ctx[1] + " svelte-z3l7qj");
			attr$a(span, "aria-hidden", "true");
			attr$a(button, "class", button_class_value = "toast-close " + /*type*/ ctx[1] + " svelte-z3l7qj");
			attr$a(button, "type", "button");
			attr$a(button, "aria-label", "Close");
			attr$a(button, "data-testid", "toast-close");
			attr$a(div4, "class", div4_class_value = "timer " + /*type*/ ctx[1] + " svelte-z3l7qj");
			attr$a(div5, "class", div5_class_value = "toast-body " + /*type*/ ctx[1] + " svelte-z3l7qj");
			attr$a(div5, "role", "alert");
			attr$a(div5, "data-testid", "toast-body");
		},
		m(target, anchor) {
			insert$d(target, div5, anchor);
			append$a(div5, div0);

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].m(div0, null);
			}

			append$a(div5, t0);
			append$a(div5, div3);
			append$a(div3, div1);
			append$a(div1, t1);
			append$a(div3, t2);
			append$a(div3, div2);
			append$a(div2, t3);
			append$a(div5, t4);
			append$a(div5, button);
			append$a(button, span);
			append$a(div5, t6);
			append$a(div5, div4);
			current = true;

			if (!mounted) {
				dispose = [
					listen$4(button, "click", /*close_message*/ ctx[2]),
					listen$4(div5, "click", stop_propagation(/*click_handler*/ ctx[4])),
					listen$4(div5, "keydown", stop_propagation(/*keydown_handler*/ ctx[5]))
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index !== previous_block_index) {
				if (if_block) {
					group_outros$8();

					transition_out$c(if_blocks[previous_block_index], 1, 1, () => {
						if_blocks[previous_block_index] = null;
					});

					check_outros$8();
				}

				if (~current_block_type_index) {
					if_block = if_blocks[current_block_type_index];

					if (!if_block) {
						if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
						if_block.c();
					}

					transition_in$c(if_block, 1);
					if_block.m(div0, null);
				} else {
					if_block = null;
				}
			}

			if (!current || dirty & /*type*/ 2 && div0_class_value !== (div0_class_value = "toast-icon " + /*type*/ ctx[1] + " svelte-z3l7qj")) {
				attr$a(div0, "class", div0_class_value);
			}

			if (!current || dirty & /*type*/ 2) set_data$7(t1, /*type*/ ctx[1]);

			if (!current || dirty & /*type*/ 2 && div1_class_value !== (div1_class_value = "toast-title " + /*type*/ ctx[1] + " svelte-z3l7qj")) {
				attr$a(div1, "class", div1_class_value);
			}

			if (!current || dirty & /*message*/ 1) set_data$7(t3, /*message*/ ctx[0]);

			if (!current || dirty & /*type*/ 2 && div2_class_value !== (div2_class_value = "toast-text " + /*type*/ ctx[1] + " svelte-z3l7qj")) {
				attr$a(div2, "class", div2_class_value);
			}

			if (!current || dirty & /*type*/ 2 && div3_class_value !== (div3_class_value = "toast-details " + /*type*/ ctx[1] + " svelte-z3l7qj")) {
				attr$a(div3, "class", div3_class_value);
			}

			if (!current || dirty & /*type*/ 2 && button_class_value !== (button_class_value = "toast-close " + /*type*/ ctx[1] + " svelte-z3l7qj")) {
				attr$a(button, "class", button_class_value);
			}

			if (!current || dirty & /*type*/ 2 && div4_class_value !== (div4_class_value = "timer " + /*type*/ ctx[1] + " svelte-z3l7qj")) {
				attr$a(div4, "class", div4_class_value);
			}

			if (!current || dirty & /*type*/ 2 && div5_class_value !== (div5_class_value = "toast-body " + /*type*/ ctx[1] + " svelte-z3l7qj")) {
				attr$a(div5, "class", div5_class_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in$c(if_block);

			if (local) {
				add_render_callback(() => {
					if (!current) return;
					if (div5_outro) div5_outro.end(1);
					div5_intro = create_in_transition(div5, fade, { duration: 200, delay: 100 });
					div5_intro.start();
				});
			}

			current = true;
		},
		o(local) {
			transition_out$c(if_block);
			if (div5_intro) div5_intro.invalidate();

			if (local) {
				div5_outro = create_out_transition(div5, fade, { duration: 200 });
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$d(div5);
			}

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].d();
			}

			if (detaching && div5_outro) div5_outro.end();
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$c($$self, $$props, $$invalidate) {
	let { message = "" } = $$props;
	let { type } = $$props;
	let { id } = $$props;
	const dispatch = createEventDispatcher$5();

	function close_message() {
		dispatch("close", id);
	}

	onMount$3(() => {
		setTimeout(
			() => {
				close_message();
			},
			10000
		);
	});

	function click_handler(event) {
		bubble$4.call(this, $$self, event);
	}

	function keydown_handler(event) {
		bubble$4.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('message' in $$props) $$invalidate(0, message = $$props.message);
		if ('type' in $$props) $$invalidate(1, type = $$props.type);
		if ('id' in $$props) $$invalidate(3, id = $$props.id);
	};

	return [message, type, close_message, id, click_handler, keydown_handler];
}

class ToastContent extends SvelteComponent$e {
	constructor(options) {
		super();
		init$e(this, options, instance$c, create_fragment$e, safe_not_equal$d, { message: 0, type: 1, id: 3 });
	}
}

/* home/runner/work/gradio/gradio/js/statustracker/static/Toast.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$d,
	append: append$9,
	attr: attr$9,
	bubble: bubble$3,
	check_outros: check_outros$7,
	create_animation,
	create_component: create_component$b,
	destroy_component: destroy_component$b,
	detach: detach$c,
	element: element$8,
	ensure_array_like: ensure_array_like$4,
	fix_and_outro_and_destroy_block,
	fix_position,
	group_outros: group_outros$7,
	init: init$d,
	insert: insert$c,
	mount_component: mount_component$b,
	noop: noop$5,
	safe_not_equal: safe_not_equal$c,
	set_style: set_style$2,
	space: space$7,
	transition_in: transition_in$b,
	transition_out: transition_out$b,
	update_keyed_each: update_keyed_each$1
} = window.__gradio__svelte__internal;
function get_each_context$4(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[2] = list[i].type;
	child_ctx[3] = list[i].message;
	child_ctx[4] = list[i].id;
	return child_ctx;
}

// (15:1) {#each messages as { type, message, id }
function create_each_block$4(key_1, ctx) {
	let div;
	let toastcontent;
	let t;
	let rect;
	let stop_animation = noop$5;
	let current;

	toastcontent = new ToastContent({
			props: {
				type: /*type*/ ctx[2],
				message: /*message*/ ctx[3],
				id: /*id*/ ctx[4]
			}
		});

	toastcontent.$on("close", /*close_handler*/ ctx[1]);

	return {
		key: key_1,
		first: null,
		c() {
			div = element$8("div");
			create_component$b(toastcontent.$$.fragment);
			t = space$7();
			set_style$2(div, "width", `100%`);
			this.first = div;
		},
		m(target, anchor) {
			insert$c(target, div, anchor);
			mount_component$b(toastcontent, div, null);
			append$9(div, t);
			current = true;
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			const toastcontent_changes = {};
			if (dirty & /*messages*/ 1) toastcontent_changes.type = /*type*/ ctx[2];
			if (dirty & /*messages*/ 1) toastcontent_changes.message = /*message*/ ctx[3];
			if (dirty & /*messages*/ 1) toastcontent_changes.id = /*id*/ ctx[4];
			toastcontent.$set(toastcontent_changes);
		},
		r() {
			rect = div.getBoundingClientRect();
		},
		f() {
			fix_position(div);
			stop_animation();
		},
		a() {
			stop_animation();
			stop_animation = create_animation(div, rect, flip, { duration: 300 });
		},
		i(local) {
			if (current) return;
			transition_in$b(toastcontent.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$b(toastcontent.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$c(div);
			}

			destroy_component$b(toastcontent);
		}
	};
}

function create_fragment$d(ctx) {
	let div;
	let each_blocks = [];
	let each_1_lookup = new Map();
	let current;
	let each_value = ensure_array_like$4(/*messages*/ ctx[0]);
	const get_key = ctx => /*id*/ ctx[4];

	for (let i = 0; i < each_value.length; i += 1) {
		let child_ctx = get_each_context$4(ctx, each_value, i);
		let key = get_key(child_ctx);
		each_1_lookup.set(key, each_blocks[i] = create_each_block$4(key, child_ctx));
	}

	return {
		c() {
			div = element$8("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr$9(div, "class", "toast-wrap svelte-pu0yf1");
		},
		m(target, anchor) {
			insert$c(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(div, null);
				}
			}

			current = true;
		},
		p(ctx, [dirty]) {
			if (dirty & /*messages*/ 1) {
				each_value = ensure_array_like$4(/*messages*/ ctx[0]);
				group_outros$7();
				for (let i = 0; i < each_blocks.length; i += 1) each_blocks[i].r();
				each_blocks = update_keyed_each$1(each_blocks, dirty, get_key, 1, ctx, each_value, each_1_lookup, div, fix_and_outro_and_destroy_block, create_each_block$4, null, get_each_context$4);
				for (let i = 0; i < each_blocks.length; i += 1) each_blocks[i].a();
				check_outros$7();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in$b(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out$b(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$c(div);
			}

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].d();
			}
		}
	};
}

function scroll_to_top(_messages) {
	if (_messages.length > 0) {
		if ("parentIFrame" in window) {
			window.parentIFrame?.scrollTo(0, 0);
		}
	}
}

function instance$b($$self, $$props, $$invalidate) {
	let { messages = [] } = $$props;

	function close_handler(event) {
		bubble$3.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('messages' in $$props) $$invalidate(0, messages = $$props.messages);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*messages*/ 1) {
			scroll_to_top(messages);
		}
	};

	return [messages, close_handler];
}

class Toast extends SvelteComponent$d {
	constructor(options) {
		super();
		init$d(this, options, instance$b, create_fragment$d, safe_not_equal$c, { messages: 0 });
	}
}

/* src/api_docs/img/clear.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$c,
	append: append$8,
	attr: attr$8,
	detach: detach$b,
	init: init$c,
	insert: insert$b,
	noop: noop$4,
	safe_not_equal: safe_not_equal$b,
	set_style: set_style$1,
	svg_element
} = window.__gradio__svelte__internal;
function create_fragment$c(ctx) {
	let svg;
	let g;
	let path0;
	let path1;

	return {
		c() {
			svg = svg_element("svg");
			g = svg_element("g");
			path0 = svg_element("path");
			path1 = svg_element("path");
			attr$8(path0, "d", "M3.789,0.09C3.903,-0.024 4.088,-0.024 4.202,0.09L4.817,0.705C4.931,0.819 4.931,1.004 4.817,1.118L1.118,4.817C1.004,4.931 0.819,4.931 0.705,4.817L0.09,4.202C-0.024,4.088 -0.024,3.903 0.09,3.789L3.789,0.09Z");
			attr$8(path1, "d", "M4.825,3.797C4.934,3.907 4.934,4.084 4.825,4.193L4.193,4.825C4.084,4.934 3.907,4.934 3.797,4.825L0.082,1.11C-0.027,1.001 -0.027,0.823 0.082,0.714L0.714,0.082C0.823,-0.027 1.001,-0.027 1.11,0.082L4.825,3.797Z");
			attr$8(svg, "width", "100%");
			attr$8(svg, "height", "100%");
			attr$8(svg, "viewBox", "0 0 5 5");
			attr$8(svg, "version", "1.1");
			attr$8(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr$8(svg, "xmlns:xlink", "http://www.w3.org/1999/xlink");
			attr$8(svg, "xml:space", "preserve");
			set_style$1(svg, "fill", "currentColor");
			set_style$1(svg, "fill-rule", "evenodd");
			set_style$1(svg, "clip-rule", "evenodd");
			set_style$1(svg, "stroke-linejoin", "round");
			set_style$1(svg, "stroke-miterlimit", "2");
		},
		m(target, anchor) {
			insert$b(target, svg, anchor);
			append$8(svg, g);
			append$8(g, path0);
			append$8(g, path1);
		},
		p: noop$4,
		i: noop$4,
		o: noop$4,
		d(detaching) {
			if (detaching) {
				detach$b(svg);
			}
		}
	};
}

class Clear extends SvelteComponent$c {
	constructor(options) {
		super();
		init$c(this, options, null, create_fragment$c, safe_not_equal$b, {});
	}
}

const NoApi_svelte_svelte_type_style_lang = '';

/* src/api_docs/NoApi.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$b,
	append: append$7,
	attr: attr$7,
	create_component: create_component$a,
	destroy_component: destroy_component$a,
	detach: detach$a,
	element: element$7,
	init: init$b,
	insert: insert$a,
	listen: listen$3,
	mount_component: mount_component$a,
	safe_not_equal: safe_not_equal$a,
	set_data: set_data$6,
	space: space$6,
	text: text$7,
	transition_in: transition_in$a,
	transition_out: transition_out$a
} = window.__gradio__svelte__internal;
const { createEventDispatcher: createEventDispatcher$4 } = window.__gradio__svelte__internal;
function create_fragment$b(ctx) {
	let div;
	let h1;
	let t1;
	let p0;
	let t2;
	let code0;
	let t3;
	let t4;
	let p1;
	let t15;
	let button;
	let clear;
	let current;
	let mounted;
	let dispose;
	clear = new Clear({});

	return {
		c() {
			div = element$7("div");
			h1 = element$7("h1");
			h1.textContent = "API Docs";
			t1 = space$6();
			p0 = element$7("p");
			t2 = text$7("No API Routes found for\n\t\t");
			code0 = element$7("code");
			t3 = text$7(/*root*/ ctx[0]);
			t4 = space$6();
			p1 = element$7("p");

			p1.innerHTML = `To expose an API endpoint of your app in this page, set the <code>api_name</code>
		parameter of the event listener.
		<br/>
		For more information, visit the
		<a href="https://gradio.app/sharing_your_app/#api-page" target="_blank">API Page guide</a>
		. To hide the API documentation button and this page, set
		<code>show_api=False</code>
		in the
		<code>Blocks.launch()</code>
		method.`;

			t15 = space$6();
			button = element$7("button");
			create_component$a(clear.$$.fragment);
			attr$7(code0, "class", "svelte-e1ha0f");
			attr$7(p0, "class", "attention svelte-e1ha0f");
			attr$7(div, "class", "wrap prose svelte-e1ha0f");
			attr$7(button, "class", "svelte-e1ha0f");
		},
		m(target, anchor) {
			insert$a(target, div, anchor);
			append$7(div, h1);
			append$7(div, t1);
			append$7(div, p0);
			append$7(p0, t2);
			append$7(p0, code0);
			append$7(code0, t3);
			append$7(div, t4);
			append$7(div, p1);
			insert$a(target, t15, anchor);
			insert$a(target, button, anchor);
			mount_component$a(clear, button, null);
			current = true;

			if (!mounted) {
				dispose = listen$3(button, "click", /*click_handler*/ ctx[2]);
				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (!current || dirty & /*root*/ 1) set_data$6(t3, /*root*/ ctx[0]);
		},
		i(local) {
			if (current) return;
			transition_in$a(clear.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$a(clear.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$a(div);
				detach$a(t15);
				detach$a(button);
			}

			destroy_component$a(clear);
			mounted = false;
			dispose();
		}
	};
}

function instance$a($$self, $$props, $$invalidate) {
	const dispatch = createEventDispatcher$4();
	let { root } = $$props;
	const click_handler = () => dispatch("close");

	$$self.$$set = $$props => {
		if ('root' in $$props) $$invalidate(0, root = $$props.root);
	};

	return [root, dispatch, click_handler];
}

class NoApi extends SvelteComponent$b {
	constructor(options) {
		super();
		init$b(this, options, instance$a, create_fragment$b, safe_not_equal$a, { root: 0 });
	}
}

function represent_value(value, type, lang = null) {
  if (type === void 0) {
    return lang === "py" ? "None" : null;
  }
  if (type === "string" || type === "str") {
    return lang === null ? value : '"' + value + '"';
  } else if (type === "number") {
    return lang === null ? parseFloat(value) : value;
  } else if (type === "boolean" || type == "bool") {
    if (lang === "py") {
      value = String(value);
      return value === "true" ? "True" : "False";
    } else if (lang === "js") {
      return value;
    }
    return value === "true";
  } else if (type === "List[str]") {
    value = JSON.stringify(value);
    return value;
  } else if (type.startsWith("Literal['")) {
    return '"' + value + '"';
  }
  if (lang === null) {
    return value === "" ? null : JSON.parse(value);
  } else if (typeof value === "string") {
    if (value === "") {
      return lang === "py" ? "None" : "null";
    }
    return value;
  }
  if (lang === "py") {
    value = replace_file_data_with_file_function(value);
  }
  return stringify_except_file_function(value);
}
function is_potentially_nested_file_data(obj) {
  if (typeof obj === "object" && obj !== null) {
    if (obj.hasOwnProperty("path") && obj.hasOwnProperty("meta")) {
      if (typeof obj.meta === "object" && obj.meta !== null && obj.meta._type === "gradio.FileData") {
        return true;
      }
    }
  }
  if (typeof obj === "object" && obj !== null) {
    for (let key in obj) {
      if (typeof obj[key] === "object") {
        let result = is_potentially_nested_file_data(obj[key]);
        if (result) {
          return true;
        }
      }
    }
  }
  return false;
}
function replace_file_data_with_file_function(obj) {
  if (typeof obj === "object" && obj !== null && !Array.isArray(obj)) {
    if ("path" in obj && "meta" in obj && obj.meta?._type === "gradio.FileData") {
      return `file('${obj.path}')`;
    }
  }
  if (Array.isArray(obj)) {
    obj.forEach((item, index) => {
      if (typeof item === "object" && item !== null) {
        obj[index] = replace_file_data_with_file_function(item);
      }
    });
  } else if (typeof obj === "object" && obj !== null) {
    Object.keys(obj).forEach((key) => {
      obj[key] = replace_file_data_with_file_function(obj[key]);
    });
  }
  return obj;
}
function stringify_except_file_function(obj) {
  const jsonString = JSON.stringify(obj, (key, value) => {
    if (typeof value === "string" && value.startsWith("file(") && value.endsWith(")")) {
      return `UNQUOTED${value}`;
    }
    return value;
  });
  const regex = /"UNQUOTEDfile\(([^)]*)\)"/g;
  return jsonString.replace(regex, (match, p1) => `file(${p1})`);
}

const api_logo = ""+new URL('api-logo-5346f193.svg', import.meta.url).href+"";

const ApiBanner_svelte_svelte_type_style_lang = '';

/* src/api_docs/ApiBanner.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$a,
	append: append$6,
	attr: attr$6,
	create_component: create_component$9,
	destroy_component: destroy_component$9,
	detach: detach$9,
	element: element$6,
	init: init$a,
	insert: insert$9,
	listen: listen$2,
	mount_component: mount_component$9,
	safe_not_equal: safe_not_equal$9,
	set_data: set_data$5,
	space: space$5,
	src_url_equal: src_url_equal$2,
	text: text$6,
	transition_in: transition_in$9,
	transition_out: transition_out$9
} = window.__gradio__svelte__internal;
const { createEventDispatcher: createEventDispatcher$3 } = window.__gradio__svelte__internal;
function create_if_block$7(ctx) {
	let t;

	return {
		c() {
			t = text$6("s");
		},
		m(target, anchor) {
			insert$9(target, t, anchor);
		},
		d(detaching) {
			if (detaching) {
				detach$9(t);
			}
		}
	};
}

function create_fragment$a(ctx) {
	let h2;
	let img;
	let img_src_value;
	let t0;
	let div1;
	let t1;
	let div0;
	let t2;
	let t3;
	let span1;
	let span0;
	let t4;
	let t5;
	let t6;
	let button;
	let clear;
	let current;
	let mounted;
	let dispose;
	let if_block = /*api_count*/ ctx[1] > 1 && create_if_block$7();
	clear = new Clear({});

	return {
		c() {
			h2 = element$6("h2");
			img = element$6("img");
			t0 = space$5();
			div1 = element$6("div");
			t1 = text$6("API documentation\n\t\t");
			div0 = element$6("div");
			t2 = text$6(/*root*/ ctx[0]);
			t3 = space$5();
			span1 = element$6("span");
			span0 = element$6("span");
			t4 = text$6(/*api_count*/ ctx[1]);
			t5 = text$6(" API endpoint");
			if (if_block) if_block.c();
			t6 = space$5();
			button = element$6("button");
			create_component$9(clear.$$.fragment);
			if (!src_url_equal$2(img.src, img_src_value = api_logo)) attr$6(img, "src", img_src_value);
			attr$6(img, "alt", "");
			attr$6(img, "class", "svelte-3n2nxs");
			attr$6(div0, "class", "url svelte-3n2nxs");
			attr$6(span0, "class", "url svelte-3n2nxs");
			attr$6(span1, "class", "counts svelte-3n2nxs");
			attr$6(h2, "class", "svelte-3n2nxs");
			attr$6(button, "class", "svelte-3n2nxs");
		},
		m(target, anchor) {
			insert$9(target, h2, anchor);
			append$6(h2, img);
			append$6(h2, t0);
			append$6(h2, div1);
			append$6(div1, t1);
			append$6(div1, div0);
			append$6(div0, t2);
			append$6(h2, t3);
			append$6(h2, span1);
			append$6(span1, span0);
			append$6(span0, t4);
			append$6(span1, t5);
			if (if_block) if_block.m(span1, null);
			insert$9(target, t6, anchor);
			insert$9(target, button, anchor);
			mount_component$9(clear, button, null);
			current = true;

			if (!mounted) {
				dispose = listen$2(button, "click", /*click_handler*/ ctx[3]);
				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (!current || dirty & /*root*/ 1) set_data$5(t2, /*root*/ ctx[0]);
			if (!current || dirty & /*api_count*/ 2) set_data$5(t4, /*api_count*/ ctx[1]);

			if (/*api_count*/ ctx[1] > 1) {
				if (if_block) ; else {
					if_block = create_if_block$7();
					if_block.c();
					if_block.m(span1, null);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},
		i(local) {
			if (current) return;
			transition_in$9(clear.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$9(clear.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$9(h2);
				detach$9(t6);
				detach$9(button);
			}

			if (if_block) if_block.d();
			destroy_component$9(clear);
			mounted = false;
			dispose();
		}
	};
}

function instance$9($$self, $$props, $$invalidate) {
	let { root } = $$props;
	let { api_count } = $$props;
	const dispatch = createEventDispatcher$3();
	const click_handler = () => dispatch("close");

	$$self.$$set = $$props => {
		if ('root' in $$props) $$invalidate(0, root = $$props.root);
		if ('api_count' in $$props) $$invalidate(1, api_count = $$props.api_count);
	};

	return [root, api_count, dispatch, click_handler];
}

class ApiBanner extends SvelteComponent$a {
	constructor(options) {
		super();
		init$a(this, options, instance$9, create_fragment$a, safe_not_equal$9, { root: 0, api_count: 1 });
	}
}

const ResponseObject_svelte_svelte_type_style_lang = '';

/* src/api_docs/ResponseObject.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$9,
	append: append$5,
	attr: attr$5,
	check_outros: check_outros$6,
	create_component: create_component$8,
	destroy_component: destroy_component$8,
	destroy_each: destroy_each$2,
	detach: detach$8,
	element: element$5,
	empty: empty$6,
	ensure_array_like: ensure_array_like$3,
	group_outros: group_outros$6,
	init: init$9,
	insert: insert$8,
	mount_component: mount_component$8,
	safe_not_equal: safe_not_equal$8,
	set_data: set_data$4,
	space: space$4,
	text: text$5,
	toggle_class,
	transition_in: transition_in$8,
	transition_out: transition_out$8
} = window.__gradio__svelte__internal;
function get_each_context$3(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[4] = list[i].label;
	child_ctx[5] = list[i].type;
	child_ctx[6] = list[i].python_type;
	child_ctx[7] = list[i].component;
	child_ctx[8] = list[i].serializer;
	child_ctx[10] = i;
	return child_ctx;
}

// (18:3) {#if endpoint_returns.length > 1}
function create_if_block_6$2(ctx) {
	let t;

	return {
		c() {
			t = text$5("(");
		},
		m(target, anchor) {
			insert$8(target, t, anchor);
		},
		d(detaching) {
			if (detaching) {
				detach$8(t);
			}
		}
	};
}

// (23:132) {:else}
function create_else_block$3(ctx) {
	let t_value = /*js_returns*/ ctx[2][/*i*/ ctx[10]].type + "";
	let t;
	let if_block_anchor;
	let if_block = /*js_returns*/ ctx[2][/*i*/ ctx[10]].description && create_if_block_5$2(ctx);

	return {
		c() {
			t = text$5(t_value);
			if (if_block) if_block.c();
			if_block_anchor = empty$6();
		},
		m(target, anchor) {
			insert$8(target, t, anchor);
			if (if_block) if_block.m(target, anchor);
			insert$8(target, if_block_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*js_returns*/ 4 && t_value !== (t_value = /*js_returns*/ ctx[2][/*i*/ ctx[10]].type + "")) set_data$4(t, t_value);

			if (/*js_returns*/ ctx[2][/*i*/ ctx[10]].description) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block_5$2(ctx);
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},
		d(detaching) {
			if (detaching) {
				detach$8(t);
				detach$8(if_block_anchor);
			}

			if (if_block) if_block.d(detaching);
		}
	};
}

// (23:11) {#if current_language === "python"}
function create_if_block_3$3(ctx) {
	let t_value = /*python_type*/ ctx[6].type + "";
	let t;
	let if_block_anchor;
	let if_block = /*python_type*/ ctx[6]?.description && create_if_block_4$2(ctx);

	return {
		c() {
			t = text$5(t_value);
			if (if_block) if_block.c();
			if_block_anchor = empty$6();
		},
		m(target, anchor) {
			insert$8(target, t, anchor);
			if (if_block) if_block.m(target, anchor);
			insert$8(target, if_block_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*endpoint_returns*/ 2 && t_value !== (t_value = /*python_type*/ ctx[6].type + "")) set_data$4(t, t_value);

			if (/*python_type*/ ctx[6]?.description) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block_4$2(ctx);
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}
		},
		d(detaching) {
			if (detaching) {
				detach$8(t);
				detach$8(if_block_anchor);
			}

			if (if_block) if_block.d(detaching);
		}
	};
}

// (25:14) {#if js_returns[i].description}
function create_if_block_5$2(ctx) {
	let t0;
	let t1_value = /*js_returns*/ ctx[2][/*i*/ ctx[10]].description + "";
	let t1;
	let t2;

	return {
		c() {
			t0 = text$5(" (");
			t1 = text$5(t1_value);
			t2 = text$5(")");
		},
		m(target, anchor) {
			insert$8(target, t0, anchor);
			insert$8(target, t1, anchor);
			insert$8(target, t2, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*js_returns*/ 4 && t1_value !== (t1_value = /*js_returns*/ ctx[2][/*i*/ ctx[10]].description + "")) set_data$4(t1, t1_value);
		},
		d(detaching) {
			if (detaching) {
				detach$8(t0);
				detach$8(t1);
				detach$8(t2);
			}
		}
	};
}

// (23:64) {#if python_type?.description}
function create_if_block_4$2(ctx) {
	let t0;
	let t1_value = /*python_type*/ ctx[6].description + "";
	let t1;
	let t2;

	return {
		c() {
			t0 = text$5(" (");
			t1 = text$5(t1_value);
			t2 = text$5(")");
		},
		m(target, anchor) {
			insert$8(target, t0, anchor);
			insert$8(target, t1, anchor);
			insert$8(target, t2, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*endpoint_returns*/ 2 && t1_value !== (t1_value = /*python_type*/ ctx[6].description + "")) set_data$4(t1, t1_value);
		},
		d(detaching) {
			if (detaching) {
				detach$8(t0);
				detach$8(t1);
				detach$8(t2);
			}
		}
	};
}

// (32:6) {#if endpoint_returns.length > 1}
function create_if_block_2$3(ctx) {
	let t;

	return {
		c() {
			t = text$5(",");
		},
		m(target, anchor) {
			insert$8(target, t, anchor);
		},
		d(detaching) {
			if (detaching) {
				detach$8(t);
			}
		}
	};
}

// (19:3) {#each endpoint_returns as { label, type, python_type, component, serializer }
function create_each_block$3(ctx) {
	let div;
	let span;
	let t0;
	let t1;
	let t2_value = /*label*/ ctx[4] + "";
	let t2;
	let t3;
	let t4_value = /*component*/ ctx[7] + "";
	let t4;
	let t5;

	function select_block_type(ctx, dirty) {
		if (/*current_language*/ ctx[3] === "python") return create_if_block_3$3;
		return create_else_block$3;
	}

	let current_block_type = select_block_type(ctx);
	let if_block0 = current_block_type(ctx);
	let if_block1 = /*endpoint_returns*/ ctx[1].length > 1 && create_if_block_2$3();

	return {
		c() {
			div = element$5("div");
			span = element$5("span");
			t0 = text$5("# ");
			if_block0.c();
			t1 = text$5("\n\t\t\t\t\t\trepresenting output in '");
			t2 = text$5(t2_value);
			t3 = text$5("' ");
			t4 = text$5(t4_value);
			t5 = text$5("\n\t\t\t\t\t\tcomponent");
			if (if_block1) if_block1.c();
			attr$5(span, "class", "desc svelte-1c7hj3i");
			attr$5(div, "class", "svelte-1c7hj3i");
			toggle_class(div, "second-level", /*endpoint_returns*/ ctx[1].length > 1);
		},
		m(target, anchor) {
			insert$8(target, div, anchor);
			append$5(div, span);
			append$5(span, t0);
			if_block0.m(span, null);
			append$5(span, t1);
			append$5(span, t2);
			append$5(span, t3);
			append$5(span, t4);
			append$5(span, t5);
			if (if_block1) if_block1.m(div, null);
		},
		p(ctx, dirty) {
			if (current_block_type === (current_block_type = select_block_type(ctx)) && if_block0) {
				if_block0.p(ctx, dirty);
			} else {
				if_block0.d(1);
				if_block0 = current_block_type(ctx);

				if (if_block0) {
					if_block0.c();
					if_block0.m(span, t1);
				}
			}

			if (dirty & /*endpoint_returns*/ 2 && t2_value !== (t2_value = /*label*/ ctx[4] + "")) set_data$4(t2, t2_value);
			if (dirty & /*endpoint_returns*/ 2 && t4_value !== (t4_value = /*component*/ ctx[7] + "")) set_data$4(t4, t4_value);

			if (/*endpoint_returns*/ ctx[1].length > 1) {
				if (if_block1) ; else {
					if_block1 = create_if_block_2$3();
					if_block1.c();
					if_block1.m(div, null);
				}
			} else if (if_block1) {
				if_block1.d(1);
				if_block1 = null;
			}

			if (dirty & /*endpoint_returns*/ 2) {
				toggle_class(div, "second-level", /*endpoint_returns*/ ctx[1].length > 1);
			}
		},
		d(detaching) {
			if (detaching) {
				detach$8(div);
			}

			if_block0.d();
			if (if_block1) if_block1.d();
		}
	};
}

// (35:3) {#if endpoint_returns.length > 1}
function create_if_block_1$4(ctx) {
	let t;

	return {
		c() {
			t = text$5(")");
		},
		m(target, anchor) {
			insert$8(target, t, anchor);
		},
		d(detaching) {
			if (detaching) {
				detach$8(t);
			}
		}
	};
}

// (37:2) {#if is_running}
function create_if_block$6(ctx) {
	let div;
	let loader;
	let current;
	loader = new Loader({ props: { margin: false } });

	return {
		c() {
			div = element$5("div");
			create_component$8(loader.$$.fragment);
			attr$5(div, "class", "load-wrap svelte-1c7hj3i");
		},
		m(target, anchor) {
			insert$8(target, div, anchor);
			mount_component$8(loader, div, null);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in$8(loader.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$8(loader.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$8(div);
			}

			destroy_component$8(loader);
		}
	};
}

// (15:0) <Block>
function create_default_slot$5(ctx) {
	let div1;
	let div0;
	let t0;
	let t1;
	let t2;
	let current;
	let if_block0 = /*endpoint_returns*/ ctx[1].length > 1 && create_if_block_6$2();
	let each_value = ensure_array_like$3(/*endpoint_returns*/ ctx[1]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$3(get_each_context$3(ctx, each_value, i));
	}

	let if_block1 = /*endpoint_returns*/ ctx[1].length > 1 && create_if_block_1$4();
	let if_block2 = /*is_running*/ ctx[0] && create_if_block$6();

	return {
		c() {
			div1 = element$5("div");
			div0 = element$5("div");
			if (if_block0) if_block0.c();
			t0 = space$4();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t1 = space$4();
			if (if_block1) if_block1.c();
			t2 = space$4();
			if (if_block2) if_block2.c();
			attr$5(div0, "class", "svelte-1c7hj3i");
			toggle_class(div0, "hide", /*is_running*/ ctx[0]);
			attr$5(div1, "class", "response-wrap svelte-1c7hj3i");
		},
		m(target, anchor) {
			insert$8(target, div1, anchor);
			append$5(div1, div0);
			if (if_block0) if_block0.m(div0, null);
			append$5(div0, t0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(div0, null);
				}
			}

			append$5(div0, t1);
			if (if_block1) if_block1.m(div0, null);
			append$5(div1, t2);
			if (if_block2) if_block2.m(div1, null);
			current = true;
		},
		p(ctx, dirty) {
			if (/*endpoint_returns*/ ctx[1].length > 1) {
				if (if_block0) ; else {
					if_block0 = create_if_block_6$2();
					if_block0.c();
					if_block0.m(div0, t0);
				}
			} else if (if_block0) {
				if_block0.d(1);
				if_block0 = null;
			}

			if (dirty & /*endpoint_returns, current_language, js_returns*/ 14) {
				each_value = ensure_array_like$3(/*endpoint_returns*/ ctx[1]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$3(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$3(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div0, t1);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (/*endpoint_returns*/ ctx[1].length > 1) {
				if (if_block1) ; else {
					if_block1 = create_if_block_1$4();
					if_block1.c();
					if_block1.m(div0, null);
				}
			} else if (if_block1) {
				if_block1.d(1);
				if_block1 = null;
			}

			if (!current || dirty & /*is_running*/ 1) {
				toggle_class(div0, "hide", /*is_running*/ ctx[0]);
			}

			if (/*is_running*/ ctx[0]) {
				if (if_block2) {
					if (dirty & /*is_running*/ 1) {
						transition_in$8(if_block2, 1);
					}
				} else {
					if_block2 = create_if_block$6();
					if_block2.c();
					transition_in$8(if_block2, 1);
					if_block2.m(div1, null);
				}
			} else if (if_block2) {
				group_outros$6();

				transition_out$8(if_block2, 1, 1, () => {
					if_block2 = null;
				});

				check_outros$6();
			}
		},
		i(local) {
			if (current) return;
			transition_in$8(if_block2);
			current = true;
		},
		o(local) {
			transition_out$8(if_block2);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$8(div1);
			}

			if (if_block0) if_block0.d();
			destroy_each$2(each_blocks, detaching);
			if (if_block1) if_block1.d();
			if (if_block2) if_block2.d();
		}
	};
}

function create_fragment$9(ctx) {
	let h4;
	let t1;
	let block;
	let current;

	block = new Block({
			props: {
				$$slots: { default: [create_default_slot$5] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			h4 = element$5("h4");

			h4.innerHTML = `<div class="toggle-icon svelte-1c7hj3i"><div class="toggle-dot svelte-1c7hj3i"></div></div>
	Return Type(s)`;

			t1 = space$4();
			create_component$8(block.$$.fragment);
			attr$5(h4, "class", "svelte-1c7hj3i");
		},
		m(target, anchor) {
			insert$8(target, h4, anchor);
			insert$8(target, t1, anchor);
			mount_component$8(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};

			if (dirty & /*$$scope, is_running, endpoint_returns, current_language, js_returns*/ 2063) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in$8(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$8(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$8(h4);
				detach$8(t1);
			}

			destroy_component$8(block, detaching);
		}
	};
}

function instance$8($$self, $$props, $$invalidate) {
	let { is_running } = $$props;
	let { endpoint_returns } = $$props;
	let { js_returns } = $$props;
	let { current_language } = $$props;

	$$self.$$set = $$props => {
		if ('is_running' in $$props) $$invalidate(0, is_running = $$props.is_running);
		if ('endpoint_returns' in $$props) $$invalidate(1, endpoint_returns = $$props.endpoint_returns);
		if ('js_returns' in $$props) $$invalidate(2, js_returns = $$props.js_returns);
		if ('current_language' in $$props) $$invalidate(3, current_language = $$props.current_language);
	};

	return [is_running, endpoint_returns, js_returns, current_language];
}

class ResponseObject extends SvelteComponent$9 {
	constructor(options) {
		super();

		init$9(this, options, instance$8, create_fragment$9, safe_not_equal$8, {
			is_running: 0,
			endpoint_returns: 1,
			js_returns: 2,
			current_language: 3
		});
	}
}

/* src/api_docs/CopyButton.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$8,
	create_component: create_component$7,
	destroy_component: destroy_component$7,
	detach: detach$7,
	init: init$8,
	insert: insert$7,
	mount_component: mount_component$7,
	safe_not_equal: safe_not_equal$7,
	set_data: set_data$3,
	text: text$4,
	transition_in: transition_in$7,
	transition_out: transition_out$7
} = window.__gradio__svelte__internal;
function create_default_slot$4(ctx) {
	let t;

	return {
		c() {
			t = text$4(/*copy_text*/ ctx[0]);
		},
		m(target, anchor) {
			insert$7(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*copy_text*/ 1) set_data$3(t, /*copy_text*/ ctx[0]);
		},
		d(detaching) {
			if (detaching) {
				detach$7(t);
			}
		}
	};
}

function create_fragment$8(ctx) {
	let basebutton;
	let current;

	basebutton = new Button({
			props: {
				size: "sm",
				$$slots: { default: [create_default_slot$4] },
				$$scope: { ctx }
			}
		});

	basebutton.$on("click", /*copy*/ ctx[1]);

	return {
		c() {
			create_component$7(basebutton.$$.fragment);
		},
		m(target, anchor) {
			mount_component$7(basebutton, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const basebutton_changes = {};

			if (dirty & /*$$scope, copy_text*/ 9) {
				basebutton_changes.$$scope = { dirty, ctx };
			}

			basebutton.$set(basebutton_changes);
		},
		i(local) {
			if (current) return;
			transition_in$7(basebutton.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$7(basebutton.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$7(basebutton, detaching);
		}
	};
}

function instance$7($$self, $$props, $$invalidate) {
	let { code } = $$props;
	let copy_text = "copy";

	function copy() {
		navigator.clipboard.writeText(code);
		$$invalidate(0, copy_text = "copied!");

		setTimeout(
			() => {
				$$invalidate(0, copy_text = "copy");
			},
			1500
		);
	}

	$$self.$$set = $$props => {
		if ('code' in $$props) $$invalidate(2, code = $$props.code);
	};

	return [copy_text, copy, code];
}

class CopyButton extends SvelteComponent$8 {
	constructor(options) {
		super();
		init$8(this, options, instance$7, create_fragment$8, safe_not_equal$7, { code: 2 });
	}
}

const InstallSnippet_svelte_svelte_type_style_lang = '';

/* src/api_docs/InstallSnippet.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$7,
	append: append$4,
	attr: attr$4,
	check_outros: check_outros$5,
	create_component: create_component$6,
	destroy_component: destroy_component$6,
	detach: detach$6,
	element: element$4,
	group_outros: group_outros$5,
	init: init$7,
	insert: insert$6,
	mount_component: mount_component$6,
	noop: noop$3,
	safe_not_equal: safe_not_equal$6,
	space: space$3,
	transition_in: transition_in$6,
	transition_out: transition_out$6
} = window.__gradio__svelte__internal;
function create_if_block_1$3(ctx) {
	let div0;
	let copybutton;
	let t0;
	let div1;
	let pre;
	let current;
	copybutton = new CopyButton({ props: { code: js_install } });

	return {
		c() {
			div0 = element$4("div");
			create_component$6(copybutton.$$.fragment);
			t0 = space$3();
			div1 = element$4("div");
			pre = element$4("pre");
			pre.textContent = `\$ ${js_install}`;
			attr$4(div0, "class", "copy svelte-hq8ezf");
			attr$4(pre, "class", "svelte-hq8ezf");
		},
		m(target, anchor) {
			insert$6(target, div0, anchor);
			mount_component$6(copybutton, div0, null);
			insert$6(target, t0, anchor);
			insert$6(target, div1, anchor);
			append$4(div1, pre);
			current = true;
		},
		p: noop$3,
		i(local) {
			if (current) return;
			transition_in$6(copybutton.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$6(copybutton.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$6(div0);
				detach$6(t0);
				detach$6(div1);
			}

			destroy_component$6(copybutton);
		}
	};
}

// (10:2) {#if current_language === "python"}
function create_if_block$5(ctx) {
	let div0;
	let copybutton;
	let t0;
	let div1;
	let pre;
	let current;
	copybutton = new CopyButton({ props: { code: py_install } });

	return {
		c() {
			div0 = element$4("div");
			create_component$6(copybutton.$$.fragment);
			t0 = space$3();
			div1 = element$4("div");
			pre = element$4("pre");
			pre.textContent = `\$ ${py_install}`;
			attr$4(div0, "class", "copy svelte-hq8ezf");
			attr$4(pre, "class", "svelte-hq8ezf");
		},
		m(target, anchor) {
			insert$6(target, div0, anchor);
			mount_component$6(copybutton, div0, null);
			insert$6(target, t0, anchor);
			insert$6(target, div1, anchor);
			append$4(div1, pre);
			current = true;
		},
		p: noop$3,
		i(local) {
			if (current) return;
			transition_in$6(copybutton.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$6(copybutton.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$6(div0);
				detach$6(t0);
				detach$6(div1);
			}

			destroy_component$6(copybutton);
		}
	};
}

// (8:0) <Block>
function create_default_slot$3(ctx) {
	let code;
	let current_block_type_index;
	let if_block;
	let current;
	const if_block_creators = [create_if_block$5, create_if_block_1$3];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*current_language*/ ctx[0] === "python") return 0;
		if (/*current_language*/ ctx[0] === "javascript") return 1;
		return -1;
	}

	if (~(current_block_type_index = select_block_type(ctx))) {
		if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	}

	return {
		c() {
			code = element$4("code");
			if (if_block) if_block.c();
			attr$4(code, "class", "svelte-hq8ezf");
		},
		m(target, anchor) {
			insert$6(target, code, anchor);

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].m(code, null);
			}

			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if (~current_block_type_index) {
					if_blocks[current_block_type_index].p(ctx, dirty);
				}
			} else {
				if (if_block) {
					group_outros$5();

					transition_out$6(if_blocks[previous_block_index], 1, 1, () => {
						if_blocks[previous_block_index] = null;
					});

					check_outros$5();
				}

				if (~current_block_type_index) {
					if_block = if_blocks[current_block_type_index];

					if (!if_block) {
						if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
						if_block.c();
					} else {
						if_block.p(ctx, dirty);
					}

					transition_in$6(if_block, 1);
					if_block.m(code, null);
				} else {
					if_block = null;
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in$6(if_block);
			current = true;
		},
		o(local) {
			transition_out$6(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$6(code);
			}

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].d();
			}
		}
	};
}

function create_fragment$7(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				$$slots: { default: [create_default_slot$3] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component$6(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component$6(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};

			if (dirty & /*$$scope, current_language*/ 3) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in$6(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$6(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$6(block, detaching);
		}
	};
}

let py_install = "pip install gradio_client";
let js_install = "npm i -D @gradio/client";

function instance$6($$self, $$props, $$invalidate) {
	let { current_language } = $$props;

	$$self.$$set = $$props => {
		if ('current_language' in $$props) $$invalidate(0, current_language = $$props.current_language);
	};

	return [current_language];
}

class InstallSnippet extends SvelteComponent$7 {
	constructor(options) {
		super();
		init$7(this, options, instance$6, create_fragment$7, safe_not_equal$6, { current_language: 0 });
	}
}

const EndpointDetail_svelte_svelte_type_style_lang = '';

/* src/api_docs/EndpointDetail.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$6,
	append: append$3,
	attr: attr$3,
	detach: detach$5,
	element: element$3,
	empty: empty$5,
	init: init$6,
	insert: insert$5,
	noop: noop$2,
	safe_not_equal: safe_not_equal$5,
	set_data: set_data$2,
	text: text$3
} = window.__gradio__svelte__internal;
function create_else_block$2(ctx) {
	let h3;
	let t0;
	let span;
	let t1;

	return {
		c() {
			h3 = element$3("h3");
			t0 = text$3("fn_index:\n\t\t");
			span = element$3("span");
			t1 = text$3(/*fn_index*/ ctx[1]);
			attr$3(span, "class", "post svelte-41kcm6");
			attr$3(h3, "class", "svelte-41kcm6");
		},
		m(target, anchor) {
			insert$5(target, h3, anchor);
			append$3(h3, t0);
			append$3(h3, span);
			append$3(span, t1);
		},
		p(ctx, dirty) {
			if (dirty & /*fn_index*/ 2) set_data$2(t1, /*fn_index*/ ctx[1]);
		},
		d(detaching) {
			if (detaching) {
				detach$5(h3);
			}
		}
	};
}

// (6:0) {#if named}
function create_if_block$4(ctx) {
	let h3;
	let t0;
	let span;
	let t1_value = "/" + /*api_name*/ ctx[0] + "";
	let t1;

	return {
		c() {
			h3 = element$3("h3");
			t0 = text$3("api_name:\n\t\t");
			span = element$3("span");
			t1 = text$3(t1_value);
			attr$3(span, "class", "post svelte-41kcm6");
			attr$3(h3, "class", "svelte-41kcm6");
		},
		m(target, anchor) {
			insert$5(target, h3, anchor);
			append$3(h3, t0);
			append$3(h3, span);
			append$3(span, t1);
		},
		p(ctx, dirty) {
			if (dirty & /*api_name*/ 1 && t1_value !== (t1_value = "/" + /*api_name*/ ctx[0] + "")) set_data$2(t1, t1_value);
		},
		d(detaching) {
			if (detaching) {
				detach$5(h3);
			}
		}
	};
}

function create_fragment$6(ctx) {
	let if_block_anchor;

	function select_block_type(ctx, dirty) {
		if (/*named*/ ctx[2]) return create_if_block$4;
		return create_else_block$2;
	}

	let current_block_type = select_block_type(ctx);
	let if_block = current_block_type(ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty$5();
		},
		m(target, anchor) {
			if_block.m(target, anchor);
			insert$5(target, if_block_anchor, anchor);
		},
		p(ctx, [dirty]) {
			if (current_block_type === (current_block_type = select_block_type(ctx)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			}
		},
		i: noop$2,
		o: noop$2,
		d(detaching) {
			if (detaching) {
				detach$5(if_block_anchor);
			}

			if_block.d(detaching);
		}
	};
}

function instance$5($$self, $$props, $$invalidate) {
	let { api_name = null } = $$props;
	let { fn_index = null } = $$props;
	let { named } = $$props;

	$$self.$$set = $$props => {
		if ('api_name' in $$props) $$invalidate(0, api_name = $$props.api_name);
		if ('fn_index' in $$props) $$invalidate(1, fn_index = $$props.fn_index);
		if ('named' in $$props) $$invalidate(2, named = $$props.named);
	};

	return [api_name, fn_index, named];
}

class EndpointDetail extends SvelteComponent$6 {
	constructor(options) {
		super();
		init$6(this, options, instance$5, create_fragment$6, safe_not_equal$5, { api_name: 0, fn_index: 1, named: 2 });
	}
}

const CodeSnippets_svelte_svelte_type_style_lang = '';

/* src/api_docs/CodeSnippets.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$5,
	append: append$2,
	attr: attr$2,
	binding_callbacks: binding_callbacks$2,
	check_outros: check_outros$4,
	create_component: create_component$5,
	destroy_component: destroy_component$5,
	destroy_each: destroy_each$1,
	detach: detach$4,
	element: element$2,
	empty: empty$4,
	ensure_array_like: ensure_array_like$2,
	group_outros: group_outros$4,
	init: init$5,
	insert: insert$4,
	mount_component: mount_component$5,
	noop: noop$1,
	safe_not_equal: safe_not_equal$4,
	set_data: set_data$1,
	space: space$2,
	text: text$2,
	transition_in: transition_in$5,
	transition_out: transition_out$5
} = window.__gradio__svelte__internal;
function get_each_context_1$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[15] = list[i].label;
	child_ctx[16] = list[i].type;
	child_ctx[17] = list[i].python_type;
	child_ctx[18] = list[i].component;
	child_ctx[19] = list[i].example_input;
	child_ctx[20] = list[i].serializer;
	child_ctx[22] = i;
	return child_ctx;
}

function get_each_context_2(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[15] = list[i].label;
	child_ctx[16] = list[i].type;
	child_ctx[17] = list[i].python_type;
	child_ctx[18] = list[i].component;
	child_ctx[19] = list[i].example_input;
	child_ctx[20] = list[i].serializer;
	child_ctx[22] = i;
	return child_ctx;
}

function get_each_context$2(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[15] = list[i].label;
	child_ctx[16] = list[i].type;
	child_ctx[17] = list[i].python_type;
	child_ctx[18] = list[i].component;
	child_ctx[19] = list[i].example_input;
	child_ctx[20] = list[i].serializer;
	child_ctx[22] = i;
	return child_ctx;
}

// (23:1) {:else}
function create_else_block_2(ctx) {
	let endpointdetail;
	let current;

	endpointdetail = new EndpointDetail({
			props: {
				named: /*named*/ ctx[6],
				fn_index: /*dependency_index*/ ctx[1]
			}
		});

	return {
		c() {
			create_component$5(endpointdetail.$$.fragment);
		},
		m(target, anchor) {
			mount_component$5(endpointdetail, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const endpointdetail_changes = {};
			if (dirty & /*named*/ 64) endpointdetail_changes.named = /*named*/ ctx[6];
			if (dirty & /*dependency_index*/ 2) endpointdetail_changes.fn_index = /*dependency_index*/ ctx[1];
			endpointdetail.$set(endpointdetail_changes);
		},
		i(local) {
			if (current) return;
			transition_in$5(endpointdetail.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$5(endpointdetail.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$5(endpointdetail, detaching);
		}
	};
}

// (21:1) {#if named}
function create_if_block_8(ctx) {
	let endpointdetail;
	let current;

	endpointdetail = new EndpointDetail({
			props: {
				named: /*named*/ ctx[6],
				api_name: /*dependency*/ ctx[0].api_name
			}
		});

	return {
		c() {
			create_component$5(endpointdetail.$$.fragment);
		},
		m(target, anchor) {
			mount_component$5(endpointdetail, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const endpointdetail_changes = {};
			if (dirty & /*named*/ 64) endpointdetail_changes.named = /*named*/ ctx[6];
			if (dirty & /*dependency*/ 1) endpointdetail_changes.api_name = /*dependency*/ ctx[0].api_name;
			endpointdetail.$set(endpointdetail_changes);
		},
		i(local) {
			if (current) return;
			transition_in$5(endpointdetail.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$5(endpointdetail.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$5(endpointdetail, detaching);
		}
	};
}

// (63:47) 
function create_if_block_4$1(ctx) {
	let div0;
	let copybutton;
	let t0;
	let div1;
	let pre;
	let t1;
	let t2;
	let span;
	let t3;
	let t4;
	let t5;
	let t6;
	let t7;
	let t8;
	let current;

	copybutton = new CopyButton({
			props: { code: /*js_code*/ ctx[9]?.innerText }
		});

	let each_value_2 = ensure_array_like$2(/*blob_examples*/ ctx[12]);
	let each_blocks_1 = [];

	for (let i = 0; i < each_value_2.length; i += 1) {
		each_blocks_1[i] = create_each_block_2(get_each_context_2(ctx, each_value_2, i));
	}

	function select_block_type_2(ctx, dirty) {
		if (/*named*/ ctx[6]) return create_if_block_7;
		return create_else_block_1;
	}

	let current_block_type = select_block_type_2(ctx);
	let if_block = current_block_type(ctx);
	let each_value_1 = ensure_array_like$2(/*endpoint_parameters*/ ctx[4]);
	let each_blocks = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks[i] = create_each_block_1$1(get_each_context_1$1(ctx, each_value_1, i));
	}

	return {
		c() {
			div0 = element$2("div");
			create_component$5(copybutton.$$.fragment);
			t0 = space$2();
			div1 = element$2("div");
			pre = element$2("pre");
			t1 = text$2("import { client } from \"@gradio/client\";\n");

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].c();
			}

			t2 = text$2("\nconst app = await client(");
			span = element$2("span");
			t3 = text$2("\"");
			t4 = text$2(/*root*/ ctx[2]);
			t5 = text$2("\"");
			t6 = text$2(");\nconst result = await app.predict(");
			if_block.c();
			t7 = text$2(", [");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t8 = text$2("\n\t]);\n\nconsole.log(result.data);\n");
			attr$2(div0, "class", "copy svelte-1d98qmk");
			attr$2(span, "class", "token string svelte-1d98qmk");
			attr$2(pre, "class", "svelte-1d98qmk");
		},
		m(target, anchor) {
			insert$4(target, div0, anchor);
			mount_component$5(copybutton, div0, null);
			insert$4(target, t0, anchor);
			insert$4(target, div1, anchor);
			append$2(div1, pre);
			append$2(pre, t1);

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				if (each_blocks_1[i]) {
					each_blocks_1[i].m(pre, null);
				}
			}

			append$2(pre, t2);
			append$2(pre, span);
			append$2(span, t3);
			append$2(span, t4);
			append$2(span, t5);
			append$2(pre, t6);
			if_block.m(pre, null);
			append$2(pre, t7);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(pre, null);
				}
			}

			append$2(pre, t8);
			/*div1_binding_1*/ ctx[14](div1);
			current = true;
		},
		p(ctx, dirty) {
			const copybutton_changes = {};
			if (dirty & /*js_code*/ 512) copybutton_changes.code = /*js_code*/ ctx[9]?.innerText;
			copybutton.$set(copybutton_changes);

			if (dirty & /*blob_examples*/ 4096) {
				each_value_2 = ensure_array_like$2(/*blob_examples*/ ctx[12]);
				let i;

				for (i = 0; i < each_value_2.length; i += 1) {
					const child_ctx = get_each_context_2(ctx, each_value_2, i);

					if (each_blocks_1[i]) {
						each_blocks_1[i].p(child_ctx, dirty);
					} else {
						each_blocks_1[i] = create_each_block_2(child_ctx);
						each_blocks_1[i].c();
						each_blocks_1[i].m(pre, t2);
					}
				}

				for (; i < each_blocks_1.length; i += 1) {
					each_blocks_1[i].d(1);
				}

				each_blocks_1.length = each_value_2.length;
			}

			if (!current || dirty & /*root*/ 4) set_data$1(t4, /*root*/ ctx[2]);

			if (current_block_type === (current_block_type = select_block_type_2(ctx)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(pre, t7);
				}
			}

			if (dirty & /*endpoint_parameters, blob_components, js_parameters*/ 2096) {
				each_value_1 = ensure_array_like$2(/*endpoint_parameters*/ ctx[4]);
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1$1(ctx, each_value_1, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_1$1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(pre, t8);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_1.length;
			}
		},
		i(local) {
			if (current) return;
			transition_in$5(copybutton.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$5(copybutton.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$4(div0);
				detach$4(t0);
				detach$4(div1);
			}

			destroy_component$5(copybutton);
			destroy_each$1(each_blocks_1, detaching);
			if_block.d();
			destroy_each$1(each_blocks, detaching);
			/*div1_binding_1*/ ctx[14](null);
		}
	};
}

// (28:3) {#if current_language === "python"}
function create_if_block$3(ctx) {
	let div0;
	let copybutton;
	let t0;
	let div1;
	let pre;
	let t1;
	let t2;
	let span;
	let t3;
	let t4;
	let t5;
	let t6;
	let t7;
	let t8_value = /*dependency*/ ctx[0].api_name + "";
	let t8;
	let t9;
	let current;

	copybutton = new CopyButton({
			props: { code: /*python_code*/ ctx[8]?.innerText }
		});

	let if_block = /*has_file_path*/ ctx[10] && create_if_block_3$2();
	let each_value = ensure_array_like$2(/*endpoint_parameters*/ ctx[4]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$2(get_each_context$2(ctx, each_value, i));
	}

	return {
		c() {
			div0 = element$2("div");
			create_component$5(copybutton.$$.fragment);
			t0 = space$2();
			div1 = element$2("div");
			pre = element$2("pre");
			t1 = text$2("from gradio_client import Client");
			if (if_block) if_block.c();
			t2 = text$2("\n\nclient = Client(");
			span = element$2("span");
			t3 = text$2("\"");
			t4 = text$2(/*root*/ ctx[2]);
			t5 = text$2("\"");
			t6 = text$2(")\nresult = client.predict(");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t7 = text$2("\n\t\tapi_name=\"/");
			t8 = text$2(t8_value);
			t9 = text$2("\"\n)\nprint(result)");
			attr$2(div0, "class", "copy svelte-1d98qmk");
			attr$2(span, "class", "token string svelte-1d98qmk");
			attr$2(pre, "class", "svelte-1d98qmk");
		},
		m(target, anchor) {
			insert$4(target, div0, anchor);
			mount_component$5(copybutton, div0, null);
			insert$4(target, t0, anchor);
			insert$4(target, div1, anchor);
			append$2(div1, pre);
			append$2(pre, t1);
			if (if_block) if_block.m(pre, null);
			append$2(pre, t2);
			append$2(pre, span);
			append$2(span, t3);
			append$2(span, t4);
			append$2(span, t5);
			append$2(pre, t6);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(pre, null);
				}
			}

			append$2(pre, t7);
			append$2(pre, t8);
			append$2(pre, t9);
			/*div1_binding*/ ctx[13](div1);
			current = true;
		},
		p(ctx, dirty) {
			const copybutton_changes = {};
			if (dirty & /*python_code*/ 256) copybutton_changes.code = /*python_code*/ ctx[8]?.innerText;
			copybutton.$set(copybutton_changes);
			if (!current || dirty & /*root*/ 4) set_data$1(t4, /*root*/ ctx[2]);

			if (dirty & /*endpoint_parameters, dependency_failures, dependency_index*/ 26) {
				each_value = ensure_array_like$2(/*endpoint_parameters*/ ctx[4]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$2(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$2(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(pre, t7);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if ((!current || dirty & /*dependency*/ 1) && t8_value !== (t8_value = /*dependency*/ ctx[0].api_name + "")) set_data$1(t8, t8_value);
		},
		i(local) {
			if (current) return;
			transition_in$5(copybutton.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$5(copybutton.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$4(div0);
				detach$4(t0);
				detach$4(div1);
			}

			destroy_component$5(copybutton);
			if (if_block) if_block.d();
			destroy_each$1(each_blocks, detaching);
			/*div1_binding*/ ctx[13](null);
		}
	};
}

// (69:0) {#each blob_examples as { label, type, python_type, component, example_input, serializer }
function create_each_block_2(ctx) {
	let t0;
	let t1;
	let t2;
	let t3_value = /*example_input*/ ctx[19].url + "";
	let t3;
	let t4;
	let t5_value = /*component*/ ctx[18] + "";
	let t5;
	let t6;
	let t7;
	let t8;

	return {
		c() {
			t0 = text$2("\nconst response_");
			t1 = text$2(/*i*/ ctx[22]);
			t2 = text$2(" = await fetch(\"");
			t3 = text$2(t3_value);
			t4 = text$2("\");\nconst example");
			t5 = text$2(t5_value);
			t6 = text$2(" = await response_");
			t7 = text$2(/*i*/ ctx[22]);
			t8 = text$2(".blob();\n\t\t\t\t\t\t");
		},
		m(target, anchor) {
			insert$4(target, t0, anchor);
			insert$4(target, t1, anchor);
			insert$4(target, t2, anchor);
			insert$4(target, t3, anchor);
			insert$4(target, t4, anchor);
			insert$4(target, t5, anchor);
			insert$4(target, t6, anchor);
			insert$4(target, t7, anchor);
			insert$4(target, t8, anchor);
		},
		p: noop$1,
		d(detaching) {
			if (detaching) {
				detach$4(t0);
				detach$4(t1);
				detach$4(t2);
				detach$4(t3);
				detach$4(t4);
				detach$4(t5);
				detach$4(t6);
				detach$4(t7);
				detach$4(t8);
			}
		}
	};
}

// (76:68) {:else}
function create_else_block_1(ctx) {
	let t;

	return {
		c() {
			t = text$2(/*dependency_index*/ ctx[1]);
		},
		m(target, anchor) {
			insert$4(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*dependency_index*/ 2) set_data$1(t, /*dependency_index*/ ctx[1]);
		},
		d(detaching) {
			if (detaching) {
				detach$4(t);
			}
		}
	};
}

// (76:33) {#if named}
function create_if_block_7(ctx) {
	let t0;
	let t1_value = /*dependency*/ ctx[0].api_name + "";
	let t1;
	let t2;

	return {
		c() {
			t0 = text$2("\"/");
			t1 = text$2(t1_value);
			t2 = text$2("\"");
		},
		m(target, anchor) {
			insert$4(target, t0, anchor);
			insert$4(target, t1, anchor);
			insert$4(target, t2, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*dependency*/ 1 && t1_value !== (t1_value = /*dependency*/ ctx[0].api_name + "")) set_data$1(t1, t1_value);
		},
		d(detaching) {
			if (detaching) {
				detach$4(t0);
				detach$4(t1);
				detach$4(t2);
			}
		}
	};
}

// (90:5) {:else}
function create_else_block$1(ctx) {
	let t0;
	let span0;
	let t1_value = represent_value(/*example_input*/ ctx[19], /*python_type*/ ctx[17].type, "js") + "";
	let t1;
	let t2;
	let span1;
	let t3;
	let t4_value = /*js_parameters*/ ctx[5][/*i*/ ctx[22]].type + "";
	let t4;
	let t5;
	let t6;
	let t7_value = /*label*/ ctx[15] + "";
	let t7;
	let t8;
	let t9_value = /*component*/ ctx[18] + "";
	let t9;
	let t10;
	let if_block = /*js_parameters*/ ctx[5][/*i*/ ctx[22]].description && create_if_block_6$1(ctx);

	return {
		c() {
			t0 = text$2("\t\t\n\t\t\t\t");
			span0 = element$2("span");
			t1 = text$2(t1_value);
			t2 = text$2(", ");
			span1 = element$2("span");
			t3 = text$2("// ");
			t4 = text$2(t4_value);
			t5 = text$2(" ");
			if (if_block) if_block.c();
			t6 = text$2(" in '");
			t7 = text$2(t7_value);
			t8 = text$2("' ");
			t9 = text$2(t9_value);
			t10 = text$2(" component");
			attr$2(span0, "class", "example-inputs svelte-1d98qmk");
			attr$2(span1, "class", "desc svelte-1d98qmk");
		},
		m(target, anchor) {
			insert$4(target, t0, anchor);
			insert$4(target, span0, anchor);
			append$2(span0, t1);
			insert$4(target, t2, anchor);
			insert$4(target, span1, anchor);
			append$2(span1, t3);
			append$2(span1, t4);
			append$2(span1, t5);
			if (if_block) if_block.m(span1, null);
			append$2(span1, t6);
			append$2(span1, t7);
			append$2(span1, t8);
			append$2(span1, t9);
			append$2(span1, t10);
		},
		p(ctx, dirty) {
			if (dirty & /*endpoint_parameters*/ 16 && t1_value !== (t1_value = represent_value(/*example_input*/ ctx[19], /*python_type*/ ctx[17].type, "js") + "")) set_data$1(t1, t1_value);
			if (dirty & /*js_parameters*/ 32 && t4_value !== (t4_value = /*js_parameters*/ ctx[5][/*i*/ ctx[22]].type + "")) set_data$1(t4, t4_value);

			if (/*js_parameters*/ ctx[5][/*i*/ ctx[22]].description) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block_6$1(ctx);
					if_block.c();
					if_block.m(span1, t6);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}

			if (dirty & /*endpoint_parameters*/ 16 && t7_value !== (t7_value = /*label*/ ctx[15] + "")) set_data$1(t7, t7_value);
			if (dirty & /*endpoint_parameters*/ 16 && t9_value !== (t9_value = /*component*/ ctx[18] + "")) set_data$1(t9, t9_value);
		},
		d(detaching) {
			if (detaching) {
				detach$4(t0);
				detach$4(span0);
				detach$4(t2);
				detach$4(span1);
			}

			if (if_block) if_block.d();
		}
	};
}

// (78:5) {#if blob_components.includes(component)}
function create_if_block_5$1(ctx) {
	let t0;
	let span0;
	let t1;
	let t2_value = /*component*/ ctx[18] + "";
	let t2;
	let t3;
	let span1;
	let t4;
	let t5_value = /*label*/ ctx[15] + "";
	let t5;
	let t6;
	let t7_value = /*component*/ ctx[18] + "";
	let t7;
	let t8;

	return {
		c() {
			t0 = text$2("\n\t\t\t\t");
			span0 = element$2("span");
			t1 = text$2("example");
			t2 = text$2(t2_value);
			t3 = text$2(", ");
			span1 = element$2("span");
			t4 = text$2("\t// blob in '");
			t5 = text$2(t5_value);
			t6 = text$2("' ");
			t7 = text$2(t7_value);
			t8 = text$2(" component");
			attr$2(span0, "class", "example-inputs svelte-1d98qmk");
			attr$2(span1, "class", "desc svelte-1d98qmk");
		},
		m(target, anchor) {
			insert$4(target, t0, anchor);
			insert$4(target, span0, anchor);
			append$2(span0, t1);
			append$2(span0, t2);
			insert$4(target, t3, anchor);
			insert$4(target, span1, anchor);
			append$2(span1, t4);
			append$2(span1, t5);
			append$2(span1, t6);
			append$2(span1, t7);
			append$2(span1, t8);
		},
		p(ctx, dirty) {
			if (dirty & /*endpoint_parameters*/ 16 && t2_value !== (t2_value = /*component*/ ctx[18] + "")) set_data$1(t2, t2_value);
			if (dirty & /*endpoint_parameters*/ 16 && t5_value !== (t5_value = /*label*/ ctx[15] + "")) set_data$1(t5, t5_value);
			if (dirty & /*endpoint_parameters*/ 16 && t7_value !== (t7_value = /*component*/ ctx[18] + "")) set_data$1(t7, t7_value);
		},
		d(detaching) {
			if (detaching) {
				detach$4(t0);
				detach$4(span0);
				detach$4(t3);
				detach$4(span1);
			}
		}
	};
}

// (102:17) {#if js_parameters[i].description}
function create_if_block_6$1(ctx) {
	let t0;
	let t1_value = /*js_parameters*/ ctx[5][/*i*/ ctx[22]].description + "";
	let t1;
	let t2;

	return {
		c() {
			t0 = text$2("(");
			t1 = text$2(t1_value);
			t2 = text$2(")");
		},
		m(target, anchor) {
			insert$4(target, t0, anchor);
			insert$4(target, t1, anchor);
			insert$4(target, t2, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*js_parameters*/ 32 && t1_value !== (t1_value = /*js_parameters*/ ctx[5][/*i*/ ctx[22]].description + "")) set_data$1(t1, t1_value);
		},
		d(detaching) {
			if (detaching) {
				detach$4(t0);
				detach$4(t1);
				detach$4(t2);
			}
		}
	};
}

// (77:3) {#each endpoint_parameters as { label, type, python_type, component, example_input, serializer }
function create_each_block_1$1(ctx) {
	let show_if;
	let if_block_anchor;

	function select_block_type_3(ctx, dirty) {
		if (dirty & /*endpoint_parameters*/ 16) show_if = null;
		if (show_if == null) show_if = !!/*blob_components*/ ctx[11].includes(/*component*/ ctx[18]);
		if (show_if) return create_if_block_5$1;
		return create_else_block$1;
	}

	let current_block_type = select_block_type_3(ctx, -1);
	let if_block = current_block_type(ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty$4();
		},
		m(target, anchor) {
			if_block.m(target, anchor);
			insert$4(target, if_block_anchor, anchor);
		},
		p(ctx, dirty) {
			if (current_block_type === (current_block_type = select_block_type_3(ctx, dirty)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			}
		},
		d(detaching) {
			if (detaching) {
				detach$4(if_block_anchor);
			}

			if_block.d(detaching);
		}
	};
}

// (33:42) {#if has_file_path}
function create_if_block_3$2(ctx) {
	let t;

	return {
		c() {
			t = text$2(", file");
		},
		m(target, anchor) {
			insert$4(target, t, anchor);
		},
		d(detaching) {
			if (detaching) {
				detach$4(t);
			}
		}
	};
}

// (43:6) {#if dependency_failures[dependency_index][i]}
function create_if_block_2$2(ctx) {
	let span;

	return {
		c() {
			span = element$2("span");
			span.textContent = "ERROR";
			attr$2(span, "class", "error svelte-1d98qmk");
		},
		m(target, anchor) {
			insert$4(target, span, anchor);
		},
		d(detaching) {
			if (detaching) {
				detach$4(span);
			}
		}
	};
}

// (50:28) {#if python_type.description}
function create_if_block_1$2(ctx) {
	let t0;
	let t1_value = /*python_type*/ ctx[17].description + "";
	let t1;
	let t2;

	return {
		c() {
			t0 = text$2("(");
			t1 = text$2(t1_value);
			t2 = text$2(")\n\t\t\t\t\t\t\t\t");
		},
		m(target, anchor) {
			insert$4(target, t0, anchor);
			insert$4(target, t1, anchor);
			insert$4(target, t2, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*endpoint_parameters*/ 16 && t1_value !== (t1_value = /*python_type*/ ctx[17].description + "")) set_data$1(t1, t1_value);
		},
		d(detaching) {
			if (detaching) {
				detach$4(t0);
				detach$4(t1);
				detach$4(t2);
			}
		}
	};
}

// (37:3) {#each endpoint_parameters as { label, type, python_type, component, example_input, serializer }
function create_each_block$2(ctx) {
	let t0;
	let span0;
	let t1_value = represent_value(/*example_input*/ ctx[19], /*python_type*/ ctx[17].type, "py") + "";
	let t1;
	let t2;
	let span1;
	let t3;
	let t4_value = /*python_type*/ ctx[17].type + "";
	let t4;
	let t5;
	let t6;
	let t7_value = /*label*/ ctx[15] + "";
	let t7;
	let t8;
	let t9_value = /*component*/ ctx[18] + "";
	let t9;
	let t10;
	let if_block0 = /*dependency_failures*/ ctx[3][/*dependency_index*/ ctx[1]][/*i*/ ctx[22]] && create_if_block_2$2();
	let if_block1 = /*python_type*/ ctx[17].description && create_if_block_1$2(ctx);

	return {
		c() {
			t0 = text$2("\n\t\t");
			span0 = element$2("span");
			t1 = text$2(t1_value);
			t2 = text$2(",");
			if (if_block0) if_block0.c();
			span1 = element$2("span");
			t3 = text$2("\t# ");
			t4 = text$2(t4_value);
			t5 = text$2(" ");
			if (if_block1) if_block1.c();
			t6 = text$2("in '");
			t7 = text$2(t7_value);
			t8 = text$2("' ");
			t9 = text$2(t9_value);
			t10 = text$2(" component");
			attr$2(span0, "class", "example-inputs svelte-1d98qmk");
			attr$2(span1, "class", "desc svelte-1d98qmk");
		},
		m(target, anchor) {
			insert$4(target, t0, anchor);
			insert$4(target, span0, anchor);
			append$2(span0, t1);
			insert$4(target, t2, anchor);
			if (if_block0) if_block0.m(target, anchor);
			insert$4(target, span1, anchor);
			append$2(span1, t3);
			append$2(span1, t4);
			append$2(span1, t5);
			if (if_block1) if_block1.m(span1, null);
			append$2(span1, t6);
			append$2(span1, t7);
			append$2(span1, t8);
			append$2(span1, t9);
			append$2(span1, t10);
		},
		p(ctx, dirty) {
			if (dirty & /*endpoint_parameters*/ 16 && t1_value !== (t1_value = represent_value(/*example_input*/ ctx[19], /*python_type*/ ctx[17].type, "py") + "")) set_data$1(t1, t1_value);

			if (/*dependency_failures*/ ctx[3][/*dependency_index*/ ctx[1]][/*i*/ ctx[22]]) {
				if (if_block0) ; else {
					if_block0 = create_if_block_2$2();
					if_block0.c();
					if_block0.m(span1.parentNode, span1);
				}
			} else if (if_block0) {
				if_block0.d(1);
				if_block0 = null;
			}

			if (dirty & /*endpoint_parameters*/ 16 && t4_value !== (t4_value = /*python_type*/ ctx[17].type + "")) set_data$1(t4, t4_value);

			if (/*python_type*/ ctx[17].description) {
				if (if_block1) {
					if_block1.p(ctx, dirty);
				} else {
					if_block1 = create_if_block_1$2(ctx);
					if_block1.c();
					if_block1.m(span1, t6);
				}
			} else if (if_block1) {
				if_block1.d(1);
				if_block1 = null;
			}

			if (dirty & /*endpoint_parameters*/ 16 && t7_value !== (t7_value = /*label*/ ctx[15] + "")) set_data$1(t7, t7_value);
			if (dirty & /*endpoint_parameters*/ 16 && t9_value !== (t9_value = /*component*/ ctx[18] + "")) set_data$1(t9, t9_value);
		},
		d(detaching) {
			if (detaching) {
				detach$4(t0);
				detach$4(span0);
				detach$4(t2);
				detach$4(span1);
			}

			if (if_block0) if_block0.d(detaching);
			if (if_block1) if_block1.d();
		}
	};
}

// (26:1) <Block>
function create_default_slot$2(ctx) {
	let code;
	let current_block_type_index;
	let if_block;
	let current;
	const if_block_creators = [create_if_block$3, create_if_block_4$1];
	const if_blocks = [];

	function select_block_type_1(ctx, dirty) {
		if (/*current_language*/ ctx[7] === "python") return 0;
		if (/*current_language*/ ctx[7] === "javascript") return 1;
		return -1;
	}

	if (~(current_block_type_index = select_block_type_1(ctx))) {
		if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	}

	return {
		c() {
			code = element$2("code");
			if (if_block) if_block.c();
			attr$2(code, "class", "svelte-1d98qmk");
		},
		m(target, anchor) {
			insert$4(target, code, anchor);

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].m(code, null);
			}

			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_1(ctx);

			if (current_block_type_index === previous_block_index) {
				if (~current_block_type_index) {
					if_blocks[current_block_type_index].p(ctx, dirty);
				}
			} else {
				if (if_block) {
					group_outros$4();

					transition_out$5(if_blocks[previous_block_index], 1, 1, () => {
						if_blocks[previous_block_index] = null;
					});

					check_outros$4();
				}

				if (~current_block_type_index) {
					if_block = if_blocks[current_block_type_index];

					if (!if_block) {
						if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
						if_block.c();
					} else {
						if_block.p(ctx, dirty);
					}

					transition_in$5(if_block, 1);
					if_block.m(code, null);
				} else {
					if_block = null;
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in$5(if_block);
			current = true;
		},
		o(local) {
			transition_out$5(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$4(code);
			}

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].d();
			}
		}
	};
}

function create_fragment$5(ctx) {
	let div;
	let current_block_type_index;
	let if_block;
	let t;
	let block;
	let current;
	const if_block_creators = [create_if_block_8, create_else_block_2];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*named*/ ctx[6]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	block = new Block({
			props: {
				$$slots: { default: [create_default_slot$2] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			div = element$2("div");
			if_block.c();
			t = space$2();
			create_component$5(block.$$.fragment);
			attr$2(div, "class", "container svelte-1d98qmk");
		},
		m(target, anchor) {
			insert$4(target, div, anchor);
			if_blocks[current_block_type_index].m(div, null);
			append$2(div, t);
			mount_component$5(block, div, null);
			current = true;
		},
		p(ctx, [dirty]) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros$4();

				transition_out$5(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros$4();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in$5(if_block, 1);
				if_block.m(div, t);
			}

			const block_changes = {};

			if (dirty & /*$$scope, python_code, dependency, endpoint_parameters, dependency_failures, dependency_index, root, current_language, js_code, js_parameters, named*/ 33555455) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in$5(if_block);
			transition_in$5(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$5(if_block);
			transition_out$5(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$4(div);
			}

			if_blocks[current_block_type_index].d();
			destroy_component$5(block);
		}
	};
}

function instance$4($$self, $$props, $$invalidate) {
	let { dependency } = $$props;
	let { dependency_index } = $$props;
	let { root } = $$props;
	let { dependency_failures } = $$props;
	let { endpoint_parameters } = $$props;
	let { js_parameters } = $$props;
	let { named } = $$props;
	let { current_language } = $$props;
	let python_code;
	let js_code;
	let has_file_path = endpoint_parameters.some(param => is_potentially_nested_file_data(param.example_input));
	let blob_components = ["Audio", "File", "Image", "Video"];
	let blob_examples = endpoint_parameters.filter(param => blob_components.includes(param.component));

	function div1_binding($$value) {
		binding_callbacks$2[$$value ? 'unshift' : 'push'](() => {
			python_code = $$value;
			$$invalidate(8, python_code);
		});
	}

	function div1_binding_1($$value) {
		binding_callbacks$2[$$value ? 'unshift' : 'push'](() => {
			js_code = $$value;
			$$invalidate(9, js_code);
		});
	}

	$$self.$$set = $$props => {
		if ('dependency' in $$props) $$invalidate(0, dependency = $$props.dependency);
		if ('dependency_index' in $$props) $$invalidate(1, dependency_index = $$props.dependency_index);
		if ('root' in $$props) $$invalidate(2, root = $$props.root);
		if ('dependency_failures' in $$props) $$invalidate(3, dependency_failures = $$props.dependency_failures);
		if ('endpoint_parameters' in $$props) $$invalidate(4, endpoint_parameters = $$props.endpoint_parameters);
		if ('js_parameters' in $$props) $$invalidate(5, js_parameters = $$props.js_parameters);
		if ('named' in $$props) $$invalidate(6, named = $$props.named);
		if ('current_language' in $$props) $$invalidate(7, current_language = $$props.current_language);
	};

	return [
		dependency,
		dependency_index,
		root,
		dependency_failures,
		endpoint_parameters,
		js_parameters,
		named,
		current_language,
		python_code,
		js_code,
		has_file_path,
		blob_components,
		blob_examples,
		div1_binding,
		div1_binding_1
	];
}

class CodeSnippets extends SvelteComponent$5 {
	constructor(options) {
		super();

		init$5(this, options, instance$4, create_fragment$5, safe_not_equal$4, {
			dependency: 0,
			dependency_index: 1,
			root: 2,
			dependency_failures: 3,
			endpoint_parameters: 4,
			js_parameters: 5,
			named: 6,
			current_language: 7
		});
	}
}

const python = ""+new URL('python-20e39c92.svg', import.meta.url).href+"";

const javascript = ""+new URL('javascript-850cf94b.svg', import.meta.url).href+"";

const ApiDocs_svelte_svelte_type_style_lang = '';

/* src/api_docs/ApiDocs.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$4,
	append: append$1,
	attr: attr$1,
	bubble: bubble$2,
	check_outros: check_outros$3,
	create_component: create_component$4,
	destroy_component: destroy_component$4,
	destroy_each,
	detach: detach$3,
	element: element$1,
	empty: empty$3,
	ensure_array_like: ensure_array_like$1,
	group_outros: group_outros$3,
	init: init$4,
	insert: insert$3,
	listen: listen$1,
	mount_component: mount_component$4,
	safe_not_equal: safe_not_equal$3,
	space: space$1,
	src_url_equal: src_url_equal$1,
	text: text$1,
	transition_in: transition_in$4,
	transition_out: transition_out$4
} = window.__gradio__svelte__internal;
const { onMount: onMount$2, createEventDispatcher: createEventDispatcher$2 } = window.__gradio__svelte__internal;
function get_each_context$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[20] = list[i];
	child_ctx[22] = i;
	return child_ctx;
}

function get_each_context_1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[23] = list[i][0];
	child_ctx[24] = list[i][1];
	return child_ctx;
}

// (121:0) {#if info}
function create_if_block$2(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block_1$1, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*api_count*/ ctx[8]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty$3();
		},
		m(target, anchor) {
			if_blocks[current_block_type_index].m(target, anchor);
			insert$3(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if_block.p(ctx, dirty);
		},
		i(local) {
			if (current) return;
			transition_in$4(if_block);
			current = true;
		},
		o(local) {
			transition_out$4(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$3(if_block_anchor);
			}

			if_blocks[current_block_type_index].d(detaching);
		}
	};
}

// (207:1) {:else}
function create_else_block(ctx) {
	let noapi;
	let current;
	noapi = new NoApi({ props: { root: /*root*/ ctx[0] } });
	noapi.$on("close", /*close_handler_1*/ ctx[14]);

	return {
		c() {
			create_component$4(noapi.$$.fragment);
		},
		m(target, anchor) {
			mount_component$4(noapi, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const noapi_changes = {};
			if (dirty & /*root*/ 1) noapi_changes.root = /*root*/ ctx[0];
			noapi.$set(noapi_changes);
		},
		i(local) {
			if (current) return;
			transition_in$4(noapi.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$4(noapi.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$4(noapi, detaching);
		}
	};
}

// (122:1) {#if api_count}
function create_if_block_1$1(ctx) {
	let div0;
	let apibanner;
	let t0;
	let div4;
	let div1;
	let p0;
	let t1;
	let code0;
	let t3;
	let a0;
	let t4;
	let t5;
	let code1;
	let t7;
	let a1;
	let t8;
	let t9;
	let t10;
	let div3;
	let div2;
	let t11;
	let p1;
	let t13;
	let installsnippet;
	let t14;
	let p2;
	let t15;
	let t16;
	let t17;
	let current;

	apibanner = new ApiBanner({
			props: {
				root: /*space_id*/ ctx[2] || /*root*/ ctx[0],
				api_count: /*api_count*/ ctx[8]
			}
		});

	apibanner.$on("close", /*close_handler*/ ctx[12]);
	let each_value_1 = ensure_array_like$1(/*langs*/ ctx[9]);
	let each_blocks_1 = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks_1[i] = create_each_block_1(get_each_context_1(ctx, each_value_1, i));
	}

	installsnippet = new InstallSnippet({
			props: {
				current_language: /*current_language*/ ctx[3]
			}
		});

	let if_block = /*space_id*/ ctx[2] && create_if_block_3$1(ctx);
	let each_value = ensure_array_like$1(/*dependencies*/ ctx[1]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$1(get_each_context$1(ctx, each_value, i));
	}

	const out = i => transition_out$4(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			div0 = element$1("div");
			create_component$4(apibanner.$$.fragment);
			t0 = space$1();
			div4 = element$1("div");
			div1 = element$1("div");
			p0 = element$1("p");
			t1 = text$1("Use the ");
			code0 = element$1("code");
			code0.textContent = "gradio_client";
			t3 = text$1("\n\t\t\t\t\tPython library (");
			a0 = element$1("a");
			t4 = text$1("docs");
			t5 = text$1(") or the\n\t\t\t\t\t");
			code1 = element$1("code");
			code1.textContent = "@gradio/client";
			t7 = text$1("\n\t\t\t\t\tJavascript package (");
			a1 = element$1("a");
			t8 = text$1("docs");
			t9 = text$1(") to\n\t\t\t\t\tquery the app via API.");
			t10 = space$1();
			div3 = element$1("div");
			div2 = element$1("div");

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].c();
			}

			t11 = space$1();
			p1 = element$1("p");
			p1.textContent = "1. Install the client if you don't already have it installed.";
			t13 = space$1();
			create_component$4(installsnippet.$$.fragment);
			t14 = space$1();
			p2 = element$1("p");
			t15 = text$1("2. Find the API endpoint below corresponding to your desired function\n\t\t\t\t\tin the app. Copy the code snippet, replacing the placeholder values\n\t\t\t\t\twith your own input data.\n\t\t\t\t\t");
			if (if_block) if_block.c();
			t16 = text$1(" Run the code, that's it!");
			t17 = space$1();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr$1(div0, "class", "banner-wrap svelte-19gb6z1");
			attr$1(code0, "class", "library svelte-19gb6z1");
			attr$1(a0, "href", py_docs);
			attr$1(a0, "target", "_blank");
			attr$1(a0, "class", "svelte-19gb6z1");
			attr$1(code1, "class", "library svelte-19gb6z1");
			attr$1(a1, "href", js_docs);
			attr$1(a1, "target", "_blank");
			attr$1(a1, "class", "svelte-19gb6z1");
			attr$1(div1, "class", "client-doc svelte-19gb6z1");
			attr$1(div2, "class", "snippets svelte-19gb6z1");
			attr$1(p1, "class", "padded svelte-19gb6z1");
			attr$1(p2, "class", "padded svelte-19gb6z1");
			attr$1(div3, "class", "endpoint svelte-19gb6z1");
			attr$1(div4, "class", "docs-wrap svelte-19gb6z1");
		},
		m(target, anchor) {
			insert$3(target, div0, anchor);
			mount_component$4(apibanner, div0, null);
			insert$3(target, t0, anchor);
			insert$3(target, div4, anchor);
			append$1(div4, div1);
			append$1(div1, p0);
			append$1(p0, t1);
			append$1(p0, code0);
			append$1(p0, t3);
			append$1(p0, a0);
			append$1(a0, t4);
			append$1(p0, t5);
			append$1(p0, code1);
			append$1(p0, t7);
			append$1(p0, a1);
			append$1(a1, t8);
			append$1(p0, t9);
			append$1(div4, t10);
			append$1(div4, div3);
			append$1(div3, div2);

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				if (each_blocks_1[i]) {
					each_blocks_1[i].m(div2, null);
				}
			}

			append$1(div3, t11);
			append$1(div3, p1);
			append$1(div3, t13);
			mount_component$4(installsnippet, div3, null);
			append$1(div3, t14);
			append$1(div3, p2);
			append$1(p2, t15);
			if (if_block) if_block.m(p2, null);
			append$1(p2, t16);
			append$1(div3, t17);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(div3, null);
				}
			}

			current = true;
		},
		p(ctx, dirty) {
			const apibanner_changes = {};
			if (dirty & /*space_id, root*/ 5) apibanner_changes.root = /*space_id*/ ctx[2] || /*root*/ ctx[0];
			apibanner.$set(apibanner_changes);

			if (dirty & /*current_language, langs*/ 520) {
				each_value_1 = ensure_array_like$1(/*langs*/ ctx[9]);
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1(ctx, each_value_1, i);

					if (each_blocks_1[i]) {
						each_blocks_1[i].p(child_ctx, dirty);
					} else {
						each_blocks_1[i] = create_each_block_1(child_ctx);
						each_blocks_1[i].c();
						each_blocks_1[i].m(div2, null);
					}
				}

				for (; i < each_blocks_1.length; i += 1) {
					each_blocks_1[i].d(1);
				}

				each_blocks_1.length = each_value_1.length;
			}

			const installsnippet_changes = {};
			if (dirty & /*current_language*/ 8) installsnippet_changes.current_language = /*current_language*/ ctx[3];
			installsnippet.$set(installsnippet_changes);

			if (/*space_id*/ ctx[2]) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block_3$1(ctx);
					if_block.c();
					if_block.m(p2, t16);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}

			if (dirty & /*info, dependencies, js_info, is_running, current_language, space_id, root, dependency_failures*/ 255) {
				each_value = ensure_array_like$1(/*dependencies*/ ctx[1]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$1(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in$4(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block$1(child_ctx);
						each_blocks[i].c();
						transition_in$4(each_blocks[i], 1);
						each_blocks[i].m(div3, null);
					}
				}

				group_outros$3();

				for (i = each_value.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros$3();
			}
		},
		i(local) {
			if (current) return;
			transition_in$4(apibanner.$$.fragment, local);
			transition_in$4(installsnippet.$$.fragment, local);

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in$4(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			transition_out$4(apibanner.$$.fragment, local);
			transition_out$4(installsnippet.$$.fragment, local);
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out$4(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$3(div0);
				detach$3(t0);
				detach$3(div4);
			}

			destroy_component$4(apibanner);
			destroy_each(each_blocks_1, detaching);
			destroy_component$4(installsnippet);
			if (if_block) if_block.d();
			destroy_each(each_blocks, detaching);
		}
	};
}

// (138:5) {#each langs as [language, img]}
function create_each_block_1(ctx) {
	let li;
	let img_1;
	let img_1_src_value;
	let t0;
	let t1_value = /*language*/ ctx[23] + "";
	let t1;
	let t2;
	let li_class_value;
	let mounted;
	let dispose;

	function click_handler() {
		return /*click_handler*/ ctx[13](/*language*/ ctx[23]);
	}

	return {
		c() {
			li = element$1("li");
			img_1 = element$1("img");
			t0 = space$1();
			t1 = text$1(t1_value);
			t2 = space$1();
			if (!src_url_equal$1(img_1.src, img_1_src_value = /*img*/ ctx[24])) attr$1(img_1, "src", img_1_src_value);
			attr$1(img_1, "alt", "");
			attr$1(img_1, "class", "svelte-19gb6z1");

			attr$1(li, "class", li_class_value = "snippet " + (/*current_language*/ ctx[3] === /*language*/ ctx[23]
			? 'current-lang'
			: 'inactive-lang') + " svelte-19gb6z1");
		},
		m(target, anchor) {
			insert$3(target, li, anchor);
			append$1(li, img_1);
			append$1(li, t0);
			append$1(li, t1);
			append$1(li, t2);

			if (!mounted) {
				dispose = listen$1(li, "click", click_handler);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty & /*current_language*/ 8 && li_class_value !== (li_class_value = "snippet " + (/*current_language*/ ctx[3] === /*language*/ ctx[23]
			? 'current-lang'
			: 'inactive-lang') + " svelte-19gb6z1")) {
				attr$1(li, "class", li_class_value);
			}
		},
		d(detaching) {
			if (detaching) {
				detach$3(li);
			}

			mounted = false;
			dispose();
		}
	};
}

// (160:5) {#if space_id}
function create_if_block_3$1(ctx) {
	let t0;
	let a;
	let t1;
	let a_href_value;
	let t2;

	return {
		c() {
			t0 = text$1("If this is a private Space, you may need to pass your\n\t\t\t\t\t\tHugging Face token as well (");
			a = element$1("a");
			t1 = text$1("read more");
			t2 = text$1(").");

			attr$1(a, "href", a_href_value = (/*current_language*/ ctx[3] == "python"
			? py_docs
			: js_docs) + spaces_docs_suffix);

			attr$1(a, "class", "underline svelte-19gb6z1");
			attr$1(a, "target", "_blank");
		},
		m(target, anchor) {
			insert$3(target, t0, anchor);
			insert$3(target, a, anchor);
			append$1(a, t1);
			insert$3(target, t2, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*current_language*/ 8 && a_href_value !== (a_href_value = (/*current_language*/ ctx[3] == "python"
			? py_docs
			: js_docs) + spaces_docs_suffix)) {
				attr$1(a, "href", a_href_value);
			}
		},
		d(detaching) {
			if (detaching) {
				detach$3(t0);
				detach$3(a);
				detach$3(t2);
			}
		}
	};
}

// (170:5) {#if dependency.show_api}
function create_if_block_2$1(ctx) {
	let div;
	let codesnippets;
	let t0;
	let responseobject;
	let t1;
	let current;

	codesnippets = new CodeSnippets({
			props: {
				named: true,
				endpoint_parameters: /*info*/ ctx[6].named_endpoints["/" + /*dependency*/ ctx[20].api_name].parameters,
				js_parameters: /*js_info*/ ctx[7].named_endpoints["/" + /*dependency*/ ctx[20].api_name].parameters,
				dependency: /*dependency*/ ctx[20],
				dependency_index: /*dependency_index*/ ctx[22],
				current_language: /*current_language*/ ctx[3],
				root: /*space_id*/ ctx[2] || /*root*/ ctx[0],
				dependency_failures: /*dependency_failures*/ ctx[5]
			}
		});

	responseobject = new ResponseObject({
			props: {
				endpoint_returns: /*info*/ ctx[6].named_endpoints["/" + /*dependency*/ ctx[20].api_name].returns,
				js_returns: /*js_info*/ ctx[7].named_endpoints["/" + /*dependency*/ ctx[20].api_name].returns,
				is_running: /*is_running*/ ctx[4],
				current_language: /*current_language*/ ctx[3]
			}
		});

	return {
		c() {
			div = element$1("div");
			create_component$4(codesnippets.$$.fragment);
			t0 = space$1();
			create_component$4(responseobject.$$.fragment);
			t1 = space$1();
			attr$1(div, "class", "endpoint-container svelte-19gb6z1");
		},
		m(target, anchor) {
			insert$3(target, div, anchor);
			mount_component$4(codesnippets, div, null);
			append$1(div, t0);
			mount_component$4(responseobject, div, null);
			append$1(div, t1);
			current = true;
		},
		p(ctx, dirty) {
			const codesnippets_changes = {};
			if (dirty & /*info, dependencies*/ 66) codesnippets_changes.endpoint_parameters = /*info*/ ctx[6].named_endpoints["/" + /*dependency*/ ctx[20].api_name].parameters;
			if (dirty & /*js_info, dependencies*/ 130) codesnippets_changes.js_parameters = /*js_info*/ ctx[7].named_endpoints["/" + /*dependency*/ ctx[20].api_name].parameters;
			if (dirty & /*dependencies*/ 2) codesnippets_changes.dependency = /*dependency*/ ctx[20];
			if (dirty & /*current_language*/ 8) codesnippets_changes.current_language = /*current_language*/ ctx[3];
			if (dirty & /*space_id, root*/ 5) codesnippets_changes.root = /*space_id*/ ctx[2] || /*root*/ ctx[0];
			if (dirty & /*dependency_failures*/ 32) codesnippets_changes.dependency_failures = /*dependency_failures*/ ctx[5];
			codesnippets.$set(codesnippets_changes);
			const responseobject_changes = {};
			if (dirty & /*info, dependencies*/ 66) responseobject_changes.endpoint_returns = /*info*/ ctx[6].named_endpoints["/" + /*dependency*/ ctx[20].api_name].returns;
			if (dirty & /*js_info, dependencies*/ 130) responseobject_changes.js_returns = /*js_info*/ ctx[7].named_endpoints["/" + /*dependency*/ ctx[20].api_name].returns;
			if (dirty & /*is_running*/ 16) responseobject_changes.is_running = /*is_running*/ ctx[4];
			if (dirty & /*current_language*/ 8) responseobject_changes.current_language = /*current_language*/ ctx[3];
			responseobject.$set(responseobject_changes);
		},
		i(local) {
			if (current) return;
			transition_in$4(codesnippets.$$.fragment, local);
			transition_in$4(responseobject.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$4(codesnippets.$$.fragment, local);
			transition_out$4(responseobject.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$3(div);
			}

			destroy_component$4(codesnippets);
			destroy_component$4(responseobject);
		}
	};
}

// (169:4) {#each dependencies as dependency, dependency_index}
function create_each_block$1(ctx) {
	let if_block_anchor;
	let current;
	let if_block = /*dependency*/ ctx[20].show_api && create_if_block_2$1(ctx);

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = empty$3();
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert$3(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (/*dependency*/ ctx[20].show_api) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*dependencies*/ 2) {
						transition_in$4(if_block, 1);
					}
				} else {
					if_block = create_if_block_2$1(ctx);
					if_block.c();
					transition_in$4(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				group_outros$3();

				transition_out$4(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros$3();
			}
		},
		i(local) {
			if (current) return;
			transition_in$4(if_block);
			current = true;
		},
		o(local) {
			transition_out$4(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$3(if_block_anchor);
			}

			if (if_block) if_block.d(detaching);
		}
	};
}

function create_fragment$4(ctx) {
	let if_block_anchor;
	let current;
	let if_block = /*info*/ ctx[6] && create_if_block$2(ctx);

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = empty$3();
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert$3(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			if (/*info*/ ctx[6]) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*info*/ 64) {
						transition_in$4(if_block, 1);
					}
				} else {
					if_block = create_if_block$2(ctx);
					if_block.c();
					transition_in$4(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				group_outros$3();

				transition_out$4(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros$3();
			}
		},
		i(local) {
			if (current) return;
			transition_in$4(if_block);
			current = true;
		},
		o(local) {
			transition_out$4(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$3(if_block_anchor);
			}

			if (if_block) if_block.d(detaching);
		}
	};
}

const js_docs = "https://www.gradio.app/guides/getting-started-with-the-js-client";
const py_docs = "https://www.gradio.app/guides/getting-started-with-the-python-client";
const spaces_docs_suffix = "#connecting-to-a-hugging-face-space";

function find_recursive(node, id) {
	if (node.id === id) {
		return node;
	}

	if (node.children) {
		for (let child of node.children) {
			let result = find_recursive(child, id);

			if (result) {
				return result;
			}
		}
	}

	return null;
}

function instance$3($$self, $$props, $$invalidate) {
	let { dependencies } = $$props;
	let { root } = $$props;
	let { app } = $$props;
	let { space_id } = $$props;
	let { root_node } = $$props;
	let api_count = dependencies.filter(dependency => dependency.show_api).length;

	if (root === "") {
		root = location.protocol + "//" + location.host + location.pathname;
	}

	if (!root.endsWith("/")) {
		root += "/";
	}

	let current_language = "python";
	const langs = [["python", python], ["javascript", javascript]];
	let is_running = false;

	dependencies.map(dependency => dependency.inputs.map(_id => {
		let default_data = find_recursive(root_node, _id)?.props?.default;

		if (default_data === undefined) {
			default_data = "";
		} else if (typeof default_data === "object") {
			default_data = JSON.stringify(default_data);
		}

		return default_data;
	}));

	dependencies.map(dependency => new Array(dependency.outputs.length));
	let dependency_failures = dependencies.map(dependency => new Array(dependency.inputs.length).fill(false));

	async function get_info() {
		let response = await fetch(root + "info");
		let data = await response.json();
		return data;
	}

	async function get_js_info() {
		let js_api_info = await app.view_api();
		return js_api_info;
	}

	let info;
	let js_info;

	get_info().then(data => {
		$$invalidate(6, info = data);
	});

	get_js_info().then(js_api_info => {
		$$invalidate(7, js_info = js_api_info);
	});

	onMount$2(() => {
		document.body.style.overflow = "hidden";

		if ("parentIFrame" in window) {
			window.parentIFrame?.scrollTo(0, 0);
		}

		return () => {
			document.body.style.overflow = "auto";
		};
	});

	function close_handler(event) {
		bubble$2.call(this, $$self, event);
	}

	const click_handler = language => $$invalidate(3, current_language = language);

	function close_handler_1(event) {
		bubble$2.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('dependencies' in $$props) $$invalidate(1, dependencies = $$props.dependencies);
		if ('root' in $$props) $$invalidate(0, root = $$props.root);
		if ('app' in $$props) $$invalidate(10, app = $$props.app);
		if ('space_id' in $$props) $$invalidate(2, space_id = $$props.space_id);
		if ('root_node' in $$props) $$invalidate(11, root_node = $$props.root_node);
	};

	return [
		root,
		dependencies,
		space_id,
		current_language,
		is_running,
		dependency_failures,
		info,
		js_info,
		api_count,
		langs,
		app,
		root_node,
		close_handler,
		click_handler,
		close_handler_1
	];
}

class ApiDocs extends SvelteComponent$4 {
	constructor(options) {
		super();

		init$4(this, options, instance$3, create_fragment$4, safe_not_equal$3, {
			dependencies: 1,
			root: 0,
			app: 10,
			space_id: 2,
			root_node: 11
		});
	}
}

get_store_value($format);
class Gradio {
  #id;
  #el;
  constructor(id, el, theme, version, root, autoscroll) {
    this.#id = id;
    this.theme = theme;
    this.version = version;
    this.#el = el;
    this.i18n = get_store_value($format);
    this.root = root;
    this.autoscroll = autoscroll;
  }
  dispatch(event_name, data) {
    const e = new CustomEvent("gradio", {
      bubbles: true,
      detail: { data, id: this.#id, event: event_name }
    });
    this.#el.dispatchEvent(e);
  }
}

/* src/RenderComponent.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$3,
	add_flush_callback: add_flush_callback$1,
	assign: assign$1,
	bind: bind_1,
	binding_callbacks: binding_callbacks_1,
	bubble: bubble$1,
	check_outros: check_outros$2,
	compute_rest_props,
	construct_svelte_component,
	create_component: create_component$3,
	create_slot,
	destroy_component: destroy_component$3,
	detach: detach$2,
	empty: empty$2,
	exclude_internal_props,
	get_all_dirty_from_scope,
	get_slot_changes,
	get_spread_object: get_spread_object$1,
	get_spread_update: get_spread_update$1,
	group_outros: group_outros$2,
	init: init$3,
	insert: insert$2,
	mount_component: mount_component$3,
	not_equal,
	transition_in: transition_in$3,
	transition_out: transition_out$3,
	update_slot_base
} = window.__gradio__svelte__internal;
const { bind: bind$1, binding_callbacks: binding_callbacks$1 } = window.__gradio__svelte__internal;
function create_default_slot$1(ctx) {
	let current;
	const default_slot_template = /*#slots*/ ctx[12].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[16], null);

	return {
		c() {
			if (default_slot) default_slot.c();
		},
		m(target, anchor) {
			if (default_slot) {
				default_slot.m(target, anchor);
			}

			current = true;
		},
		p(ctx, dirty) {
			if (default_slot) {
				if (default_slot.p && (!current || dirty & /*$$scope*/ 65536)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[16],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[16])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[16], dirty, null),
						null
					);
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in$3(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out$3(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (default_slot) default_slot.d(detaching);
		}
	};
}

function create_fragment$3(ctx) {
	let switch_instance;
	let updating_value;
	let switch_instance_anchor;
	let current;

	const switch_instance_spread_levels = [
		{ elem_id: /*elem_id*/ ctx[6] },
		{ elem_classes: /*elem_classes*/ ctx[7] },
		{ target: /*target*/ ctx[3] },
		/*$$restProps*/ ctx[9],
		{ theme_mode: /*theme_mode*/ ctx[4] },
		{ root: /*root*/ ctx[2] },
		{ gradio: /*gradio*/ ctx[5] }
	];

	function switch_instance_value_binding(value) {
		/*switch_instance_value_binding*/ ctx[14](value);
	}

	var switch_value = /*_component*/ ctx[8];

	function switch_props(ctx, dirty) {
		let switch_instance_props = {
			$$slots: { default: [create_default_slot$1] },
			$$scope: { ctx }
		};

		if (dirty !== undefined && dirty & /*elem_id, elem_classes, target, $$restProps, theme_mode, root, gradio*/ 764) {
			switch_instance_props = get_spread_update$1(switch_instance_spread_levels, [
				dirty & /*elem_id*/ 64 && { elem_id: /*elem_id*/ ctx[6] },
				dirty & /*elem_classes*/ 128 && { elem_classes: /*elem_classes*/ ctx[7] },
				dirty & /*target*/ 8 && { target: /*target*/ ctx[3] },
				dirty & /*$$restProps*/ 512 && get_spread_object$1(/*$$restProps*/ ctx[9]),
				dirty & /*theme_mode*/ 16 && { theme_mode: /*theme_mode*/ ctx[4] },
				dirty & /*root*/ 4 && { root: /*root*/ ctx[2] },
				dirty & /*gradio*/ 32 && { gradio: /*gradio*/ ctx[5] }
			]);
		} else {
			for (let i = 0; i < switch_instance_spread_levels.length; i += 1) {
				switch_instance_props = assign$1(switch_instance_props, switch_instance_spread_levels[i]);
			}
		}

		if (/*value*/ ctx[1] !== void 0) {
			switch_instance_props.value = /*value*/ ctx[1];
		}

		return { props: switch_instance_props };
	}

	if (switch_value) {
		switch_instance = construct_svelte_component(switch_value, switch_props(ctx));
		/*switch_instance_binding*/ ctx[13](switch_instance);
		binding_callbacks_1.push(() => bind_1(switch_instance, 'value', switch_instance_value_binding));
		switch_instance.$on("prop_change", /*prop_change_handler*/ ctx[15]);
	}

	return {
		c() {
			if (switch_instance) create_component$3(switch_instance.$$.fragment);
			switch_instance_anchor = empty$2();
		},
		m(target, anchor) {
			if (switch_instance) mount_component$3(switch_instance, target, anchor);
			insert$2(target, switch_instance_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			if (switch_value !== (switch_value = /*_component*/ ctx[8])) {
				if (switch_instance) {
					group_outros$2();
					const old_component = switch_instance;

					transition_out$3(old_component.$$.fragment, 1, 0, () => {
						destroy_component$3(old_component, 1);
					});

					check_outros$2();
				}

				if (switch_value) {
					switch_instance = construct_svelte_component(switch_value, switch_props(ctx, dirty));
					/*switch_instance_binding*/ ctx[13](switch_instance);
					binding_callbacks_1.push(() => bind_1(switch_instance, 'value', switch_instance_value_binding));
					switch_instance.$on("prop_change", /*prop_change_handler*/ ctx[15]);
					create_component$3(switch_instance.$$.fragment);
					transition_in$3(switch_instance.$$.fragment, 1);
					mount_component$3(switch_instance, switch_instance_anchor.parentNode, switch_instance_anchor);
				} else {
					switch_instance = null;
				}
			} else if (switch_value) {
				const switch_instance_changes = (dirty & /*elem_id, elem_classes, target, $$restProps, theme_mode, root, gradio*/ 764)
				? get_spread_update$1(switch_instance_spread_levels, [
						dirty & /*elem_id*/ 64 && { elem_id: /*elem_id*/ ctx[6] },
						dirty & /*elem_classes*/ 128 && { elem_classes: /*elem_classes*/ ctx[7] },
						dirty & /*target*/ 8 && { target: /*target*/ ctx[3] },
						dirty & /*$$restProps*/ 512 && get_spread_object$1(/*$$restProps*/ ctx[9]),
						dirty & /*theme_mode*/ 16 && { theme_mode: /*theme_mode*/ ctx[4] },
						dirty & /*root*/ 4 && { root: /*root*/ ctx[2] },
						dirty & /*gradio*/ 32 && { gradio: /*gradio*/ ctx[5] }
					])
				: {};

				if (dirty & /*$$scope*/ 65536) {
					switch_instance_changes.$$scope = { dirty, ctx };
				}

				if (!updating_value && dirty & /*value*/ 2) {
					updating_value = true;
					switch_instance_changes.value = /*value*/ ctx[1];
					add_flush_callback$1(() => updating_value = false);
				}

				switch_instance.$set(switch_instance_changes);
			}
		},
		i(local) {
			if (current) return;
			if (switch_instance) transition_in$3(switch_instance.$$.fragment, local);
			current = true;
		},
		o(local) {
			if (switch_instance) transition_out$3(switch_instance.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(switch_instance_anchor);
			}

			/*switch_instance_binding*/ ctx[13](null);
			if (switch_instance) destroy_component$3(switch_instance, detaching);
		}
	};
}

function instance_1($$self, $$props, $$invalidate) {
	const omit_props_names = [
		"root","component","target","theme_mode","instance","value","gradio","elem_id","elem_classes","id"
	];

	let $$restProps = compute_rest_props($$props, omit_props_names);
	let { $$slots: slots = {}, $$scope } = $$props;
	let { root } = $$props;
	let { component } = $$props;
	let { target } = $$props;
	let { theme_mode } = $$props;
	let { instance } = $$props;
	let { value } = $$props;
	let { gradio } = $$props;
	let { elem_id } = $$props;
	let { elem_classes } = $$props;
	let { id } = $$props;
	const s = (id, p, v) => new CustomEvent("prop_change", { detail: { id, prop: p, value: v } });

	function wrap(component) {
		const ProxiedMyClass = new Proxy(component,
		{
				construct(_target, args) {
					//@ts-ignore
					const instance = new _target(...args);

					const props = Object.getOwnPropertyNames(instance).filter(s => !s.startsWith("$"));

					function report(props) {
						return function (propargs) {
							const ev = s(id, props, propargs);
							target.dispatchEvent(ev);
						};
					}

					props.forEach(v => {
						binding_callbacks$1.push(() => bind$1(instance, v, report(v)));
					});

					return instance;
				}
			});

		return ProxiedMyClass;
	}

	const _component = wrap(component);

	function switch_instance_binding($$value) {
		binding_callbacks_1[$$value ? 'unshift' : 'push'](() => {
			instance = $$value;
			$$invalidate(0, instance);
		});
	}

	function switch_instance_value_binding(value$1) {
		value = value$1;
		$$invalidate(1, value);
	}

	function prop_change_handler(event) {
		bubble$1.call(this, $$self, event);
	}

	$$self.$$set = $$new_props => {
		$$props = assign$1(assign$1({}, $$props), exclude_internal_props($$new_props));
		$$invalidate(9, $$restProps = compute_rest_props($$props, omit_props_names));
		if ('root' in $$new_props) $$invalidate(2, root = $$new_props.root);
		if ('component' in $$new_props) $$invalidate(10, component = $$new_props.component);
		if ('target' in $$new_props) $$invalidate(3, target = $$new_props.target);
		if ('theme_mode' in $$new_props) $$invalidate(4, theme_mode = $$new_props.theme_mode);
		if ('instance' in $$new_props) $$invalidate(0, instance = $$new_props.instance);
		if ('value' in $$new_props) $$invalidate(1, value = $$new_props.value);
		if ('gradio' in $$new_props) $$invalidate(5, gradio = $$new_props.gradio);
		if ('elem_id' in $$new_props) $$invalidate(6, elem_id = $$new_props.elem_id);
		if ('elem_classes' in $$new_props) $$invalidate(7, elem_classes = $$new_props.elem_classes);
		if ('id' in $$new_props) $$invalidate(11, id = $$new_props.id);
		if ('$$scope' in $$new_props) $$invalidate(16, $$scope = $$new_props.$$scope);
	};

	return [
		instance,
		value,
		root,
		target,
		theme_mode,
		gradio,
		elem_id,
		elem_classes,
		_component,
		$$restProps,
		component,
		id,
		slots,
		switch_instance_binding,
		switch_instance_value_binding,
		prop_change_handler,
		$$scope
	];
}

class RenderComponent extends SvelteComponent$3 {
	constructor(options) {
		super();

		init$3(this, options, instance_1, create_fragment$3, not_equal, {
			root: 2,
			component: 10,
			target: 3,
			theme_mode: 4,
			instance: 0,
			value: 1,
			gradio: 5,
			elem_id: 6,
			elem_classes: 7,
			id: 11
		});
	}
}

/* src/Render.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$2,
	add_flush_callback,
	assign,
	bind,
	binding_callbacks,
	bubble,
	check_outros: check_outros$1,
	create_component: create_component$2,
	destroy_component: destroy_component$2,
	detach: detach$1,
	empty: empty$1,
	ensure_array_like,
	get_spread_object,
	get_spread_update,
	group_outros: group_outros$1,
	init: init$2,
	insert: insert$1,
	mount_component: mount_component$2,
	outro_and_destroy_block,
	safe_not_equal: safe_not_equal$2,
	transition_in: transition_in$2,
	transition_out: transition_out$2,
	update_keyed_each
} = window.__gradio__svelte__internal;const { onMount: onMount$1, createEventDispatcher: createEventDispatcher$1, setContext } = window.__gradio__svelte__internal;
function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[13] = list[i];
	return child_ctx;
}

// (67:1) {#if node.children && node.children.length}
function create_if_block$1(ctx) {
	let each_blocks = [];
	let each_1_lookup = new Map();
	let each_1_anchor;
	let current;
	let each_value = ensure_array_like(/*node*/ ctx[0].children);
	const get_key = ctx => /*_node*/ ctx[13].id;

	for (let i = 0; i < each_value.length; i += 1) {
		let child_ctx = get_each_context(ctx, each_value, i);
		let key = get_key(child_ctx);
		each_1_lookup.set(key, each_blocks[i] = create_each_block(key, child_ctx));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty$1();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert$1(target, each_1_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (dirty & /*node, target, root, theme_mode*/ 15) {
				each_value = ensure_array_like(/*node*/ ctx[0].children);
				group_outros$1();
				each_blocks = update_keyed_each(each_blocks, dirty, get_key, 1, ctx, each_value, each_1_lookup, each_1_anchor.parentNode, outro_and_destroy_block, create_each_block, each_1_anchor, get_each_context);
				check_outros$1();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in$2(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out$2(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(each_1_anchor);
			}

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].d(detaching);
			}
		}
	};
}

// (68:2) {#each node.children as _node (_node.id)}
function create_each_block(key_1, ctx) {
	let first;
	let render;
	let current;

	render = new Render({
			props: {
				node: /*_node*/ ctx[13],
				component: /*_node*/ ctx[13].component,
				target: /*target*/ ctx[2],
				id: /*_node*/ ctx[13].id,
				root: /*root*/ ctx[1],
				theme_mode: /*theme_mode*/ ctx[3]
			}
		});

	render.$on("destroy", /*destroy_handler*/ ctx[7]);
	render.$on("mount", /*mount_handler*/ ctx[8]);

	return {
		key: key_1,
		first: null,
		c() {
			first = empty$1();
			create_component$2(render.$$.fragment);
			this.first = first;
		},
		m(target, anchor) {
			insert$1(target, first, anchor);
			mount_component$2(render, target, anchor);
			current = true;
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			const render_changes = {};
			if (dirty & /*node*/ 1) render_changes.node = /*_node*/ ctx[13];
			if (dirty & /*node*/ 1) render_changes.component = /*_node*/ ctx[13].component;
			if (dirty & /*target*/ 4) render_changes.target = /*target*/ ctx[2];
			if (dirty & /*node*/ 1) render_changes.id = /*_node*/ ctx[13].id;
			if (dirty & /*root*/ 2) render_changes.root = /*root*/ ctx[1];
			if (dirty & /*theme_mode*/ 8) render_changes.theme_mode = /*theme_mode*/ ctx[3];
			render.$set(render_changes);
		},
		i(local) {
			if (current) return;
			transition_in$2(render.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(render.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(first);
			}

			destroy_component$2(render, detaching);
		}
	};
}

// (52:0) <RenderComponent  id={node.id}  component={node.component}  bind:instance={node.instance}  bind:value={node.props.value}  elem_id={("elem_id" in node.props && node.props.elem_id) ||   `component-${node.id}`}  elem_classes={("elem_classes" in node.props && node.props.elem_classes) || []}  on:prop_change={handle_prop_change}  {target}  {...node.props}  {theme_mode}  {root}  gradio={new Gradio(node.id, target, theme_mode, version, root, autoscroll)} >
function create_default_slot(ctx) {
	let if_block_anchor;
	let current;
	let if_block = /*node*/ ctx[0].children && /*node*/ ctx[0].children.length && create_if_block$1(ctx);

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = empty$1();
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert$1(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (/*node*/ ctx[0].children && /*node*/ ctx[0].children.length) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*node*/ 1) {
						transition_in$2(if_block, 1);
					}
				} else {
					if_block = create_if_block$1(ctx);
					if_block.c();
					transition_in$2(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				group_outros$1();

				transition_out$2(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros$1();
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(if_block);
			current = true;
		},
		o(local) {
			transition_out$2(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(if_block_anchor);
			}

			if (if_block) if_block.d(detaching);
		}
	};
}

function create_fragment$2(ctx) {
	let rendercomponent;
	let updating_instance;
	let updating_value;
	let current;

	const rendercomponent_spread_levels = [
		{ id: /*node*/ ctx[0].id },
		{ component: /*node*/ ctx[0].component },
		{
			elem_id: "elem_id" in /*node*/ ctx[0].props && /*node*/ ctx[0].props.elem_id || `component-${/*node*/ ctx[0].id}`
		},
		{
			elem_classes: "elem_classes" in /*node*/ ctx[0].props && /*node*/ ctx[0].props.elem_classes || []
		},
		{ target: /*target*/ ctx[2] },
		/*node*/ ctx[0].props,
		{ theme_mode: /*theme_mode*/ ctx[3] },
		{ root: /*root*/ ctx[1] },
		{
			gradio: new Gradio(/*node*/ ctx[0].id, /*target*/ ctx[2], /*theme_mode*/ ctx[3], /*version*/ ctx[4], /*root*/ ctx[1], /*autoscroll*/ ctx[5])
		}
	];

	function rendercomponent_instance_binding(value) {
		/*rendercomponent_instance_binding*/ ctx[9](value);
	}

	function rendercomponent_value_binding(value) {
		/*rendercomponent_value_binding*/ ctx[10](value);
	}

	let rendercomponent_props = {
		$$slots: { default: [create_default_slot] },
		$$scope: { ctx }
	};

	for (let i = 0; i < rendercomponent_spread_levels.length; i += 1) {
		rendercomponent_props = assign(rendercomponent_props, rendercomponent_spread_levels[i]);
	}

	if (/*node*/ ctx[0].instance !== void 0) {
		rendercomponent_props.instance = /*node*/ ctx[0].instance;
	}

	if (/*node*/ ctx[0].props.value !== void 0) {
		rendercomponent_props.value = /*node*/ ctx[0].props.value;
	}

	rendercomponent = new RenderComponent({ props: rendercomponent_props });
	binding_callbacks.push(() => bind(rendercomponent, 'instance', rendercomponent_instance_binding));
	binding_callbacks.push(() => bind(rendercomponent, 'value', rendercomponent_value_binding));
	rendercomponent.$on("prop_change", handle_prop_change);

	return {
		c() {
			create_component$2(rendercomponent.$$.fragment);
		},
		m(target, anchor) {
			mount_component$2(rendercomponent, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const rendercomponent_changes = (dirty & /*node, target, theme_mode, root, version, autoscroll*/ 63)
			? get_spread_update(rendercomponent_spread_levels, [
					dirty & /*node*/ 1 && { id: /*node*/ ctx[0].id },
					dirty & /*node*/ 1 && { component: /*node*/ ctx[0].component },
					dirty & /*node*/ 1 && {
						elem_id: "elem_id" in /*node*/ ctx[0].props && /*node*/ ctx[0].props.elem_id || `component-${/*node*/ ctx[0].id}`
					},
					dirty & /*node*/ 1 && {
						elem_classes: "elem_classes" in /*node*/ ctx[0].props && /*node*/ ctx[0].props.elem_classes || []
					},
					dirty & /*target*/ 4 && { target: /*target*/ ctx[2] },
					dirty & /*node*/ 1 && get_spread_object(/*node*/ ctx[0].props),
					dirty & /*theme_mode*/ 8 && { theme_mode: /*theme_mode*/ ctx[3] },
					dirty & /*root*/ 2 && { root: /*root*/ ctx[1] },
					{
						gradio: new Gradio(/*node*/ ctx[0].id, /*target*/ ctx[2], /*theme_mode*/ ctx[3], /*version*/ ctx[4], /*root*/ ctx[1], /*autoscroll*/ ctx[5])
					}
				])
			: {};

			if (dirty & /*$$scope, node, target, root, theme_mode*/ 65551) {
				rendercomponent_changes.$$scope = { dirty, ctx };
			}

			if (!updating_instance && dirty & /*node*/ 1) {
				updating_instance = true;
				rendercomponent_changes.instance = /*node*/ ctx[0].instance;
				add_flush_callback(() => updating_instance = false);
			}

			if (!updating_value && dirty & /*node*/ 1) {
				updating_value = true;
				rendercomponent_changes.value = /*node*/ ctx[0].props.value;
				add_flush_callback(() => updating_value = false);
			}

			rendercomponent.$set(rendercomponent_changes);
		},
		i(local) {
			if (current) return;
			transition_in$2(rendercomponent.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(rendercomponent.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$2(rendercomponent, detaching);
		}
	};
}

function handle_prop_change(e) {
	
} // for (const k in e.detail) {
// 	instance_map[id].props[k] = e.detail[k];

function instance$2($$self, $$props, $$invalidate) {
	let { root } = $$props;
	let { node } = $$props;
	let { parent = null } = $$props;
	let { target } = $$props;
	let { theme_mode } = $$props;
	let { version } = $$props;
	let { autoscroll } = $$props;
	const dispatch = createEventDispatcher$1();
	let filtered_children = [];

	onMount$1(() => {
		dispatch("mount", node.id);

		for (const child of filtered_children) {
			dispatch("mount", child.id);
		}

		return () => {
			dispatch("destroy", node.id);

			for (const child of filtered_children) {
				dispatch("mount", child.id);
			}
		};
	});

	setContext("BLOCK_KEY", parent);

	function destroy_handler(event) {
		bubble.call(this, $$self, event);
	}

	function mount_handler(event) {
		bubble.call(this, $$self, event);
	}

	function rendercomponent_instance_binding(value) {
		if ($$self.$$.not_equal(node.instance, value)) {
			node.instance = value;
			($$invalidate(0, node), $$invalidate(12, filtered_children));
		}
	}

	function rendercomponent_value_binding(value) {
		if ($$self.$$.not_equal(node.props.value, value)) {
			node.props.value = value;
			($$invalidate(0, node), $$invalidate(12, filtered_children));
		}
	}

	$$self.$$set = $$props => {
		if ('root' in $$props) $$invalidate(1, root = $$props.root);
		if ('node' in $$props) $$invalidate(0, node = $$props.node);
		if ('parent' in $$props) $$invalidate(6, parent = $$props.parent);
		if ('target' in $$props) $$invalidate(2, target = $$props.target);
		if ('theme_mode' in $$props) $$invalidate(3, theme_mode = $$props.theme_mode);
		if ('version' in $$props) $$invalidate(4, version = $$props.version);
		if ('autoscroll' in $$props) $$invalidate(5, autoscroll = $$props.autoscroll);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*node*/ 1) {
			$$invalidate(
				0,
				node.children = node.children && node.children.filter(v => {
					const valid_node = node.type !== "statustracker";

					if (!valid_node) {
						filtered_children.push(v);
					}

					return valid_node;
				}),
				node
			);
		}

		if ($$self.$$.dirty & /*node*/ 1) {
			// }
			{
				if (node.type === "form") {
					if (node.children?.every(c => !c.props.visible)) {
						$$invalidate(0, node.props.visible = false, node);
					} else {
						$$invalidate(0, node.props.visible = true, node);
					}
				}
			}
		}
	};

	return [
		node,
		root,
		target,
		theme_mode,
		version,
		autoscroll,
		parent,
		destroy_handler,
		mount_handler,
		rendercomponent_instance_binding,
		rendercomponent_value_binding
	];
}

class Render extends SvelteComponent$2 {
	constructor(options) {
		super();

		init$2(this, options, instance$2, create_fragment$2, safe_not_equal$2, {
			root: 1,
			node: 0,
			parent: 6,
			target: 2,
			theme_mode: 3,
			version: 4,
			autoscroll: 5
		});
	}
}

/* src/MountComponents.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$1,
	create_component: create_component$1,
	destroy_component: destroy_component$1,
	init: init$1,
	mount_component: mount_component$1,
	safe_not_equal: safe_not_equal$1,
	transition_in: transition_in$1,
	transition_out: transition_out$1
} = window.__gradio__svelte__internal;
const { onMount, createEventDispatcher } = window.__gradio__svelte__internal;
function create_fragment$1(ctx) {
	let render;
	let current;

	render = new Render({
			props: {
				node: /*rootNode*/ ctx[0],
				root: /*root*/ ctx[1],
				target: /*target*/ ctx[2],
				theme_mode: /*theme_mode*/ ctx[3],
				version: /*version*/ ctx[4],
				autoscroll: /*autoscroll*/ ctx[5]
			}
		});

	return {
		c() {
			create_component$1(render.$$.fragment);
		},
		m(target, anchor) {
			mount_component$1(render, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const render_changes = {};
			if (dirty & /*rootNode*/ 1) render_changes.node = /*rootNode*/ ctx[0];
			if (dirty & /*root*/ 2) render_changes.root = /*root*/ ctx[1];
			if (dirty & /*target*/ 4) render_changes.target = /*target*/ ctx[2];
			if (dirty & /*theme_mode*/ 8) render_changes.theme_mode = /*theme_mode*/ ctx[3];
			if (dirty & /*version*/ 16) render_changes.version = /*version*/ ctx[4];
			if (dirty & /*autoscroll*/ 32) render_changes.autoscroll = /*autoscroll*/ ctx[5];
			render.$set(render_changes);
		},
		i(local) {
			if (current) return;
			transition_in$1(render.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(render.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$1(render, detaching);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { rootNode } = $$props;
	let { root } = $$props;
	let { target } = $$props;
	let { theme_mode } = $$props;
	let { version } = $$props;
	let { autoscroll } = $$props;
	const dispatch = createEventDispatcher();

	onMount(() => {
		dispatch("mount");
	});

	$$self.$$set = $$props => {
		if ('rootNode' in $$props) $$invalidate(0, rootNode = $$props.rootNode);
		if ('root' in $$props) $$invalidate(1, root = $$props.root);
		if ('target' in $$props) $$invalidate(2, target = $$props.target);
		if ('theme_mode' in $$props) $$invalidate(3, theme_mode = $$props.theme_mode);
		if ('version' in $$props) $$invalidate(4, version = $$props.version);
		if ('autoscroll' in $$props) $$invalidate(5, autoscroll = $$props.autoscroll);
	};

	return [rootNode, root, target, theme_mode, version, autoscroll];
}

class MountComponents extends SvelteComponent$1 {
	constructor(options) {
		super();

		init$1(this, options, instance$1, create_fragment$1, safe_not_equal$1, {
			rootNode: 0,
			root: 1,
			target: 2,
			theme_mode: 3,
			version: 4,
			autoscroll: 5
		});
	}
}

const logo = ""+new URL('logo-3707f936.svg', import.meta.url).href+"";

const component_map = {
			"accordion": {
			
			component: () => __vitePreload(() => import('./Index-5751965a.js'),true?["./Index-5751965a.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./Index-24a33ce1.js","./Index-2abed479.css","./Index-a90cda25.css"]:void 0,import.meta.url)
			},
"annotatedimage": {
			
			component: () => __vitePreload(() => import('./Index-eb3b23bd.js'),true?["./Index-eb3b23bd.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockLabel-c880a272.js","./Empty-79b64d64.js","./Image-6cbf81d1.js","./file-url-fbb30a3f.js","./Index-1454732f.css"]:void 0,import.meta.url)
			},
"audio": {
			example: () => __vitePreload(() => import('./Example-63607f02.js'),true?["./Example-63607f02.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./index-a1cf51ca.js'),true?["./index-a1cf51ca.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./utils-013c0d40.js","./BlockLabel-c880a272.js","./IconButton-246ba9e7.js","./Empty-79b64d64.js","./ShareButton-77ad7d11.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./Music-3a56b469.js","./Trim-0317ad89.js","./Undo-6c110254.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./ModifyUpload-af686f29.js","./Clear-9760deed.js","./SelectSource-ada22a1a.js","./Upload-c5c1b405.js","./UploadText-7dd08ed3.js","./Example-63607f02.js","./Example-55d94c71.css","./index-1f07386a.css"]:void 0,import.meta.url)
			},
"box": {
			
			component: () => __vitePreload(() => import('./Index-29afb1b9.js'),true?["./Index-29afb1b9.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css"]:void 0,import.meta.url)
			},
"button": {
			
			component: () => __vitePreload(() => import('./Index-fe1a1506.js'),true?["./Index-fe1a1506.js","./index-ec890757.js","./index-87ad2184.css","./Button-cca92c6b.js","./Index-3b1865e7.js","./Index-eb210efd.css","./Button-2a9911a9.css"]:void 0,import.meta.url)
			},
"chatbot": {
			
			component: () => __vitePreload(() => import('./Index-bc16dbe6.js'),true?["./Index-bc16dbe6.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./utils-013c0d40.js","./index-21d69e4c.js","./ShareButton-77ad7d11.js","./IconButton-246ba9e7.js","./file-url-fbb30a3f.js","./Image-21f57ab7.js","./Image-7b829b60.css","./Video-31cd3cb8.js","./Video-540eb7aa.css","./Index.svelte_svelte_type_style_lang-d63496c0.js","./Example.svelte_svelte_type_style_lang-119f6e2d.js","./prism-python-b759ea26.js","./Example-b228065c.css","./Index-11e1685d.css","./Check-f7edb5d9.js","./Copy-a69620a8.js","./BlockLabel-c880a272.js","./Index-7ea7c4ca.css"]:void 0,import.meta.url)
			},
"checkbox": {
			example: () => __vitePreload(() => import('./Example-ce3e8356.js'),true?["./Example-ce3e8356.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-4f4534d7.js'),true?["./Index-4f4534d7.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./Info-954040b2.js","./Index-6224b77c.css"]:void 0,import.meta.url)
			},
"checkboxgroup": {
			example: () => __vitePreload(() => import('./Example-a2cac5a5.js'),true?["./Example-a2cac5a5.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-2a885e5a.js'),true?["./Index-2a885e5a.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockTitle-41004e81.js","./Info-954040b2.js","./Index-5676d3d3.css"]:void 0,import.meta.url)
			},
"code": {
			example: () => __vitePreload(() => import('./Example-26f7bda8.js'),true?["./Example-26f7bda8.js","./Example-c56e7331.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-20ee466d.js').then(n => n.F),true?["./Index-20ee466d.js","./index-ec890757.js","./index-87ad2184.css","./Button-cca92c6b.js","./Index-3b1865e7.js","./Index-eb210efd.css","./Button-2a9911a9.css","./Check-f7edb5d9.js","./Copy-a69620a8.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./BlockLabel-c880a272.js","./Empty-79b64d64.js","./Example-26f7bda8.js","./Example-c56e7331.css","./Index-9369397e.css"]:void 0,import.meta.url)
			},
"colorpicker": {
			example: () => __vitePreload(() => import('./Example-85be0e05.js'),true?["./Example-85be0e05.js","./Example-5be72496.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-03f2d13b.js'),true?["./Index-03f2d13b.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockTitle-41004e81.js","./Info-954040b2.js","./Example-85be0e05.js","./Example-5be72496.css","./Index-497c6364.css"]:void 0,import.meta.url)
			},
"column": {
			
			component: () => __vitePreload(() => import('./Index-24a33ce1.js'),true?["./Index-24a33ce1.js","./Index-2abed479.css"]:void 0,import.meta.url)
			},
"dataframe": {
			example: () => __vitePreload(() => import('./Example-bac8e01d.js'),true?["./Example-bac8e01d.js","./Example-aca1592e.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-e15e9182.js'),true?["./Index-e15e9182.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./index-21d69e4c.js","./utils-013c0d40.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./Index.svelte_svelte_type_style_lang-d63496c0.js","./Example.svelte_svelte_type_style_lang-119f6e2d.js","./prism-python-b759ea26.js","./Example-b228065c.css","./Index-11e1685d.css","./dsv-a37bb3db.js","./Example-bac8e01d.js","./Example-aca1592e.css","./Index-960777cd.css"]:void 0,import.meta.url)
			},
"dataset": {
			
			component: () => __vitePreload(() => import('./Index-ccb57a85.js'),true?["./Index-ccb57a85.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./Index-52db28fc.css"]:void 0,import.meta.url)
			},
"downloadbutton": {
			
			component: () => __vitePreload(() => import('./Index-46be53db.js'),true?["./Index-46be53db.js","./index-ec890757.js","./index-87ad2184.css","./Button-cca92c6b.js","./Index-3b1865e7.js","./Index-eb210efd.css","./Button-2a9911a9.css","./Index-b8ed6844.css"]:void 0,import.meta.url)
			},
"dropdown": {
			example: () => __vitePreload(() => import('./Example-84a3b179.js'),true?["./Example-84a3b179.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-4d155ca6.js'),true?["./Index-4d155ca6.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-cca92c6b.js","./Button-2a9911a9.css","./BlockTitle-41004e81.js","./Info-954040b2.js","./DropdownArrow-e7cb3811.js","./Example-84a3b179.js","./Example-55d94c71.css","./Index-99d07eaa.css"]:void 0,import.meta.url)
			},
"file": {
			example: () => __vitePreload(() => import('./Example-04e4c2ae.js'),true?["./Example-04e4c2ae.js","./Example-4f56d95a.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-ad21f795.js'),true?["./Index-ad21f795.js","./FileUpload-63cdd8fd.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockLabel-c880a272.js","./Empty-79b64d64.js","./File-e96cd7d6.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./ModifyUpload-af686f29.js","./IconButton-246ba9e7.js","./Clear-9760deed.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./Undo-6c110254.js","./FileUpload-284cdfec.css","./UploadText-7dd08ed3.js","./Upload-c5c1b405.js","./Example-04e4c2ae.js","./Example-4f56d95a.css"]:void 0,import.meta.url)
			},
"fileexplorer": {
			example: () => __vitePreload(() => import('./Example-e80d1b80.js'),true?["./Example-e80d1b80.js","./Example-7cc47009.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-96577d37.js'),true?["./Index-96577d37.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./File-e96cd7d6.js","./Button-cca92c6b.js","./Button-2a9911a9.css","./BlockLabel-c880a272.js","./Index-211277ac.css"]:void 0,import.meta.url)
			},
"form": {
			
			component: () => __vitePreload(() => import('./Index-0d7ad3de.js'),true?["./Index-0d7ad3de.js","./Index-7ab72019.css"]:void 0,import.meta.url)
			},
"gallery": {
			
			component: () => __vitePreload(() => import('./Index-30ba0127.js'),true?["./Index-30ba0127.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./UploadText-7dd08ed3.js","./Upload-c5c1b405.js","./BlockLabel-c880a272.js","./IconButton-246ba9e7.js","./Empty-79b64d64.js","./ShareButton-77ad7d11.js","./utils-013c0d40.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./Image-6cbf81d1.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./ModifyUpload-af686f29.js","./Clear-9760deed.js","./Undo-6c110254.js","./Image-21f57ab7.js","./Image-7b829b60.css","./FileUpload-63cdd8fd.js","./File-e96cd7d6.js","./FileUpload-284cdfec.css","./Index-316eaab2.css","./Example-4f56d95a.css"]:void 0,import.meta.url)
			},
"group": {
			
			component: () => __vitePreload(() => import('./Index-a3ffbeb0.js'),true?["./Index-a3ffbeb0.js","./Index-e45a2b11.css"]:void 0,import.meta.url)
			},
"highlightedtext": {
			
			component: () => __vitePreload(() => import('./Index-db7709c5.js'),true?["./Index-db7709c5.js","./color-7ac2560d.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockLabel-c880a272.js","./Empty-79b64d64.js","./Index-a4c50cbd.css"]:void 0,import.meta.url)
			},
"html": {
			example: () => __vitePreload(() => import('./Example-39f519bd.js'),true?["./Example-39f519bd.js","./Example-eac655f5.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-3b309474.js'),true?["./Index-3b309474.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-cca92c6b.js","./Button-2a9911a9.css","./Index-5538a1d8.css"]:void 0,import.meta.url)
			},
"image": {
			example: () => __vitePreload(() => import('./Example-d62ea019.js'),true?["./Example-d62ea019.js","./Image-21f57ab7.js","./file-url-fbb30a3f.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Image-7b829b60.css","./Example-e441efe6.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-cedc25fb.js'),true?["./Index-cedc25fb.js","./ImageUploader-d498cfc3.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./utils-013c0d40.js","./BlockLabel-c880a272.js","./IconButton-246ba9e7.js","./Empty-79b64d64.js","./ShareButton-77ad7d11.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./Image-6cbf81d1.js","./Image-21f57ab7.js","./Image-7b829b60.css","./SelectSource-ada22a1a.js","./Upload-c5c1b405.js","./DropdownArrow-e7cb3811.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./Clear-9760deed.js","./ImageUploader-57e340a3.css","./UploadText-7dd08ed3.js","./Example-d62ea019.js","./Example-e441efe6.css"]:void 0,import.meta.url)
			},
"imageeditor": {
			example: () => __vitePreload(() => import('./Example-c88b3c5d.js'),true?["./Example-c88b3c5d.js","./ImageUploader-d498cfc3.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./utils-013c0d40.js","./BlockLabel-c880a272.js","./IconButton-246ba9e7.js","./Empty-79b64d64.js","./ShareButton-77ad7d11.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./Image-6cbf81d1.js","./Image-21f57ab7.js","./Image-7b829b60.css","./SelectSource-ada22a1a.js","./Upload-c5c1b405.js","./DropdownArrow-e7cb3811.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./Clear-9760deed.js","./ImageUploader-57e340a3.css","./Example-2b10ae8c.css","./Example-e441efe6.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-c11ff142.js'),true?["./Index-c11ff142.js","./ImageUploader-d498cfc3.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./utils-013c0d40.js","./BlockLabel-c880a272.js","./IconButton-246ba9e7.js","./Empty-79b64d64.js","./ShareButton-77ad7d11.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./Image-6cbf81d1.js","./Image-21f57ab7.js","./Image-7b829b60.css","./SelectSource-ada22a1a.js","./Upload-c5c1b405.js","./DropdownArrow-e7cb3811.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./Clear-9760deed.js","./ImageUploader-57e340a3.css","./__vite-browser-external-cb19bde2.js","./Check-f7edb5d9.js","./Undo-6c110254.js","./Index-20f25ba4.css","./Example-e441efe6.css"]:void 0,import.meta.url)
			},
"json": {
			
			component: () => __vitePreload(() => import('./Index-ed22e5aa.js'),true?["./Index-ed22e5aa.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./Check-f7edb5d9.js","./Copy-a69620a8.js","./Empty-79b64d64.js","./BlockLabel-c880a272.js","./Index-8659c753.css"]:void 0,import.meta.url)
			},
"label": {
			
			component: () => __vitePreload(() => import('./Index-242fafed.js'),true?["./Index-242fafed.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-cca92c6b.js","./Button-2a9911a9.css","./BlockLabel-c880a272.js","./Empty-79b64d64.js","./Index-d2e7a806.css"]:void 0,import.meta.url)
			},
"markdown": {
			example: () => __vitePreload(() => import('./Example-b00bd494.js'),true?["./Example-b00bd494.js","./Example.svelte_svelte_type_style_lang-119f6e2d.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./prism-python-b759ea26.js","./Example-b228065c.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-16f519a5.js'),true?["./Index-16f519a5.js","./Index.svelte_svelte_type_style_lang-d63496c0.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./utils-013c0d40.js","./Example.svelte_svelte_type_style_lang-119f6e2d.js","./prism-python-b759ea26.js","./Example-b228065c.css","./Index-11e1685d.css","./Example-b00bd494.js"]:void 0,import.meta.url)
			},
"model3d": {
			example: () => __vitePreload(() => import('./Example-a0d6492c.js'),true?["./Example-a0d6492c.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-a52db290.js'),true?["./Index-a52db290.js","./index-ec890757.js","./index-87ad2184.css","./Button-cca92c6b.js","./Index-3b1865e7.js","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockLabel-c880a272.js","./IconButton-246ba9e7.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./File-e96cd7d6.js","./Undo-6c110254.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./ModifyUpload-af686f29.js","./Clear-9760deed.js","./Empty-79b64d64.js","./UploadText-7dd08ed3.js","./Upload-c5c1b405.js","./Example-a0d6492c.js","./Example-55d94c71.css","./Index-c5d3e223.css"]:void 0,import.meta.url)
			},
"multimodaltextbox": {
			example: () => __vitePreload(() => import('./Example-2a61eb0c.js'),true?["./Example-2a61eb0c.js","./Image-21f57ab7.js","./file-url-fbb30a3f.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Image-7b829b60.css","./Example-431605fb.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-2f742270.js'),true?["./Index-2f742270.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockTitle-41004e81.js","./Info-954040b2.js","./Clear-9760deed.js","./File-e96cd7d6.js","./Music-3a56b469.js","./Video-3f84d9ec.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./ModifyUpload-7979c5fd.css","./Image-21f57ab7.js","./file-url-fbb30a3f.js","./Image-7b829b60.css","./Example-2a61eb0c.js","./Example-431605fb.css","./Index-c3a0fd99.css"]:void 0,import.meta.url)
			},
"number": {
			example: () => __vitePreload(() => import('./Example-6dde398e.js'),true?["./Example-6dde398e.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-676dc2f6.js'),true?["./Index-676dc2f6.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockTitle-41004e81.js","./Info-954040b2.js","./Index-8bd4bdf3.css"]:void 0,import.meta.url)
			},
"paramviewer": {
			example: () => __vitePreload(() => import('./Example-2fbf541e.js'),true?["./Example-2fbf541e.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-5a196341.js'),true?["./Index-5a196341.js","./prism-python-b759ea26.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Index-3d3f41bf.css"]:void 0,import.meta.url)
			},
"plot": {
			
			component: () => __vitePreload(() => import('./Index-9afbe4df.js'),true?["./Index-9afbe4df.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-cca92c6b.js","./Button-2a9911a9.css","./color-7ac2560d.js","./dsv-a37bb3db.js","./Empty-79b64d64.js","./BlockLabel-c880a272.js","./Index-31740b2a.css"]:void 0,import.meta.url)
			},
"radio": {
			example: () => __vitePreload(() => import('./Example-b79eee1b.js'),true?["./Example-b79eee1b.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-0d056a21.js'),true?["./Index-0d056a21.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockTitle-41004e81.js","./Info-954040b2.js","./Example-b79eee1b.js","./Example-55d94c71.css","./Index-f43ff834.css"]:void 0,import.meta.url)
			},
"row": {
			
			component: () => __vitePreload(() => import('./Index-7cbc3ec9.js'),true?["./Index-7cbc3ec9.js","./Index-815f98ca.css"]:void 0,import.meta.url)
			},
"slider": {
			example: () => __vitePreload(() => import('./Example-94402048.js'),true?["./Example-94402048.js","./Example-55d94c71.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-51e7edb0.js'),true?["./Index-51e7edb0.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockTitle-41004e81.js","./Info-954040b2.js","./Index-61d7d897.css"]:void 0,import.meta.url)
			},
"state": {
			
			component: () => __vitePreload(() => import('./Index-b2efa79d.js'),true?[]:void 0,import.meta.url)
			},
"statustracker": {
			
			component: () => __vitePreload(() => import('./index-00f84bc7.js'),true?["./index-00f84bc7.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-cca92c6b.js","./Button-2a9911a9.css"]:void 0,import.meta.url)
			},
"tabitem": {
			
			component: () => __vitePreload(() => import('./Index-af99ef52.js'),true?["./Index-af99ef52.js","./Tabs-8aabe004.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Tabs-e53cc473.css","./Index-24a33ce1.js","./Index-2abed479.css","./Index-f5395e19.css"]:void 0,import.meta.url)
			},
"tabs": {
			
			component: () => __vitePreload(() => import('./Index-e4820b2e.js'),true?["./Index-e4820b2e.js","./Tabs-8aabe004.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Tabs-e53cc473.css"]:void 0,import.meta.url)
			},
"textbox": {
			example: () => __vitePreload(() => import('./Example-e0df15d4.js'),true?["./Example-e0df15d4.js","./Example-e8628e88.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./Index-43d79214.js'),true?["./Index-43d79214.js","./Textbox-7b7b36c7.js","./Button-cca92c6b.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Button-2a9911a9.css","./BlockTitle-41004e81.js","./Info-954040b2.js","./Check-f7edb5d9.js","./Copy-a69620a8.js","./Textbox-4c6022f4.css","./Example-e0df15d4.js","./Example-e8628e88.css"]:void 0,import.meta.url)
			},
"uploadbutton": {
			
			component: () => __vitePreload(() => import('./Index-732f10a1.js'),true?["./Index-732f10a1.js","./index-ec890757.js","./index-87ad2184.css","./Button-cca92c6b.js","./Index-3b1865e7.js","./Index-eb210efd.css","./Button-2a9911a9.css","./Index-dc08ef34.css"]:void 0,import.meta.url)
			},
"video": {
			example: () => __vitePreload(() => import('./Example-3c7c1f2a.js'),true?["./Example-3c7c1f2a.js","./Video-31cd3cb8.js","./file-url-fbb30a3f.js","./Index-3b1865e7.js","./index-ec890757.js","./index-87ad2184.css","./Index-eb210efd.css","./Video-540eb7aa.css","./Example-3390cfd5.css"]:void 0,import.meta.url),

			component: () => __vitePreload(() => import('./index-28118113.js'),true?["./index-28118113.js","./ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js","./index-ec890757.js","./index-87ad2184.css","./Index-3b1865e7.js","./Index-eb210efd.css","./ModifyUpload-7979c5fd.css","./ModifyUpload-af686f29.js","./Button-cca92c6b.js","./Button-2a9911a9.css","./IconButton-246ba9e7.js","./Clear-9760deed.js","./DownloadLink-be3958db.js","./file-url-fbb30a3f.js","./Undo-6c110254.js","./BlockLabel-c880a272.js","./Video-3f84d9ec.js","./SelectSource-ada22a1a.js","./Upload-c5c1b405.js","./ImageUploader-d498cfc3.js","./utils-013c0d40.js","./Empty-79b64d64.js","./ShareButton-77ad7d11.js","./Image-6cbf81d1.js","./Image-21f57ab7.js","./Image-7b829b60.css","./DropdownArrow-e7cb3811.js","./ImageUploader-57e340a3.css","./Video-31cd3cb8.js","./Video-540eb7aa.css","./Trim-0317ad89.js","./Example-3c7c1f2a.js","./Example-3390cfd5.css","./UploadText-7dd08ed3.js","./index-bea7352a.css","./Example-e441efe6.css"]:void 0,import.meta.url)
			},

		};
		

// @ts-nocheck

const request_map = {};

function load_component({ api_url, name, id, variant }) {
	const comps = window.__GRADIO__CC__;

	const _component_map = {
		// eslint-disable-next-line no-undef
		...component_map,
		...(!comps ? {} : comps)
	};

	if (request_map[`${id}-${variant}`]) {
		return { component: request_map[`${id}-${variant}`], name };
	}
	try {
		if (!_component_map?.[id]?.[variant] && !_component_map?.[name]?.[variant])
			throw new Error();

		request_map[`${id}-${variant}`] = (
			_component_map?.[id]?.[variant] || // for dev mode custom components
			_component_map?.[name]?.[variant]
		)();

		return {
			name,
			component: request_map[`${id}-${variant}`]
		};
	} catch (e) {
		try {
			request_map[`${id}-${variant}`] = get_component_with_css(
				api_url,
				id,
				variant
			);

			return {
				name,
				component: request_map[`${id}-${variant}`]
			};
		} catch (e) {
			if (variant === "example") {
				request_map[`${id}-${variant}`] = __vitePreload(() => import('./Example-b742dabd.js'),true?["./Example-b742dabd.js","./Example-55d94c71.css"]:void 0,import.meta.url);

				return {
					name,
					component: request_map[`${id}-${variant}`]
				};
			}
			console.error(`failed to load: ${name}`);
			console.error(e);
			throw e;
		}
	}
}

function load_css(url) {
	return new Promise((resolve, reject) => {
		const link = document.createElement("link");
		link.rel = "stylesheet";
		link.href = url;
		document.head.appendChild(link);
		link.onload = () => resolve();
		link.onerror = () => reject();
	});
}

function get_component_with_css(api_url, id, variant) {
	return Promise.all([
		load_css(`${api_url}/custom_component/${id}/${variant}/style.css`),
		__vitePreload(() => import(
			/* @vite-ignore */ `${api_url}/custom_component/${id}/${variant}/index.js`
		),true?[]:void 0,import.meta.url)
	]).then(([_, module]) => {
		return module;
	});
}

function create_loading_status_store() {
  const store = writable({});
  const fn_inputs = [];
  const fn_outputs = [];
  const pending_outputs = /* @__PURE__ */ new Map();
  const pending_inputs = /* @__PURE__ */ new Map();
  const inputs_to_update = /* @__PURE__ */ new Map();
  const fn_status = [];
  function update({
    fn_index,
    status,
    queue = true,
    size,
    position = null,
    eta = null,
    message = null,
    progress
  }) {
    const outputs = fn_outputs[fn_index];
    const inputs = fn_inputs[fn_index];
    const last_status = fn_status[fn_index];
    const outputs_to_update = outputs.map((id) => {
      let new_status;
      const pending_count = pending_outputs.get(id) || 0;
      if (last_status === "pending" && status !== "pending") {
        let new_count = pending_count - 1;
        pending_outputs.set(id, new_count < 0 ? 0 : new_count);
        new_status = new_count > 0 ? "pending" : status;
      } else if (last_status === "pending" && status === "pending") {
        new_status = "pending";
      } else if (last_status !== "pending" && status === "pending") {
        new_status = "pending";
        pending_outputs.set(id, pending_count + 1);
      } else {
        new_status = status;
      }
      return {
        id,
        queue_position: position,
        queue_size: size,
        eta,
        status: new_status,
        message,
        progress
      };
    });
    inputs.forEach((id) => {
      const pending_count = pending_inputs.get(id) || 0;
      if (last_status === "pending" && status !== "pending") {
        let new_count = pending_count - 1;
        pending_inputs.set(id, new_count < 0 ? 0 : new_count);
        inputs_to_update.set(id, status);
      } else if (last_status !== "pending" && status === "pending") {
        pending_inputs.set(id, pending_count + 1);
        inputs_to_update.set(id, status);
      } else {
        inputs_to_update.delete(id);
      }
    });
    store.update((outputs2) => {
      outputs_to_update.forEach(
        ({
          id,
          queue_position,
          queue_size,
          eta: eta2,
          status: status2,
          message: message2,
          progress: progress2
        }) => {
          outputs2[id] = {
            queue,
            queue_size,
            queue_position,
            eta: eta2,
            message: message2,
            progress: progress2,
            status: status2,
            fn_index
          };
        }
      );
      return outputs2;
    });
    fn_status[fn_index] = status;
  }
  function register(index, inputs, outputs) {
    fn_inputs[index] = inputs;
    fn_outputs[index] = outputs;
  }
  return {
    update,
    register,
    subscribe: store.subscribe,
    get_status_for_fn(i) {
      return fn_status[i];
    },
    get_inputs_to_update() {
      return inputs_to_update;
    }
  };
}

let pending_updates = [];
function create_components() {
  let _component_map;
  let target_map = writable({});
  let _target_map = {};
  let inputs;
  let outputs;
  let constructor_map;
  let instance_map;
  let loading_status = create_loading_status_store();
  const layout_store = writable();
  let root;
  let _components;
  let app;
  function create_layout({
    app: _app,
    components,
    layout,
    dependencies,
    root: root2,
    options
  }) {
    app = _app;
    _components = components;
    inputs = /* @__PURE__ */ new Set();
    outputs = /* @__PURE__ */ new Set();
    pending_updates = [];
    constructor_map = /* @__PURE__ */ new Map();
    _component_map = /* @__PURE__ */ new Map();
    instance_map = {};
    const _rootNode = {
      id: layout.id,
      type: "column",
      props: { interactive: false, scale: options.fill_height ? 1 : null },
      has_modes: false,
      instance: null,
      component: null,
      component_class_id: ""
    };
    components.push(_rootNode);
    dependencies.forEach((dep, fn_index) => {
      loading_status.register(fn_index, dep.inputs, dep.outputs);
      dep.frontend_fn = process_frontend_fn(
        dep.js,
        !!dep.backend_fn,
        dep.inputs.length,
        dep.outputs.length
      );
      create_target_meta(dep.targets, fn_index, _target_map);
      get_inputs_outputs(dep, inputs, outputs);
    });
    target_map.set(_target_map);
    constructor_map = preload_all_components(components, root2);
    instance_map = components.reduce(
      (acc, c) => {
        acc[c.id] = c;
        return acc;
      },
      {}
    );
    walk_layout(layout).then(() => {
      layout_store.set(_rootNode);
    });
  }
  async function walk_layout(node) {
    const instance = instance_map[node.id];
    instance.component = (await constructor_map.get(
      instance.component_class_id
    ))?.default;
    if (instance.type === "dataset") {
      instance.props.component_map = get_component(
        instance.type,
        instance.component_class_id,
        root,
        _components,
        instance.props.components
      ).example_components;
    }
    if (_target_map[instance.id]) {
      instance.props.attached_events = Object.keys(_target_map[instance.id]);
    }
    instance.props.interactive = determine_interactivity(
      instance.id,
      instance.props.interactive,
      instance.props.value,
      inputs,
      outputs
    );
    instance.props.server = process_server_fn(
      instance.id,
      instance.props.server_fns,
      app
    );
    _component_map.set(instance.id, instance);
    if (node.children) {
      instance.children = await Promise.all(
        node.children.map((v) => walk_layout(v))
      );
    }
    return instance;
  }
  let update_scheduled = false;
  let update_scheduled_store = writable(false);
  function flush() {
    layout_store.update((layout) => {
      for (let i = 0; i < pending_updates.length; i++) {
        for (let j = 0; j < pending_updates[i].length; j++) {
          const update = pending_updates[i][j];
          const instance = instance_map[update.id];
          if (!instance)
            continue;
          let new_value;
          if (Array.isArray(update.value))
            new_value = [...update.value];
          else if (update.value === null)
            new_value = null;
          else if (typeof update.value === "object")
            new_value = { ...update.value };
          else
            new_value = update.value;
          instance.props[update.prop] = new_value;
        }
      }
      return layout;
    });
    pending_updates = [];
    update_scheduled = false;
    update_scheduled_store.set(false);
  }
  function update_value(updates) {
    pending_updates.push(updates);
    if (!update_scheduled) {
      update_scheduled = true;
      update_scheduled_store.set(true);
      requestAnimationFrame(flush);
    }
  }
  function get_data(id) {
    const comp = _component_map.get(id);
    if (!comp) {
      return null;
    }
    if (comp.instance.get_value) {
      return comp.instance.get_value();
    }
    return comp.props.value;
  }
  return {
    layout: layout_store,
    targets: target_map,
    update_value,
    get_data,
    loading_status,
    scheduled_updates: update_scheduled_store,
    create_layout: (...args) => requestAnimationFrame(() => create_layout(...args))
  };
}
const AsyncFunction = Object.getPrototypeOf(
  async function() {
  }
).constructor;
function process_frontend_fn(source, backend_fn, input_length, output_length) {
  if (!source)
    return null;
  const wrap = backend_fn ? input_length === 1 : output_length === 1;
  try {
    return new AsyncFunction(
      "__fn_args",
      `  let result = await (${source})(...__fn_args);
  return (${wrap} && !Array.isArray(result)) ? [result] : result;`
    );
  } catch (e) {
    console.error("Could not parse custom js method.");
    console.error(e);
    return null;
  }
}
function create_target_meta(targets, fn_index, target_map) {
  targets.forEach(([id, trigger]) => {
    if (!target_map[id]) {
      target_map[id] = {};
    }
    if (target_map[id]?.[trigger] && !target_map[id]?.[trigger].includes(fn_index)) {
      target_map[id][trigger].push(fn_index);
    } else {
      target_map[id][trigger] = [fn_index];
    }
  });
  return target_map;
}
function get_inputs_outputs(dep, inputs, outputs) {
  dep.inputs.forEach((input) => inputs.add(input));
  dep.outputs.forEach((output) => outputs.add(output));
  return [inputs, outputs];
}
function has_no_default_value(value) {
  return Array.isArray(value) && value.length === 0 || value === "" || value === 0 || !value;
}
function determine_interactivity(id, interactive_prop, value, inputs, outputs) {
  if (interactive_prop === false) {
    return false;
  } else if (interactive_prop === true) {
    return true;
  } else if (inputs.has(id) || !outputs.has(id) && has_no_default_value(value)) {
    return true;
  }
  return false;
}
function process_server_fn(id, server_fns, app) {
  if (!server_fns) {
    return {};
  }
  return server_fns.reduce((acc, fn) => {
    acc[fn] = async (...args) => {
      if (args.length === 1) {
        args = args[0];
      }
      const result = await app.component_server(id, fn, args);
      return result;
    };
    return acc;
  }, {});
}
function get_component(type, class_id, root, components, example_components) {
  let example_component_map = /* @__PURE__ */ new Map();
  if (type === "dataset" && example_components) {
    example_components.forEach((name) => {
      if (example_component_map.has(name)) {
        return;
      }
      let _c2;
      const matching_component = components.find((c) => c.type === name);
      if (matching_component) {
        _c2 = load_component({
          api_url: root,
          name,
          id: matching_component.component_class_id,
          variant: "example"
        });
        example_component_map.set(name, _c2.component);
      }
    });
  }
  const _c = load_component({
    api_url: root,
    name: type,
    id: class_id,
    variant: "component"
  });
  return {
    component: _c.component,
    name: _c.name,
    example_components: example_component_map.size > 0 ? example_component_map : void 0
  };
}
function preload_all_components(components, root) {
  let constructor_map = /* @__PURE__ */ new Map();
  components.forEach((c) => {
    const { component, example_components } = get_component(
      c.type,
      c.component_class_id,
      root,
      components
    );
    constructor_map.set(c.component_class_id, component);
    if (example_components) {
      for (const [name, example_component] of example_components) {
        constructor_map.set(name, example_component);
      }
    }
  });
  return constructor_map;
}

const Blocks_svelte_svelte_type_style_lang = '';

/* src/Blocks.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent,
	append,
	attr,
	check_outros,
	component_subscribe,
	create_component,
	destroy_component,
	detach,
	element,
	empty,
	globals,
	group_outros,
	init,
	insert,
	listen,
	mount_component,
	noop,
	safe_not_equal,
	set_data,
	set_style,
	space,
	src_url_equal,
	text,
	transition_in,
	transition_out
} = window.__gradio__svelte__internal;
const { document: document_1 } = globals;
const { tick } = window.__gradio__svelte__internal;
function create_if_block_6(ctx) {
	document_1.title = /*title*/ ctx[2];
	return { c: noop, m: noop, d: noop };
}

// (383:1) {#if analytics_enabled}
function create_if_block_5(ctx) {
	let script0;
	let script0_src_value;
	let t0;
	let script1;

	return {
		c() {
			script0 = element("script");
			script0.innerHTML = ``;
			t0 = space();
			script1 = element("script");
			script1.textContent = "window.dataLayer = window.dataLayer || [];\n\t\t\tfunction gtag() {\n\t\t\t\tdataLayer.push(arguments);\n\t\t\t}\n\t\t\tgtag(\"js\", new Date());\n\t\t\tgtag(\"config\", \"UA-156449732-1\", {\n\t\t\t\tcookie_flags: \"samesite=none;secure\"\n\t\t\t});";
			script0.async = true;
			script0.defer = true;
			if (!src_url_equal(script0.src, script0_src_value = "https://www.googletagmanager.com/gtag/js?id=UA-156449732-1")) attr(script0, "src", script0_src_value);
		},
		m(target, anchor) {
			insert(target, script0, anchor);
			insert(target, t0, anchor);
			insert(target, script1, anchor);
		},
		d(detaching) {
			if (detaching) {
				detach(script0);
				detach(t0);
				detach(script1);
			}
		}
	};
}

// (404:2) {#if $_layout}
function create_if_block_4(ctx) {
	let mountcomponents;
	let current;

	mountcomponents = new MountComponents({
			props: {
				rootNode: /*$_layout*/ ctx[14],
				root: /*root*/ ctx[0],
				target: /*target*/ ctx[4],
				theme_mode: /*theme_mode*/ ctx[10],
				version: /*version*/ ctx[13],
				autoscroll: /*autoscroll*/ ctx[5]
			}
		});

	mountcomponents.$on("mount", /*handle_mount*/ ctx[24]);
	mountcomponents.$on("destroy", /*destroy_handler*/ ctx[33]);

	return {
		c() {
			create_component(mountcomponents.$$.fragment);
		},
		m(target, anchor) {
			mount_component(mountcomponents, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const mountcomponents_changes = {};
			if (dirty[0] & /*$_layout*/ 16384) mountcomponents_changes.rootNode = /*$_layout*/ ctx[14];
			if (dirty[0] & /*root*/ 1) mountcomponents_changes.root = /*root*/ ctx[0];
			if (dirty[0] & /*target*/ 16) mountcomponents_changes.target = /*target*/ ctx[4];
			if (dirty[0] & /*theme_mode*/ 1024) mountcomponents_changes.theme_mode = /*theme_mode*/ ctx[10];
			if (dirty[0] & /*version*/ 8192) mountcomponents_changes.version = /*version*/ ctx[13];
			if (dirty[0] & /*autoscroll*/ 32) mountcomponents_changes.autoscroll = /*autoscroll*/ ctx[5];
			mountcomponents.$set(mountcomponents_changes);
		},
		i(local) {
			if (current) return;
			transition_in(mountcomponents.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(mountcomponents.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(mountcomponents, detaching);
		}
	};
}

// (418:1) {#if show_footer}
function create_if_block_2(ctx) {
	let footer;
	let t0;
	let a;
	let t1_value = /*$_*/ ctx[17]("common.built_with_gradio") + "";
	let t1;
	let t2;
	let img;
	let img_src_value;
	let img_alt_value;
	let if_block = /*show_api*/ ctx[6] && create_if_block_3(ctx);

	return {
		c() {
			footer = element("footer");
			if (if_block) if_block.c();
			t0 = space();
			a = element("a");
			t1 = text(t1_value);
			t2 = space();
			img = element("img");
			if (!src_url_equal(img.src, img_src_value = logo)) attr(img, "src", img_src_value);
			attr(img, "alt", img_alt_value = /*$_*/ ctx[17]("common.logo"));
			attr(img, "class", "svelte-16bt5n8");
			attr(a, "href", "https://gradio.app");
			attr(a, "class", "built-with svelte-16bt5n8");
			attr(a, "target", "_blank");
			attr(a, "rel", "noreferrer");
			attr(footer, "class", "svelte-16bt5n8");
		},
		m(target, anchor) {
			insert(target, footer, anchor);
			if (if_block) if_block.m(footer, null);
			append(footer, t0);
			append(footer, a);
			append(a, t1);
			append(a, t2);
			append(a, img);
		},
		p(ctx, dirty) {
			if (/*show_api*/ ctx[6]) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block_3(ctx);
					if_block.c();
					if_block.m(footer, t0);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}

			if (dirty[0] & /*$_*/ 131072 && t1_value !== (t1_value = /*$_*/ ctx[17]("common.built_with_gradio") + "")) set_data(t1, t1_value);

			if (dirty[0] & /*$_*/ 131072 && img_alt_value !== (img_alt_value = /*$_*/ ctx[17]("common.logo"))) {
				attr(img, "alt", img_alt_value);
			}
		},
		d(detaching) {
			if (detaching) {
				detach(footer);
			}

			if (if_block) if_block.d();
		}
	};
}

// (420:3) {#if show_api}
function create_if_block_3(ctx) {
	let button;
	let t0_value = /*$_*/ ctx[17]("errors.use_via_api") + "";
	let t0;
	let t1;
	let img;
	let img_src_value;
	let img_alt_value;
	let t2;
	let div;
	let mounted;
	let dispose;

	return {
		c() {
			button = element("button");
			t0 = text(t0_value);
			t1 = space();
			img = element("img");
			t2 = space();
			div = element("div");
			div.textContent = "·";
			if (!src_url_equal(img.src, img_src_value = api_logo)) attr(img, "src", img_src_value);
			attr(img, "alt", img_alt_value = /*$_*/ ctx[17]("common.logo"));
			attr(img, "class", "svelte-16bt5n8");
			attr(button, "class", "show-api svelte-16bt5n8");
			attr(div, "class", "svelte-16bt5n8");
		},
		m(target, anchor) {
			insert(target, button, anchor);
			append(button, t0);
			append(button, t1);
			append(button, img);
			insert(target, t2, anchor);
			insert(target, div, anchor);

			if (!mounted) {
				dispose = listen(button, "click", /*click_handler*/ ctx[34]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty[0] & /*$_*/ 131072 && t0_value !== (t0_value = /*$_*/ ctx[17]("errors.use_via_api") + "")) set_data(t0, t0_value);

			if (dirty[0] & /*$_*/ 131072 && img_alt_value !== (img_alt_value = /*$_*/ ctx[17]("common.logo"))) {
				attr(img, "alt", img_alt_value);
			}
		},
		d(detaching) {
			if (detaching) {
				detach(button);
				detach(t2);
				detach(div);
			}

			mounted = false;
			dispose();
		}
	};
}

// (445:0) {#if api_docs_visible && $_layout}
function create_if_block_1(ctx) {
	let div2;
	let div0;
	let t;
	let div1;
	let apidocs;
	let current;
	let mounted;
	let dispose;

	apidocs = new ApiDocs({
			props: {
				root_node: /*$_layout*/ ctx[14],
				dependencies: /*dependencies*/ ctx[1],
				root: /*root*/ ctx[0],
				app: /*app*/ ctx[11],
				space_id: /*space_id*/ ctx[12]
			}
		});

	apidocs.$on("close", /*close_handler*/ ctx[36]);

	return {
		c() {
			div2 = element("div");
			div0 = element("div");
			t = space();
			div1 = element("div");
			create_component(apidocs.$$.fragment);
			attr(div0, "class", "backdrop svelte-16bt5n8");
			attr(div1, "class", "api-docs-wrap svelte-16bt5n8");
			attr(div2, "class", "api-docs svelte-16bt5n8");
		},
		m(target, anchor) {
			insert(target, div2, anchor);
			append(div2, div0);
			append(div2, t);
			append(div2, div1);
			mount_component(apidocs, div1, null);
			current = true;

			if (!mounted) {
				dispose = listen(div0, "click", /*click_handler_1*/ ctx[35]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			const apidocs_changes = {};
			if (dirty[0] & /*$_layout*/ 16384) apidocs_changes.root_node = /*$_layout*/ ctx[14];
			if (dirty[0] & /*dependencies*/ 2) apidocs_changes.dependencies = /*dependencies*/ ctx[1];
			if (dirty[0] & /*root*/ 1) apidocs_changes.root = /*root*/ ctx[0];
			if (dirty[0] & /*app*/ 2048) apidocs_changes.app = /*app*/ ctx[11];
			if (dirty[0] & /*space_id*/ 4096) apidocs_changes.space_id = /*space_id*/ ctx[12];
			apidocs.$set(apidocs_changes);
		},
		i(local) {
			if (current) return;
			transition_in(apidocs.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(apidocs.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div2);
			}

			destroy_component(apidocs);
			mounted = false;
			dispose();
		}
	};
}

// (471:0) {#if messages}
function create_if_block(ctx) {
	let toast;
	let current;

	toast = new Toast({
			props: { messages: /*messages*/ ctx[16] }
		});

	toast.$on("close", /*handle_error_close*/ ctx[23]);

	return {
		c() {
			create_component(toast.$$.fragment);
		},
		m(target, anchor) {
			mount_component(toast, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const toast_changes = {};
			if (dirty[0] & /*messages*/ 65536) toast_changes.messages = /*messages*/ ctx[16];
			toast.$set(toast_changes);
		},
		i(local) {
			if (current) return;
			transition_in(toast.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(toast.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(toast, detaching);
		}
	};
}

function create_fragment(ctx) {
	let if_block0_anchor;
	let if_block1_anchor;
	let t0;
	let div1;
	let div0;
	let t1;
	let t2;
	let t3;
	let if_block5_anchor;
	let current;
	let if_block0 = /*control_page_title*/ ctx[8] && create_if_block_6(ctx);
	let if_block1 = /*analytics_enabled*/ ctx[3] && create_if_block_5();
	let if_block2 = /*$_layout*/ ctx[14] && create_if_block_4(ctx);
	let if_block3 = /*show_footer*/ ctx[7] && create_if_block_2(ctx);
	let if_block4 = /*api_docs_visible*/ ctx[15] && /*$_layout*/ ctx[14] && create_if_block_1(ctx);
	let if_block5 = /*messages*/ ctx[16] && create_if_block(ctx);

	return {
		c() {
			if (if_block0) if_block0.c();
			if_block0_anchor = empty();
			if (if_block1) if_block1.c();
			if_block1_anchor = empty();
			t0 = space();
			div1 = element("div");
			div0 = element("div");
			if (if_block2) if_block2.c();
			t1 = space();
			if (if_block3) if_block3.c();
			t2 = space();
			if (if_block4) if_block4.c();
			t3 = space();
			if (if_block5) if_block5.c();
			if_block5_anchor = empty();
			attr(div0, "class", "contain svelte-16bt5n8");
			set_style(div0, "flex-grow", /*app_mode*/ ctx[9] ? "1" : "auto");
			attr(div1, "class", "wrap svelte-16bt5n8");
			set_style(div1, "min-height", /*app_mode*/ ctx[9] ? "100%" : "auto");
		},
		m(target, anchor) {
			if (if_block0) if_block0.m(document_1.head, null);
			append(document_1.head, if_block0_anchor);
			if (if_block1) if_block1.m(document_1.head, null);
			append(document_1.head, if_block1_anchor);
			insert(target, t0, anchor);
			insert(target, div1, anchor);
			append(div1, div0);
			if (if_block2) if_block2.m(div0, null);
			append(div1, t1);
			if (if_block3) if_block3.m(div1, null);
			insert(target, t2, anchor);
			if (if_block4) if_block4.m(target, anchor);
			insert(target, t3, anchor);
			if (if_block5) if_block5.m(target, anchor);
			insert(target, if_block5_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (/*control_page_title*/ ctx[8]) {
				if (if_block0) ; else {
					if_block0 = create_if_block_6(ctx);
					if_block0.c();
					if_block0.m(if_block0_anchor.parentNode, if_block0_anchor);
				}
			} else if (if_block0) {
				if_block0.d(1);
				if_block0 = null;
			}

			if (/*analytics_enabled*/ ctx[3]) {
				if (if_block1) ; else {
					if_block1 = create_if_block_5();
					if_block1.c();
					if_block1.m(if_block1_anchor.parentNode, if_block1_anchor);
				}
			} else if (if_block1) {
				if_block1.d(1);
				if_block1 = null;
			}

			if (/*$_layout*/ ctx[14]) {
				if (if_block2) {
					if_block2.p(ctx, dirty);

					if (dirty[0] & /*$_layout*/ 16384) {
						transition_in(if_block2, 1);
					}
				} else {
					if_block2 = create_if_block_4(ctx);
					if_block2.c();
					transition_in(if_block2, 1);
					if_block2.m(div0, null);
				}
			} else if (if_block2) {
				group_outros();

				transition_out(if_block2, 1, 1, () => {
					if_block2 = null;
				});

				check_outros();
			}

			if (dirty[0] & /*app_mode*/ 512) {
				set_style(div0, "flex-grow", /*app_mode*/ ctx[9] ? "1" : "auto");
			}

			if (/*show_footer*/ ctx[7]) {
				if (if_block3) {
					if_block3.p(ctx, dirty);
				} else {
					if_block3 = create_if_block_2(ctx);
					if_block3.c();
					if_block3.m(div1, null);
				}
			} else if (if_block3) {
				if_block3.d(1);
				if_block3 = null;
			}

			if (dirty[0] & /*app_mode*/ 512) {
				set_style(div1, "min-height", /*app_mode*/ ctx[9] ? "100%" : "auto");
			}

			if (/*api_docs_visible*/ ctx[15] && /*$_layout*/ ctx[14]) {
				if (if_block4) {
					if_block4.p(ctx, dirty);

					if (dirty[0] & /*api_docs_visible, $_layout*/ 49152) {
						transition_in(if_block4, 1);
					}
				} else {
					if_block4 = create_if_block_1(ctx);
					if_block4.c();
					transition_in(if_block4, 1);
					if_block4.m(t3.parentNode, t3);
				}
			} else if (if_block4) {
				group_outros();

				transition_out(if_block4, 1, 1, () => {
					if_block4 = null;
				});

				check_outros();
			}

			if (/*messages*/ ctx[16]) {
				if (if_block5) {
					if_block5.p(ctx, dirty);

					if (dirty[0] & /*messages*/ 65536) {
						transition_in(if_block5, 1);
					}
				} else {
					if_block5 = create_if_block(ctx);
					if_block5.c();
					transition_in(if_block5, 1);
					if_block5.m(if_block5_anchor.parentNode, if_block5_anchor);
				}
			} else if (if_block5) {
				group_outros();

				transition_out(if_block5, 1, 1, () => {
					if_block5 = null;
				});

				check_outros();
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block2);
			transition_in(if_block4);
			transition_in(if_block5);
			current = true;
		},
		o(local) {
			transition_out(if_block2);
			transition_out(if_block4);
			transition_out(if_block5);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(t0);
				detach(div1);
				detach(t2);
				detach(t3);
				detach(if_block5_anchor);
			}

			if (if_block0) if_block0.d(detaching);
			detach(if_block0_anchor);
			if (if_block1) if_block1.d(detaching);
			detach(if_block1_anchor);
			if (if_block2) if_block2.d();
			if (if_block3) if_block3.d();
			if (if_block4) if_block4.d(detaching);
			if (if_block5) if_block5.d(detaching);
		}
	};
}

const MESSAGE_QUOTE_RE = /^'([^]+)'$/;
const SHOW_DUPLICATE_MESSAGE_ON_ETA = 15;
const SHOW_MOBILE_QUEUE_WARNING_ON_ETA = 10;

function isCustomEvent(event) {
	return "detail" in event;
}

function instance($$self, $$props, $$invalidate) {
	let $loading_status;
	let $targets;
	let $scheduled_updates;
	let $_;
	let $_layout;
	component_subscribe($$self, $format, $$value => $$invalidate(17, $_ = $$value));
	setupi18n();
	let { root } = $$props;
	let { components } = $$props;
	let { layout } = $$props;
	let { dependencies } = $$props;
	let { title = "Gradio" } = $$props;
	let { analytics_enabled = false } = $$props;
	let { target } = $$props;
	let { autoscroll } = $$props;
	let { show_api = true } = $$props;
	let { show_footer = true } = $$props;
	let { control_page_title = false } = $$props;
	let { app_mode } = $$props;
	let { theme_mode } = $$props;
	let { app } = $$props;
	let { space_id } = $$props;
	let { version } = $$props;
	let { js } = $$props;
	let { fill_height = false } = $$props;
	let { ready } = $$props;
	const { layout: _layout, targets, update_value, get_data, loading_status, scheduled_updates, create_layout } = create_components();
	component_subscribe($$self, _layout, value => $$invalidate(14, $_layout = value));
	component_subscribe($$self, targets, value => $$invalidate(42, $targets = value));
	component_subscribe($$self, loading_status, value => $$invalidate(32, $loading_status = value));
	component_subscribe($$self, scheduled_updates, value => $$invalidate(43, $scheduled_updates = value));
	let params = new URLSearchParams(window.location.search);
	let api_docs_visible = params.get("view") === "api" && show_api;

	function set_api_docs_visible(visible) {
		$$invalidate(15, api_docs_visible = visible);
		let params = new URLSearchParams(window.location.search);

		if (visible) {
			params.set("view", "api");
		} else {
			params.delete("view");
		}

		history.replaceState(null, "", "?" + params.toString());
	}

	let { render_complete = false } = $$props;

	async function handle_update(data, fn_index) {
		const outputs = dependencies[fn_index].outputs;

		const meta_updates = data?.map((value, i) => {
			return {
				id: outputs[i],
				prop: "value_is_output",
				value: true
			};
		});

		update_value(meta_updates);
		await tick();
		const updates = [];

		data?.forEach((value, i) => {
			if (typeof value === "object" && value !== null && value.__type__ === "update") {
				for (const [update_key, update_value] of Object.entries(value)) {
					if (update_key === "__type__") {
						continue;
					} else {
						updates.push({
							id: outputs[i],
							prop: update_key,
							value: update_value
						});
					}
				}
			} else {
				updates.push({ id: outputs[i], prop: "value", value });
			}
		});

		update_value(updates);
		await tick();
	}

	let submit_map = new Map();
	let handled_dependencies = [];
	let messages = [];

	function new_message(message, fn_index, type) {
		return { message, fn_index, type, id: ++_error_id };
	}

	let _error_id = -1;
	let user_left_page = false;

	document.addEventListener("visibilitychange", function () {
		if (document.visibilityState === "hidden") {
			user_left_page = true;
		}
	});

	const DUPLICATE_MESSAGE = $_("blocks.long_requests_queue");
	const MOBILE_QUEUE_WARNING = $_("blocks.connection_can_break");
	const MOBILE_RECONNECT_MESSAGE = $_("blocks.lost_connection");
	const is_mobile_device = (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i).test(navigator.userAgent);
	let showed_duplicate_message = false;
	let showed_mobile_warning = false;

	// as state updates are not synchronous, we need to ensure updates are flushed before triggering any requests
	function wait_then_trigger_api_call(dep_index, trigger_id = null, event_data = null) {
		let _unsub = () => {
			
		};

		function unsub() {
			_unsub();
		}

		if ($scheduled_updates) {
			_unsub = scheduled_updates.subscribe(updating => {
				if (!updating) {
					trigger_api_call(dep_index, trigger_id, event_data);
					unsub();
				}
			});
		} else {
			trigger_api_call(dep_index, trigger_id, event_data);
		}
	}

	async function trigger_api_call(dep_index, trigger_id = null, event_data = null) {
		let dep = dependencies[dep_index];
		const current_status = loading_status.get_status_for_fn(dep_index);
		$$invalidate(16, messages = messages.filter(({ fn_index }) => fn_index !== dep_index));

		if (dep.cancels) {
			await Promise.all(dep.cancels.map(async fn_index => {
				const submission = submit_map.get(fn_index);
				submission?.cancel();
				return submission;
			}));
		}

		if (current_status === "pending" || current_status === "generating") {
			dep.pending_request = true;
		}

		let payload = {
			fn_index: dep_index,
			data: await Promise.all(dep.inputs.map(id => get_data(id))),
			event_data: dep.collects_event_data ? event_data : null,
			trigger_id
		};

		if (dep.frontend_fn) {
			dep.frontend_fn(payload.data.concat(await Promise.all(dep.inputs.map(id => get_data(id))))).then(v => {
				if (dep.backend_fn) {
					payload.data = v;
					make_prediction(payload);
				} else {
					handle_update(v, dep_index);
				}
			});
		} else {
			if (dep.backend_fn) {
				if (dep.trigger_mode === "once") {
					if (!dep.pending_request) make_prediction(payload);
				} else if (dep.trigger_mode === "multiple") {
					make_prediction(payload);
				} else if (dep.trigger_mode === "always_last") {
					if (!dep.pending_request) {
						make_prediction(payload);
					} else {
						dep.final_event = payload;
					}
				}
			}
		}

		async function make_prediction(payload) {
			const submission = app.submit(payload.fn_index, payload.data, payload.event_data, payload.trigger_id).on("data", ({ data, fn_index }) => {
				if (dep.pending_request && dep.final_event) {
					dep.pending_request = false;
					make_prediction(dep.final_event);
				}

				dep.pending_request = false;
				handle_update(data, fn_index);
				set_status($loading_status);
			}).on("status", ({ fn_index, ...status }) => {
				//@ts-ignore
				loading_status.update({
					...status,
					status: status.stage,
					progress: status.progress_data,
					fn_index
				});

				set_status($loading_status);

				if (!showed_duplicate_message && space_id !== null && status.position !== undefined && status.position >= 2 && status.eta !== undefined && status.eta > SHOW_DUPLICATE_MESSAGE_ON_ETA) {
					showed_duplicate_message = true;
					$$invalidate(16, messages = [new_message(DUPLICATE_MESSAGE, fn_index, "warning"), ...messages]);
				}

				if (!showed_mobile_warning && is_mobile_device && status.eta !== undefined && status.eta > SHOW_MOBILE_QUEUE_WARNING_ON_ETA) {
					showed_mobile_warning = true;
					$$invalidate(16, messages = [new_message(MOBILE_QUEUE_WARNING, fn_index, "warning"), ...messages]);
				}

				if (status.stage === "complete") {
					dependencies.map(async (dep, i) => {
						if (dep.trigger_after === fn_index) {
							wait_then_trigger_api_call(i, payload.trigger_id);
						}
					});

					submission.destroy();
				}

				if (status.broken && is_mobile_device && user_left_page) {
					window.setTimeout(
						() => {
							$$invalidate(16, messages = [
								new_message(MOBILE_RECONNECT_MESSAGE, fn_index, "error"),
								...messages
							]);
						},
						0
					);

					wait_then_trigger_api_call(dep_index, payload.trigger_id, event_data);
					user_left_page = false;
				} else if (status.stage === "error") {
					if (status.message) {
						const _message = status.message.replace(MESSAGE_QUOTE_RE, (_, b) => b);
						$$invalidate(16, messages = [new_message(_message, fn_index, "error"), ...messages]);
					}

					dependencies.map(async (dep, i) => {
						if (dep.trigger_after === fn_index && !dep.trigger_only_on_success) {
							wait_then_trigger_api_call(i, payload.trigger_id);
						}
					});

					submission.destroy();
				}
			}).on("log", ({ log, fn_index, level }) => {
				$$invalidate(16, messages = [new_message(log, fn_index, level), ...messages]);
			});

			submit_map.set(dep_index, submission);
		}
	}

	function trigger_share(title, description) {
		if (space_id === null) {
			return;
		}

		const discussion_url = new URL(`https://huggingface.co/spaces/${space_id}/discussions/new`);

		if (title !== undefined && title.length > 0) {
			discussion_url.searchParams.set("title", title);
		}

		discussion_url.searchParams.set("description", description);
		window.open(discussion_url.toString(), "_blank");
	}

	function handle_error_close(e) {
		const _id = e.detail;
		$$invalidate(16, messages = messages.filter(m => m.id !== _id));
	}

	const is_external_url = link => !!(link && new URL(link, location.href).origin !== location.origin);

	async function handle_mount() {
		if (js) {
			let blocks_frontend_fn = new AsyncFunction(`let result = await (${js})();
					return (!Array.isArray(result)) ? [result] : result;`);

			await blocks_frontend_fn();
		}

		await tick();
		var a = target.getElementsByTagName("a");

		for (var i = 0; i < a.length; i++) {
			const _target = a[i].getAttribute("target");
			const _link = a[i].getAttribute("href");

			// only target anchor tags with external links
			if (is_external_url(_link) && _target !== "_blank") a[i].setAttribute("target", "_blank");
		}

		// handle load triggers
		dependencies.forEach((dep, i) => {
			if (dep.targets[0][1] === "load") {
				wait_then_trigger_api_call(i);
			}
		});

		if (render_complete) return;

		target.addEventListener("prop_change", e => {
			if (!isCustomEvent(e)) throw new Error("not a custom event");
			const { id, prop, value } = e.detail;
			update_value([{ id, prop, value }]);
		});

		target.addEventListener("gradio", e => {
			if (!isCustomEvent(e)) throw new Error("not a custom event");
			const { id, event, data } = e.detail;

			if (event === "share") {
				const { title, description } = data;
				trigger_share(title, description);
			} else if (event === "error" || event === "warning") {
				$$invalidate(16, messages = [new_message(data, -1, event), ...messages]);
			} else {
				const deps = $targets[id]?.[event];

				deps?.forEach(dep_id => {
					requestAnimationFrame(() => {
						wait_then_trigger_api_call(dep_id, id, data);
					});
				});
			}
		});

		$$invalidate(27, render_complete = true);
	}

	function handle_destroy(id) {
		handled_dependencies = handled_dependencies.map(dep => {
			return dep.filter(_id => _id !== id);
		});
	}

	function set_status(statuses) {
		const updates = Object.entries(statuses).map(([id, loading_status]) => {
			let dependency = dependencies[loading_status.fn_index];
			loading_status.scroll_to_output = dependency.scroll_to_output;
			loading_status.show_progress = dependency.show_progress;

			return {
				id: parseInt(id),
				prop: "loading_status",
				value: loading_status
			};
		});

		const inputs_to_update = loading_status.get_inputs_to_update();

		const additional_updates = Array.from(inputs_to_update).map(([id, pending_status]) => {
			return {
				id,
				prop: "pending",
				value: pending_status === "pending"
			};
		});

		update_value([...updates, ...additional_updates]);
	}

	const destroy_handler = ({ detail }) => handle_destroy(detail);

	const click_handler = () => {
		set_api_docs_visible(!api_docs_visible);
	};

	const click_handler_1 = () => {
		set_api_docs_visible(false);
	};

	const close_handler = () => {
		set_api_docs_visible(false);
	};

	$$self.$$set = $$props => {
		if ('root' in $$props) $$invalidate(0, root = $$props.root);
		if ('components' in $$props) $$invalidate(28, components = $$props.components);
		if ('layout' in $$props) $$invalidate(29, layout = $$props.layout);
		if ('dependencies' in $$props) $$invalidate(1, dependencies = $$props.dependencies);
		if ('title' in $$props) $$invalidate(2, title = $$props.title);
		if ('analytics_enabled' in $$props) $$invalidate(3, analytics_enabled = $$props.analytics_enabled);
		if ('target' in $$props) $$invalidate(4, target = $$props.target);
		if ('autoscroll' in $$props) $$invalidate(5, autoscroll = $$props.autoscroll);
		if ('show_api' in $$props) $$invalidate(6, show_api = $$props.show_api);
		if ('show_footer' in $$props) $$invalidate(7, show_footer = $$props.show_footer);
		if ('control_page_title' in $$props) $$invalidate(8, control_page_title = $$props.control_page_title);
		if ('app_mode' in $$props) $$invalidate(9, app_mode = $$props.app_mode);
		if ('theme_mode' in $$props) $$invalidate(10, theme_mode = $$props.theme_mode);
		if ('app' in $$props) $$invalidate(11, app = $$props.app);
		if ('space_id' in $$props) $$invalidate(12, space_id = $$props.space_id);
		if ('version' in $$props) $$invalidate(13, version = $$props.version);
		if ('js' in $$props) $$invalidate(30, js = $$props.js);
		if ('fill_height' in $$props) $$invalidate(31, fill_height = $$props.fill_height);
		if ('ready' in $$props) $$invalidate(26, ready = $$props.ready);
		if ('render_complete' in $$props) $$invalidate(27, render_complete = $$props.render_complete);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*components, layout, dependencies, root, app*/ 805308419 | $$self.$$.dirty[1] & /*fill_height*/ 1) {
			create_layout({
				components,
				layout,
				dependencies,
				root,
				app,
				options: { fill_height }
			});
		}

		if ($$self.$$.dirty[0] & /*$_layout*/ 16384) {
			{
				$$invalidate(26, ready = !!$_layout);
			}
		}

		if ($$self.$$.dirty[1] & /*$loading_status*/ 2) {
			set_status($loading_status);
		}
	};

	return [
		root,
		dependencies,
		title,
		analytics_enabled,
		target,
		autoscroll,
		show_api,
		show_footer,
		control_page_title,
		app_mode,
		theme_mode,
		app,
		space_id,
		version,
		$_layout,
		api_docs_visible,
		messages,
		$_,
		_layout,
		targets,
		loading_status,
		scheduled_updates,
		set_api_docs_visible,
		handle_error_close,
		handle_mount,
		handle_destroy,
		ready,
		render_complete,
		components,
		layout,
		js,
		fill_height,
		$loading_status,
		destroy_handler,
		click_handler,
		click_handler_1,
		close_handler
	];
}

class Blocks extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance,
			create_fragment,
			safe_not_equal,
			{
				root: 0,
				components: 28,
				layout: 29,
				dependencies: 1,
				title: 2,
				analytics_enabled: 3,
				target: 4,
				autoscroll: 5,
				show_api: 6,
				show_footer: 7,
				control_page_title: 8,
				app_mode: 9,
				theme_mode: 10,
				app: 11,
				space_id: 12,
				version: 13,
				js: 30,
				fill_height: 31,
				ready: 26,
				render_complete: 27
			},
			null,
			[-1, -1]
		);
	}
}

const Blocks$1 = /*#__PURE__*/Object.freeze(/*#__PURE__*/Object.defineProperty({
	__proto__: null,
	default: Blocks
}, Symbol.toStringTag, { value: 'Module' }));

export { Blocks$1 as B, Toast as T };
//# sourceMappingURL=Blocks-a4fb2b06.js.map
