import { f as fade } from './Button-cca92c6b.js';
import { u as uploadToHuggingFace } from './utils-013c0d40.js';
import { B as BlockLabel } from './BlockLabel-c880a272.js';
import { I as IconButton } from './IconButton-246ba9e7.js';
import { E as Empty } from './Empty-79b64d64.js';
import { S as ShareButton } from './ShareButton-77ad7d11.js';
import { D as DownloadLink, a as Download } from './DownloadLink-be3958db.js';
import './Index-3b1865e7.js';
import { I as Image } from './Image-6cbf81d1.js';
import { I as Image$1 } from './Image-21f57ab7.js';
import { p as prepare_files, u as upload } from './index-ec890757.js';
import { W as Webcam$2, S as SelectSource } from './SelectSource-ada22a1a.js';
import { D as DropdownArrow } from './DropdownArrow-e7cb3811.js';
import { U as Upload } from './ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js';
import { C as Clear } from './Clear-9760deed.js';

/* home/runner/work/gradio/gradio/js/icons/src/Camera.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$7,
	append: append$6,
	attr: attr$7,
	detach: detach$7,
	init: init$7,
	insert: insert$7,
	noop: noop$6,
	safe_not_equal: safe_not_equal$7,
	svg_element: svg_element$2
} = window.__gradio__svelte__internal;
function create_fragment$7(ctx) {
	let svg;
	let path;
	let circle;

	return {
		c() {
			svg = svg_element$2("svg");
			path = svg_element$2("path");
			circle = svg_element$2("circle");
			attr$7(path, "d", "M23 19a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h4l2-3h6l2 3h4a2 2 0 0 1 2 2z");
			attr$7(circle, "cx", "12");
			attr$7(circle, "cy", "13");
			attr$7(circle, "r", "4");
			attr$7(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr$7(svg, "width", "100%");
			attr$7(svg, "height", "100%");
			attr$7(svg, "viewBox", "0 0 24 24");
			attr$7(svg, "fill", "none");
			attr$7(svg, "stroke", "currentColor");
			attr$7(svg, "stroke-width", "1.5");
			attr$7(svg, "stroke-linecap", "round");
			attr$7(svg, "stroke-linejoin", "round");
			attr$7(svg, "class", "feather feather-camera");
		},
		m(target, anchor) {
			insert$7(target, svg, anchor);
			append$6(svg, path);
			append$6(svg, circle);
		},
		p: noop$6,
		i: noop$6,
		o: noop$6,
		d(detaching) {
			if (detaching) {
				detach$7(svg);
			}
		}
	};
}

class Camera extends SvelteComponent$7 {
	constructor(options) {
		super();
		init$7(this, options, null, create_fragment$7, safe_not_equal$7, {});
	}
}

/* home/runner/work/gradio/gradio/js/icons/src/Circle.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$6,
	append: append$5,
	attr: attr$6,
	detach: detach$6,
	init: init$6,
	insert: insert$6,
	noop: noop$5,
	safe_not_equal: safe_not_equal$6,
	svg_element: svg_element$1
} = window.__gradio__svelte__internal;
function create_fragment$6(ctx) {
	let svg;
	let circle;

	return {
		c() {
			svg = svg_element$1("svg");
			circle = svg_element$1("circle");
			attr$6(circle, "cx", "12");
			attr$6(circle, "cy", "12");
			attr$6(circle, "r", "10");
			attr$6(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr$6(svg, "width", "100%");
			attr$6(svg, "height", "100%");
			attr$6(svg, "viewBox", "0 0 24 24");
			attr$6(svg, "stroke-width", "1.5");
			attr$6(svg, "stroke-linecap", "round");
			attr$6(svg, "stroke-linejoin", "round");
			attr$6(svg, "class", "feather feather-circle");
		},
		m(target, anchor) {
			insert$6(target, svg, anchor);
			append$5(svg, circle);
		},
		p: noop$5,
		i: noop$5,
		o: noop$5,
		d(detaching) {
			if (detaching) {
				detach$6(svg);
			}
		}
	};
}

class Circle extends SvelteComponent$6 {
	constructor(options) {
		super();
		init$6(this, options, null, create_fragment$6, safe_not_equal$6, {});
	}
}

/* home/runner/work/gradio/gradio/js/icons/src/Square.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$5,
	append: append$4,
	attr: attr$5,
	detach: detach$5,
	init: init$5,
	insert: insert$5,
	noop: noop$4,
	safe_not_equal: safe_not_equal$5,
	svg_element
} = window.__gradio__svelte__internal;
function create_fragment$5(ctx) {
	let svg;
	let rect;

	return {
		c() {
			svg = svg_element("svg");
			rect = svg_element("rect");
			attr$5(rect, "x", "3");
			attr$5(rect, "y", "3");
			attr$5(rect, "width", "18");
			attr$5(rect, "height", "18");
			attr$5(rect, "rx", "2");
			attr$5(rect, "ry", "2");
			attr$5(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr$5(svg, "width", "100%");
			attr$5(svg, "height", "100%");
			attr$5(svg, "viewBox", "0 0 24 24");
			attr$5(svg, "stroke-width", "1.5");
			attr$5(svg, "stroke-linecap", "round");
			attr$5(svg, "stroke-linejoin", "round");
			attr$5(svg, "class", "feather feather-square");
		},
		m(target, anchor) {
			insert$5(target, svg, anchor);
			append$4(svg, rect);
		},
		p: noop$4,
		i: noop$4,
		o: noop$4,
		d(detaching) {
			if (detaching) {
				detach$5(svg);
			}
		}
	};
}

class Square extends SvelteComponent$5 {
	constructor(options) {
		super();
		init$5(this, options, null, create_fragment$5, safe_not_equal$5, {});
	}
}

const get_coordinates_of_clicked_image = (evt) => {
  let image;
  if (evt.currentTarget instanceof Element) {
    image = evt.currentTarget.querySelector("img");
  } else {
    return [NaN, NaN];
  }
  const imageRect = image.getBoundingClientRect();
  const xScale = image.naturalWidth / imageRect.width;
  const yScale = image.naturalHeight / imageRect.height;
  if (xScale > yScale) {
    const displayed_height = image.naturalHeight / xScale;
    const y_offset = (imageRect.height - displayed_height) / 2;
    var x = Math.round((evt.clientX - imageRect.left) * xScale);
    var y = Math.round((evt.clientY - imageRect.top - y_offset) * xScale);
  } else {
    const displayed_width = image.naturalWidth / yScale;
    const x_offset = (imageRect.width - displayed_width) / 2;
    var x = Math.round((evt.clientX - imageRect.left - x_offset) * yScale);
    var y = Math.round((evt.clientY - imageRect.top) * yScale);
  }
  if (x < 0 || x >= image.naturalWidth || y < 0 || y >= image.naturalHeight) {
    return null;
  }
  return [x, y];
};

const ImagePreview_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/image/shared/ImagePreview.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$4,
	append: append$3,
	attr: attr$4,
	bubble: bubble$1,
	check_outros: check_outros$2,
	create_component: create_component$4,
	destroy_component: destroy_component$4,
	detach: detach$4,
	element: element$4,
	empty: empty$2,
	group_outros: group_outros$2,
	init: init$4,
	insert: insert$4,
	listen: listen$3,
	mount_component: mount_component$4,
	safe_not_equal: safe_not_equal$4,
	space: space$3,
	toggle_class: toggle_class$2,
	transition_in: transition_in$4,
	transition_out: transition_out$4
} = window.__gradio__svelte__internal;
const { createEventDispatcher: createEventDispatcher$4 } = window.__gradio__svelte__internal;
function create_else_block$1(ctx) {
	let div0;
	let t0;
	let t1;
	let button;
	let div1;
	let image;
	let current;
	let mounted;
	let dispose;
	let if_block0 = /*show_download_button*/ ctx[3] && create_if_block_2$2(ctx);
	let if_block1 = /*show_share_button*/ ctx[5] && create_if_block_1$2(ctx);

	image = new Image$1({
			props: {
				src: /*value*/ ctx[0].url,
				alt: "",
				loading: "lazy"
			}
		});

	return {
		c() {
			div0 = element$4("div");
			if (if_block0) if_block0.c();
			t0 = space$3();
			if (if_block1) if_block1.c();
			t1 = space$3();
			button = element$4("button");
			div1 = element$4("div");
			create_component$4(image.$$.fragment);
			attr$4(div0, "class", "icon-buttons svelte-1l6wqyv");
			attr$4(div1, "class", "image-container svelte-1l6wqyv");
			toggle_class$2(div1, "selectable", /*selectable*/ ctx[4]);
			attr$4(button, "class", "svelte-1l6wqyv");
		},
		m(target, anchor) {
			insert$4(target, div0, anchor);
			if (if_block0) if_block0.m(div0, null);
			append$3(div0, t0);
			if (if_block1) if_block1.m(div0, null);
			insert$4(target, t1, anchor);
			insert$4(target, button, anchor);
			append$3(button, div1);
			mount_component$4(image, div1, null);
			current = true;

			if (!mounted) {
				dispose = listen$3(button, "click", /*handle_click*/ ctx[7]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (/*show_download_button*/ ctx[3]) {
				if (if_block0) {
					if_block0.p(ctx, dirty);

					if (dirty & /*show_download_button*/ 8) {
						transition_in$4(if_block0, 1);
					}
				} else {
					if_block0 = create_if_block_2$2(ctx);
					if_block0.c();
					transition_in$4(if_block0, 1);
					if_block0.m(div0, t0);
				}
			} else if (if_block0) {
				group_outros$2();

				transition_out$4(if_block0, 1, 1, () => {
					if_block0 = null;
				});

				check_outros$2();
			}

			if (/*show_share_button*/ ctx[5]) {
				if (if_block1) {
					if_block1.p(ctx, dirty);

					if (dirty & /*show_share_button*/ 32) {
						transition_in$4(if_block1, 1);
					}
				} else {
					if_block1 = create_if_block_1$2(ctx);
					if_block1.c();
					transition_in$4(if_block1, 1);
					if_block1.m(div0, null);
				}
			} else if (if_block1) {
				group_outros$2();

				transition_out$4(if_block1, 1, 1, () => {
					if_block1 = null;
				});

				check_outros$2();
			}

			const image_changes = {};
			if (dirty & /*value*/ 1) image_changes.src = /*value*/ ctx[0].url;
			image.$set(image_changes);

			if (!current || dirty & /*selectable*/ 16) {
				toggle_class$2(div1, "selectable", /*selectable*/ ctx[4]);
			}
		},
		i(local) {
			if (current) return;
			transition_in$4(if_block0);
			transition_in$4(if_block1);
			transition_in$4(image.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$4(if_block0);
			transition_out$4(if_block1);
			transition_out$4(image.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$4(div0);
				detach$4(t1);
				detach$4(button);
			}

			if (if_block0) if_block0.d();
			if (if_block1) if_block1.d();
			destroy_component$4(image);
			mounted = false;
			dispose();
		}
	};
}

// (31:0) {#if value === null || !value.url}
function create_if_block$2(ctx) {
	let empty_1;
	let current;

	empty_1 = new Empty({
			props: {
				unpadded_box: true,
				size: "large",
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component$4(empty_1.$$.fragment);
		},
		m(target, anchor) {
			mount_component$4(empty_1, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const empty_1_changes = {};

			if (dirty & /*$$scope*/ 4096) {
				empty_1_changes.$$scope = { dirty, ctx };
			}

			empty_1.$set(empty_1_changes);
		},
		i(local) {
			if (current) return;
			transition_in$4(empty_1.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$4(empty_1.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$4(empty_1, detaching);
		}
	};
}

// (35:2) {#if show_download_button}
function create_if_block_2$2(ctx) {
	let downloadlink;
	let current;

	downloadlink = new DownloadLink({
			props: {
				href: /*value*/ ctx[0].url,
				download: /*value*/ ctx[0].orig_name || "image",
				$$slots: { default: [create_default_slot_1] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component$4(downloadlink.$$.fragment);
		},
		m(target, anchor) {
			mount_component$4(downloadlink, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const downloadlink_changes = {};
			if (dirty & /*value*/ 1) downloadlink_changes.href = /*value*/ ctx[0].url;
			if (dirty & /*value*/ 1) downloadlink_changes.download = /*value*/ ctx[0].orig_name || "image";

			if (dirty & /*$$scope, i18n*/ 4160) {
				downloadlink_changes.$$scope = { dirty, ctx };
			}

			downloadlink.$set(downloadlink_changes);
		},
		i(local) {
			if (current) return;
			transition_in$4(downloadlink.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$4(downloadlink.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$4(downloadlink, detaching);
		}
	};
}

// (36:3) <DownloadLink href={value.url} download={value.orig_name || "image"}>
function create_default_slot_1(ctx) {
	let iconbutton;
	let current;

	iconbutton = new IconButton({
			props: {
				Icon: Download,
				label: /*i18n*/ ctx[6]("common.download")
			}
		});

	return {
		c() {
			create_component$4(iconbutton.$$.fragment);
		},
		m(target, anchor) {
			mount_component$4(iconbutton, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const iconbutton_changes = {};
			if (dirty & /*i18n*/ 64) iconbutton_changes.label = /*i18n*/ ctx[6]("common.download");
			iconbutton.$set(iconbutton_changes);
		},
		i(local) {
			if (current) return;
			transition_in$4(iconbutton.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$4(iconbutton.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$4(iconbutton, detaching);
		}
	};
}

// (40:2) {#if show_share_button}
function create_if_block_1$2(ctx) {
	let sharebutton;
	let current;

	sharebutton = new ShareButton({
			props: {
				i18n: /*i18n*/ ctx[6],
				formatter: /*func*/ ctx[8],
				value: /*value*/ ctx[0]
			}
		});

	sharebutton.$on("share", /*share_handler*/ ctx[9]);
	sharebutton.$on("error", /*error_handler*/ ctx[10]);

	return {
		c() {
			create_component$4(sharebutton.$$.fragment);
		},
		m(target, anchor) {
			mount_component$4(sharebutton, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const sharebutton_changes = {};
			if (dirty & /*i18n*/ 64) sharebutton_changes.i18n = /*i18n*/ ctx[6];
			if (dirty & /*value*/ 1) sharebutton_changes.value = /*value*/ ctx[0];
			sharebutton.$set(sharebutton_changes);
		},
		i(local) {
			if (current) return;
			transition_in$4(sharebutton.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$4(sharebutton.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$4(sharebutton, detaching);
		}
	};
}

// (32:1) <Empty unpadded_box={true} size="large">
function create_default_slot$1(ctx) {
	let imageicon;
	let current;
	imageicon = new Image({});

	return {
		c() {
			create_component$4(imageicon.$$.fragment);
		},
		m(target, anchor) {
			mount_component$4(imageicon, target, anchor);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in$4(imageicon.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$4(imageicon.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$4(imageicon, detaching);
		}
	};
}

function create_fragment$4(ctx) {
	let blocklabel;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[2],
				Icon: Image,
				label: /*label*/ ctx[1] || /*i18n*/ ctx[6]("image.image")
			}
		});

	const if_block_creators = [create_if_block$2, create_else_block$1];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*value*/ ctx[0] === null || !/*value*/ ctx[0].url) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component$4(blocklabel.$$.fragment);
			t = space$3();
			if_block.c();
			if_block_anchor = empty$2();
		},
		m(target, anchor) {
			mount_component$4(blocklabel, target, anchor);
			insert$4(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert$4(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const blocklabel_changes = {};
			if (dirty & /*show_label*/ 4) blocklabel_changes.show_label = /*show_label*/ ctx[2];
			if (dirty & /*label, i18n*/ 66) blocklabel_changes.label = /*label*/ ctx[1] || /*i18n*/ ctx[6]("image.image");
			blocklabel.$set(blocklabel_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros$2();

				transition_out$4(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros$2();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in$4(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in$4(blocklabel.$$.fragment, local);
			transition_in$4(if_block);
			current = true;
		},
		o(local) {
			transition_out$4(blocklabel.$$.fragment, local);
			transition_out$4(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$4(t);
				detach$4(if_block_anchor);
			}

			destroy_component$4(blocklabel, detaching);
			if_blocks[current_block_type_index].d(detaching);
		}
	};
}

function instance$4($$self, $$props, $$invalidate) {
	let { value } = $$props;
	let { label = undefined } = $$props;
	let { show_label } = $$props;
	let { show_download_button = true } = $$props;
	let { selectable = false } = $$props;
	let { show_share_button = false } = $$props;
	let { i18n } = $$props;
	const dispatch = createEventDispatcher$4();

	const handle_click = evt => {
		let coordinates = get_coordinates_of_clicked_image(evt);

		if (coordinates) {
			dispatch("select", { index: coordinates, value: null });
		}
	};

	const func = async value => {
		if (!value) return "";
		let url = await uploadToHuggingFace(value, "base64");
		return `<img src="${url}" />`;
	};

	function share_handler(event) {
		bubble$1.call(this, $$self, event);
	}

	function error_handler(event) {
		bubble$1.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(1, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(2, show_label = $$props.show_label);
		if ('show_download_button' in $$props) $$invalidate(3, show_download_button = $$props.show_download_button);
		if ('selectable' in $$props) $$invalidate(4, selectable = $$props.selectable);
		if ('show_share_button' in $$props) $$invalidate(5, show_share_button = $$props.show_share_button);
		if ('i18n' in $$props) $$invalidate(6, i18n = $$props.i18n);
	};

	return [
		value,
		label,
		show_label,
		show_download_button,
		selectable,
		show_share_button,
		i18n,
		handle_click,
		func,
		share_handler,
		error_handler
	];
}

class ImagePreview extends SvelteComponent$4 {
	constructor(options) {
		super();

		init$4(this, options, instance$4, create_fragment$4, safe_not_equal$4, {
			value: 0,
			label: 1,
			show_label: 2,
			show_download_button: 3,
			selectable: 4,
			show_share_button: 5,
			i18n: 6
		});
	}
}

const StaticImage = ImagePreview;

const WebcamPermissions_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/image/shared/WebcamPermissions.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$3,
	append: append$2,
	attr: attr$3,
	create_component: create_component$3,
	destroy_component: destroy_component$3,
	detach: detach$3,
	element: element$3,
	init: init$3,
	insert: insert$3,
	listen: listen$2,
	mount_component: mount_component$3,
	noop: noop$3,
	safe_not_equal: safe_not_equal$3,
	set_style,
	space: space$2,
	text: text$1,
	transition_in: transition_in$3,
	transition_out: transition_out$3
} = window.__gradio__svelte__internal;const { createEventDispatcher: createEventDispatcher$3 } = window.__gradio__svelte__internal;
function create_fragment$3(ctx) {
	let button;
	let div;
	let span;
	let webcam;
	let t0;
	let t1_value = "Click to Access Webcam" + "";
	let t1;
	let current;
	let mounted;
	let dispose;
	webcam = new Webcam$2({});

	return {
		c() {
			button = element$3("button");
			div = element$3("div");
			span = element$3("span");
			create_component$3(webcam.$$.fragment);
			t0 = space$2();
			t1 = text$1(t1_value);
			attr$3(span, "class", "icon-wrap svelte-qbrfs");
			attr$3(div, "class", "wrap svelte-qbrfs");
			attr$3(button, "class", "svelte-qbrfs");
			set_style(button, "height", `100%`);
		},
		m(target, anchor) {
			insert$3(target, button, anchor);
			append$2(button, div);
			append$2(div, span);
			mount_component$3(webcam, span, null);
			append$2(div, t0);
			append$2(div, t1);
			current = true;

			if (!mounted) {
				dispose = listen$2(button, "click", /*click_handler*/ ctx[1]);
				mounted = true;
			}
		},
		p: noop$3,
		i(local) {
			if (current) return;
			transition_in$3(webcam.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$3(webcam.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$3(button);
			}

			destroy_component$3(webcam);
			mounted = false;
			dispose();
		}
	};
}

function instance$3($$self) {
	const dispatch = createEventDispatcher$3();
	const click_handler = () => dispatch("click");
	return [dispatch, click_handler];
}

class WebcamPermissions extends SvelteComponent$3 {
	constructor(options) {
		super();
		init$3(this, options, instance$3, create_fragment$3, safe_not_equal$3, {});
	}
}

const Webcam_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/image/shared/Webcam.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$2,
	action_destroyer,
	add_render_callback,
	append: append$1,
	attr: attr$2,
	binding_callbacks: binding_callbacks$1,
	check_outros: check_outros$1,
	create_component: create_component$2,
	create_in_transition,
	destroy_component: destroy_component$2,
	destroy_each,
	detach: detach$2,
	element: element$2,
	empty: empty$1,
	ensure_array_like,
	group_outros: group_outros$1,
	init: init$2,
	insert: insert$2,
	listen: listen$1,
	mount_component: mount_component$2,
	noop: noop$2,
	run_all,
	safe_not_equal: safe_not_equal$2,
	set_data,
	set_input_value,
	space: space$1,
	stop_propagation,
	text,
	toggle_class: toggle_class$1,
	transition_in: transition_in$2,
	transition_out: transition_out$2
} = window.__gradio__svelte__internal;
const { createEventDispatcher: createEventDispatcher$2, onMount } = window.__gradio__svelte__internal;
function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[31] = list[i];
	return child_ctx;
}

// (176:1) {:else}
function create_else_block(ctx) {
	let div;
	let button;
	let current_block_type_index;
	let if_block0;
	let button_aria_label_value;
	let t0;
	let t1;
	let if_block2_anchor;
	let current;
	let mounted;
	let dispose;
	const if_block_creators = [create_if_block_4$1, create_else_block_3];
	const if_blocks = [];

	function select_block_type_1(ctx, dirty) {
		if (/*mode*/ ctx[1] === "video" || /*streaming*/ ctx[0]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type_1(ctx);
	if_block0 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	let if_block1 = !/*recording*/ ctx[6] && create_if_block_3$1(ctx);
	let if_block2 = /*options_open*/ ctx[9] && create_if_block_1$1(ctx);

	return {
		c() {
			div = element$2("div");
			button = element$2("button");
			if_block0.c();
			t0 = space$1();
			if (if_block1) if_block1.c();
			t1 = space$1();
			if (if_block2) if_block2.c();
			if_block2_anchor = empty$1();

			attr$2(button, "aria-label", button_aria_label_value = /*mode*/ ctx[1] === "image"
			? "capture photo"
			: "start recording");

			attr$2(button, "class", "svelte-1aa1mud");
			attr$2(div, "class", "button-wrap svelte-1aa1mud");
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			append$1(div, button);
			if_blocks[current_block_type_index].m(button, null);
			append$1(div, t0);
			if (if_block1) if_block1.m(div, null);
			insert$2(target, t1, anchor);
			if (if_block2) if_block2.m(target, anchor);
			insert$2(target, if_block2_anchor, anchor);
			current = true;

			if (!mounted) {
				dispose = listen$1(button, "click", /*record_video_or_photo*/ ctx[11]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_1(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros$1();

				transition_out$2(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros$1();
				if_block0 = if_blocks[current_block_type_index];

				if (!if_block0) {
					if_block0 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block0.c();
				} else {
					if_block0.p(ctx, dirty);
				}

				transition_in$2(if_block0, 1);
				if_block0.m(button, null);
			}

			if (!current || dirty[0] & /*mode*/ 2 && button_aria_label_value !== (button_aria_label_value = /*mode*/ ctx[1] === "image"
			? "capture photo"
			: "start recording")) {
				attr$2(button, "aria-label", button_aria_label_value);
			}

			if (!/*recording*/ ctx[6]) {
				if (if_block1) {
					if_block1.p(ctx, dirty);

					if (dirty[0] & /*recording*/ 64) {
						transition_in$2(if_block1, 1);
					}
				} else {
					if_block1 = create_if_block_3$1(ctx);
					if_block1.c();
					transition_in$2(if_block1, 1);
					if_block1.m(div, null);
				}
			} else if (if_block1) {
				group_outros$1();

				transition_out$2(if_block1, 1, 1, () => {
					if_block1 = null;
				});

				check_outros$1();
			}

			if (/*options_open*/ ctx[9]) {
				if (if_block2) {
					if_block2.p(ctx, dirty);

					if (dirty[0] & /*options_open*/ 512) {
						transition_in$2(if_block2, 1);
					}
				} else {
					if_block2 = create_if_block_1$1(ctx);
					if_block2.c();
					transition_in$2(if_block2, 1);
					if_block2.m(if_block2_anchor.parentNode, if_block2_anchor);
				}
			} else if (if_block2) {
				group_outros$1();

				transition_out$2(if_block2, 1, 1, () => {
					if_block2 = null;
				});

				check_outros$1();
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(if_block0);
			transition_in$2(if_block1);
			transition_in$2(if_block2);
			current = true;
		},
		o(local) {
			transition_out$2(if_block0);
			transition_out$2(if_block1);
			transition_out$2(if_block2);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
				detach$2(t1);
				detach$2(if_block2_anchor);
			}

			if_blocks[current_block_type_index].d();
			if (if_block1) if_block1.d();
			if (if_block2) if_block2.d(detaching);
			mounted = false;
			dispose();
		}
	};
}

// (172:1) {#if !webcam_accessed}
function create_if_block$1(ctx) {
	let div;
	let webcampermissions;
	let div_intro;
	let current;
	webcampermissions = new WebcamPermissions({});
	webcampermissions.$on("click", /*click_handler*/ ctx[19]);

	return {
		c() {
			div = element$2("div");
			create_component$2(webcampermissions.$$.fragment);
			attr$2(div, "title", "grant webcam access");
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			mount_component$2(webcampermissions, div, null);
			current = true;
		},
		p: noop$2,
		i(local) {
			if (current) return;
			transition_in$2(webcampermissions.$$.fragment, local);

			if (local) {
				if (!div_intro) {
					add_render_callback(() => {
						div_intro = create_in_transition(div, fade, { delay: 100, duration: 200 });
						div_intro.start();
					});
				}
			}

			current = true;
		},
		o(local) {
			transition_out$2(webcampermissions.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
			}

			destroy_component$2(webcampermissions);
		}
	};
}

// (192:4) {:else}
function create_else_block_3(ctx) {
	let div;
	let camera;
	let current;
	camera = new Camera({});

	return {
		c() {
			div = element$2("div");
			create_component$2(camera.$$.fragment);
			attr$2(div, "class", "icon svelte-1aa1mud");
			attr$2(div, "title", "capture photo");
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			mount_component$2(camera, div, null);
			current = true;
		},
		p: noop$2,
		i(local) {
			if (current) return;
			transition_in$2(camera.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(camera.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
			}

			destroy_component$2(camera);
		}
	};
}

// (182:4) {#if mode === "video" || streaming}
function create_if_block_4$1(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block_5, create_else_block_2];
	const if_blocks = [];

	function select_block_type_2(ctx, dirty) {
		if (/*recording*/ ctx[6]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type_2(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty$1();
		},
		m(target, anchor) {
			if_blocks[current_block_type_index].m(target, anchor);
			insert$2(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type_2(ctx);

			if (current_block_type_index !== previous_block_index) {
				group_outros$1();

				transition_out$2(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros$1();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				}

				transition_in$2(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(if_block);
			current = true;
		},
		o(local) {
			transition_out$2(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(if_block_anchor);
			}

			if_blocks[current_block_type_index].d(detaching);
		}
	};
}

// (187:5) {:else}
function create_else_block_2(ctx) {
	let div;
	let circle;
	let current;
	circle = new Circle({});

	return {
		c() {
			div = element$2("div");
			create_component$2(circle.$$.fragment);
			attr$2(div, "class", "icon red svelte-1aa1mud");
			attr$2(div, "title", "start recording");
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			mount_component$2(circle, div, null);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in$2(circle.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(circle.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
			}

			destroy_component$2(circle);
		}
	};
}

// (183:5) {#if recording}
function create_if_block_5(ctx) {
	let div;
	let square;
	let current;
	square = new Square({});

	return {
		c() {
			div = element$2("div");
			create_component$2(square.$$.fragment);
			attr$2(div, "class", "icon red svelte-1aa1mud");
			attr$2(div, "title", "stop recording");
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			mount_component$2(square, div, null);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in$2(square.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(square.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
			}

			destroy_component$2(square);
		}
	};
}

// (198:3) {#if !recording}
function create_if_block_3$1(ctx) {
	let button;
	let dropdownarrow;
	let current;
	let mounted;
	let dispose;
	dropdownarrow = new DropdownArrow({});

	return {
		c() {
			button = element$2("button");
			create_component$2(dropdownarrow.$$.fragment);
			attr$2(button, "class", "icon svelte-1aa1mud");
			attr$2(button, "aria-label", "select input source");
		},
		m(target, anchor) {
			insert$2(target, button, anchor);
			mount_component$2(dropdownarrow, button, null);
			current = true;

			if (!mounted) {
				dispose = listen$1(button, "click", /*select_source*/ ctx[12]);
				mounted = true;
			}
		},
		p: noop$2,
		i(local) {
			if (current) return;
			transition_in$2(dropdownarrow.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(dropdownarrow.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(button);
			}

			destroy_component$2(dropdownarrow);
			mounted = false;
			dispose();
		}
	};
}

// (208:2) {#if options_open}
function create_if_block_1$1(ctx) {
	let select;
	let button;
	let dropdownarrow;
	let t;
	let current;
	let mounted;
	let dispose;
	dropdownarrow = new DropdownArrow({});

	function select_block_type_3(ctx, dirty) {
		if (/*video_sources*/ ctx[8].length === 0) return create_if_block_2$1;
		return create_else_block_1;
	}

	let current_block_type = select_block_type_3(ctx);
	let if_block = current_block_type(ctx);

	return {
		c() {
			select = element$2("select");
			button = element$2("button");
			create_component$2(dropdownarrow.$$.fragment);
			t = space$1();
			if_block.c();
			attr$2(button, "class", "inset-icon svelte-1aa1mud");
			attr$2(select, "class", "select-wrap svelte-1aa1mud");
			attr$2(select, "aria-label", "select source");
		},
		m(target, anchor) {
			insert$2(target, select, anchor);
			append$1(select, button);
			mount_component$2(dropdownarrow, button, null);
			append$1(button, t);
			if_block.m(select, null);
			current = true;

			if (!mounted) {
				dispose = [
					listen$1(button, "click", stop_propagation(/*click_handler_1*/ ctx[20])),
					action_destroyer(click_outside.call(null, select, /*handle_click_outside*/ ctx[14]))
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (current_block_type === (current_block_type = select_block_type_3(ctx)) && if_block) {
				if_block.p(ctx, dirty);
			} else {
				if_block.d(1);
				if_block = current_block_type(ctx);

				if (if_block) {
					if_block.c();
					if_block.m(select, null);
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(dropdownarrow.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(dropdownarrow.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(select);
			}

			destroy_component$2(dropdownarrow);
			if_block.d();
			mounted = false;
			run_all(dispose);
		}
	};
}

// (222:4) {:else}
function create_else_block_1(ctx) {
	let each_1_anchor;
	let each_value = ensure_array_like(/*video_sources*/ ctx[8]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty$1();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert$2(target, each_1_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*video_sources, selectVideoSource*/ 8448) {
				each_value = ensure_array_like(/*video_sources*/ ctx[8]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		d(detaching) {
			if (detaching) {
				detach$2(each_1_anchor);
			}

			destroy_each(each_blocks, detaching);
		}
	};
}

// (220:4) {#if video_sources.length === 0}
function create_if_block_2$1(ctx) {
	let option;
	let t_value = /*i18n*/ ctx[3]("common.no_devices") + "";
	let t;

	return {
		c() {
			option = element$2("option");
			t = text(t_value);
			option.__value = "";
			set_input_value(option, option.__value);
			attr$2(option, "class", "svelte-1aa1mud");
		},
		m(target, anchor) {
			insert$2(target, option, anchor);
			append$1(option, t);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*i18n*/ 8 && t_value !== (t_value = /*i18n*/ ctx[3]("common.no_devices") + "")) set_data(t, t_value);
		},
		d(detaching) {
			if (detaching) {
				detach$2(option);
			}
		}
	};
}

// (223:5) {#each video_sources as source}
function create_each_block(ctx) {
	let option;
	let t0_value = /*source*/ ctx[31].label + "";
	let t0;
	let t1;
	let option_value_value;
	let mounted;
	let dispose;

	function click_handler_2() {
		return /*click_handler_2*/ ctx[21](/*source*/ ctx[31]);
	}

	return {
		c() {
			option = element$2("option");
			t0 = text(t0_value);
			t1 = space$1();
			option.__value = option_value_value = "\n\t\t\t\t\t\t\t" + /*source*/ ctx[31].label + "\n\t\t\t\t\t\t";
			set_input_value(option, option.__value);
			attr$2(option, "class", "svelte-1aa1mud");
		},
		m(target, anchor) {
			insert$2(target, option, anchor);
			append$1(option, t0);
			append$1(option, t1);

			if (!mounted) {
				dispose = listen$1(option, "click", click_handler_2);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			if (dirty[0] & /*video_sources*/ 256 && t0_value !== (t0_value = /*source*/ ctx[31].label + "")) set_data(t0, t0_value);

			if (dirty[0] & /*video_sources*/ 256 && option_value_value !== (option_value_value = "\n\t\t\t\t\t\t\t" + /*source*/ ctx[31].label + "\n\t\t\t\t\t\t")) {
				option.__value = option_value_value;
				set_input_value(option, option.__value);
			}
		},
		d(detaching) {
			if (detaching) {
				detach$2(option);
			}

			mounted = false;
			dispose();
		}
	};
}

function create_fragment$2(ctx) {
	let div;
	let video;
	let t;
	let current_block_type_index;
	let if_block;
	let current;
	const if_block_creators = [create_if_block$1, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (!/*webcam_accessed*/ ctx[7]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			div = element$2("div");
			video = element$2("video");
			t = space$1();
			if_block.c();
			attr$2(video, "class", "svelte-1aa1mud");
			toggle_class$1(video, "flip", /*mirror_webcam*/ ctx[2]);
			toggle_class$1(video, "hide", !/*webcam_accessed*/ ctx[7]);
			attr$2(div, "class", "wrap svelte-1aa1mud");
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			append$1(div, video);
			/*video_binding*/ ctx[18](video);
			append$1(div, t);
			if_blocks[current_block_type_index].m(div, null);
			current = true;
		},
		p(ctx, dirty) {
			if (!current || dirty[0] & /*mirror_webcam*/ 4) {
				toggle_class$1(video, "flip", /*mirror_webcam*/ ctx[2]);
			}

			if (!current || dirty[0] & /*webcam_accessed*/ 128) {
				toggle_class$1(video, "hide", !/*webcam_accessed*/ ctx[7]);
			}

			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros$1();

				transition_out$2(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros$1();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in$2(if_block, 1);
				if_block.m(div, null);
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(if_block);
			current = true;
		},
		o(local) {
			transition_out$2(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
			}

			/*video_binding*/ ctx[18](null);
			if_blocks[current_block_type_index].d();
		}
	};
}

function click_outside(node, cb) {
	const handle_click = event => {
		if (node && !node.contains(event.target) && !event.defaultPrevented) {
			cb(event);
		}
	};

	document.addEventListener("click", handle_click, true);

	return {
		destroy() {
			document.removeEventListener("click", handle_click, true);
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let video_source;
	let canvas;
	let { streaming = false } = $$props;
	let { pending = false } = $$props;
	let { root = "" } = $$props;
	let { mode = "image" } = $$props;
	let { mirror_webcam } = $$props;
	let { include_audio } = $$props;
	let { i18n } = $$props;
	const dispatch = createEventDispatcher$2();
	onMount(() => canvas = document.createElement("canvas"));

	const size = {
		width: { ideal: 1920 },
		height: { ideal: 1440 }
	};

	async function access_webcam(device_id) {
		if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
			dispatch("error", i18n("image.no_webcam_support"));
			return;
		}

		try {
			stream = await navigator.mediaDevices.getUserMedia({
				video: device_id
				? { deviceId: { exact: device_id }, ...size }
				: size,
				audio: include_audio
			});

			$$invalidate(5, video_source.srcObject = stream, video_source);
			$$invalidate(5, video_source.muted = true, video_source);
			video_source.play();
			$$invalidate(7, webcam_accessed = true);
		} catch(err) {
			if (err instanceof DOMException && err.name == "NotAllowedError") {
				dispatch("error", i18n("image.allow_webcam_access"));
			} else {
				throw err;
			}
		}
	}

	function take_picture() {
		var context = canvas.getContext("2d");

		if ((!streaming || streaming && recording) && video_source.videoWidth && video_source.videoHeight) {
			canvas.width = video_source.videoWidth;
			canvas.height = video_source.videoHeight;
			context.drawImage(video_source, 0, 0, video_source.videoWidth, video_source.videoHeight);

			if (mirror_webcam) {
				context.scale(-1, 1);
				context.drawImage(video_source, -video_source.videoWidth, 0);
			}

			canvas.toBlob(
				blob => {
					dispatch(streaming ? "stream" : "capture", blob);
				},
				"image/png",
				0.8
			);
		}
	}

	let recording = false;
	let recorded_blobs = [];
	let stream;
	let mimeType;
	let media_recorder;

	function take_recording() {
		if (recording) {
			media_recorder.stop();
			let video_blob = new Blob(recorded_blobs, { type: mimeType });
			let ReaderObj = new FileReader();

			ReaderObj.onload = async function (e) {
				if (e.target) {
					let _video_blob = new File([video_blob], "sample." + mimeType.substring(6));
					const val = await prepare_files([_video_blob]);
					let value = (await upload(val, root))?.filter(Boolean)[0];
					dispatch("capture", value);
					dispatch("stop_recording");
				}
			};

			ReaderObj.readAsDataURL(video_blob);
		} else {
			dispatch("start_recording");
			recorded_blobs = [];
			let validMimeTypes = ["video/webm", "video/mp4"];

			for (let validMimeType of validMimeTypes) {
				if (MediaRecorder.isTypeSupported(validMimeType)) {
					mimeType = validMimeType;
					break;
				}
			}

			if (mimeType === null) {
				console.error("No supported MediaRecorder mimeType");
				return;
			}

			media_recorder = new MediaRecorder(stream, { mimeType });

			media_recorder.addEventListener("dataavailable", function (e) {
				recorded_blobs.push(e.data);
			});

			media_recorder.start(200);
		}

		$$invalidate(6, recording = !recording);
	}

	let webcam_accessed = false;

	function record_video_or_photo() {
		if (mode === "image" && streaming) {
			$$invalidate(6, recording = !recording);
		}

		if (mode === "image") {
			take_picture();
		} else {
			take_recording();
		}

		if (!recording && stream) {
			stream.getTracks().forEach(track => track.stop());
			$$invalidate(5, video_source.srcObject = null, video_source);
			$$invalidate(7, webcam_accessed = false);
		}
	}

	if (streaming && mode === "image") {
		window.setInterval(
			() => {
				if (video_source && !pending) {
					take_picture();
				}
			},
			500
		);
	}

	async function select_source() {
		const devices = await navigator.mediaDevices.enumerateDevices();
		$$invalidate(8, video_sources = devices.filter(device => device.kind === "videoinput"));
		$$invalidate(9, options_open = true);
	}

	let video_sources = [];

	async function selectVideoSource(device_id) {
		await access_webcam(device_id);
		$$invalidate(9, options_open = false);
	}

	let options_open = false;

	function handle_click_outside(event) {
		event.preventDefault();
		event.stopPropagation();
		$$invalidate(9, options_open = false);
	}

	function video_binding($$value) {
		binding_callbacks$1[$$value ? 'unshift' : 'push'](() => {
			video_source = $$value;
			$$invalidate(5, video_source);
		});
	}

	const click_handler = async () => access_webcam();
	const click_handler_1 = () => $$invalidate(9, options_open = false);
	const click_handler_2 = source => selectVideoSource(source.deviceId);

	$$self.$$set = $$props => {
		if ('streaming' in $$props) $$invalidate(0, streaming = $$props.streaming);
		if ('pending' in $$props) $$invalidate(15, pending = $$props.pending);
		if ('root' in $$props) $$invalidate(16, root = $$props.root);
		if ('mode' in $$props) $$invalidate(1, mode = $$props.mode);
		if ('mirror_webcam' in $$props) $$invalidate(2, mirror_webcam = $$props.mirror_webcam);
		if ('include_audio' in $$props) $$invalidate(17, include_audio = $$props.include_audio);
		if ('i18n' in $$props) $$invalidate(3, i18n = $$props.i18n);
	};

	return [
		streaming,
		mode,
		mirror_webcam,
		i18n,
		click_outside,
		video_source,
		recording,
		webcam_accessed,
		video_sources,
		options_open,
		access_webcam,
		record_video_or_photo,
		select_source,
		selectVideoSource,
		handle_click_outside,
		pending,
		root,
		include_audio,
		video_binding,
		click_handler,
		click_handler_1,
		click_handler_2
	];
}

class Webcam extends SvelteComponent$2 {
	constructor(options) {
		super();

		init$2(
			this,
			options,
			instance$2,
			create_fragment$2,
			safe_not_equal$2,
			{
				streaming: 0,
				pending: 15,
				root: 16,
				mode: 1,
				mirror_webcam: 2,
				include_audio: 17,
				i18n: 3,
				click_outside: 4
			},
			null,
			[-1, -1]
		);
	}

	get click_outside() {
		return click_outside;
	}
}

const Webcam$1 = Webcam;

const ClearImage_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/image/shared/ClearImage.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$1,
	attr: attr$1,
	create_component: create_component$1,
	destroy_component: destroy_component$1,
	detach: detach$1,
	element: element$1,
	init: init$1,
	insert: insert$1,
	mount_component: mount_component$1,
	noop: noop$1,
	safe_not_equal: safe_not_equal$1,
	transition_in: transition_in$1,
	transition_out: transition_out$1
} = window.__gradio__svelte__internal;
const { createEventDispatcher: createEventDispatcher$1 } = window.__gradio__svelte__internal;
function create_fragment$1(ctx) {
	let div;
	let iconbutton;
	let current;

	iconbutton = new IconButton({
			props: { Icon: Clear, label: "Remove Image" }
		});

	iconbutton.$on("click", /*click_handler*/ ctx[1]);

	return {
		c() {
			div = element$1("div");
			create_component$1(iconbutton.$$.fragment);
			attr$1(div, "class", "svelte-s6ybro");
		},
		m(target, anchor) {
			insert$1(target, div, anchor);
			mount_component$1(iconbutton, div, null);
			current = true;
		},
		p: noop$1,
		i(local) {
			if (current) return;
			transition_in$1(iconbutton.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(iconbutton.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(div);
			}

			destroy_component$1(iconbutton);
		}
	};
}

function instance$1($$self) {
	const dispatch = createEventDispatcher$1();

	const click_handler = event => {
		dispatch("remove_image");
		event.stopPropagation();
	};

	return [dispatch, click_handler];
}

class ClearImage extends SvelteComponent$1 {
	constructor(options) {
		super();
		init$1(this, options, instance$1, create_fragment$1, safe_not_equal$1, {});
	}
}

const ImageUploader_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/image/shared/ImageUploader.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent,
	add_flush_callback,
	append,
	attr,
	bind,
	binding_callbacks,
	bubble,
	check_outros,
	create_component,
	create_slot,
	destroy_component,
	detach,
	element,
	empty,
	get_all_dirty_from_scope,
	get_slot_changes,
	group_outros,
	init,
	insert,
	listen,
	mount_component,
	noop,
	safe_not_equal,
	space,
	toggle_class,
	transition_in,
	transition_out,
	update_slot_base
} = window.__gradio__svelte__internal;
const { createEventDispatcher, tick } = window.__gradio__svelte__internal;
function create_if_block_4(ctx) {
	let clearimage;
	let current;
	clearimage = new ClearImage({});
	clearimage.$on("remove_image", /*remove_image_handler*/ ctx[22]);

	return {
		c() {
			create_component(clearimage.$$.fragment);
		},
		m(target, anchor) {
			mount_component(clearimage, target, anchor);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in(clearimage.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(clearimage.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(clearimage, detaching);
		}
	};
}

// (89:3) {#if value === null}
function create_if_block_3(ctx) {
	let current;
	const default_slot_template = /*#slots*/ ctx[21].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[33], null);

	return {
		c() {
			if (default_slot) default_slot.c();
		},
		m(target, anchor) {
			if (default_slot) {
				default_slot.m(target, anchor);
			}

			current = true;
		},
		p(ctx, dirty) {
			if (default_slot) {
				if (default_slot.p && (!current || dirty[1] & /*$$scope*/ 4)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[33],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[33])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[33], dirty, null),
						null
					);
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (default_slot) default_slot.d(detaching);
		}
	};
}

// (78:2) <Upload    hidden={value !== null || active_source === "webcam"}    bind:this={upload}    bind:uploading    bind:dragging    filetype={active_source === "clipboard" ? "clipboard" : "image/*"}    on:load={handle_upload}    on:error    {root}    disable_click={!sources.includes("upload")}   >
function create_default_slot(ctx) {
	let if_block_anchor;
	let current;
	let if_block = /*value*/ ctx[1] === null && create_if_block_3(ctx);

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (/*value*/ ctx[1] === null) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty[0] & /*value*/ 2) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block_3(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(if_block_anchor);
			}

			if (if_block) if_block.d(detaching);
		}
	};
}

// (107:41) 
function create_if_block_2(ctx) {
	let div;
	let image;
	let current;
	let mounted;
	let dispose;

	image = new Image$1({
			props: {
				src: /*value*/ ctx[1].url,
				alt: /*value*/ ctx[1].alt_text
			}
		});

	return {
		c() {
			div = element("div");
			create_component(image.$$.fragment);
			attr(div, "class", "image-frame svelte-rrgd5g");
			toggle_class(div, "selectable", /*selectable*/ ctx[7]);
		},
		m(target, anchor) {
			insert(target, div, anchor);
			mount_component(image, div, null);
			current = true;

			if (!mounted) {
				dispose = listen(div, "click", /*handle_click*/ ctx[18]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			const image_changes = {};
			if (dirty[0] & /*value*/ 2) image_changes.src = /*value*/ ctx[1].url;
			if (dirty[0] & /*value*/ 2) image_changes.alt = /*value*/ ctx[1].alt_text;
			image.$set(image_changes);

			if (!current || dirty[0] & /*selectable*/ 128) {
				toggle_class(div, "selectable", /*selectable*/ ctx[7]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(image.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(image.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div);
			}

			destroy_component(image);
			mounted = false;
			dispose();
		}
	};
}

// (93:2) {#if active_source === "webcam" && (streaming || (!streaming && !value))}
function create_if_block_1(ctx) {
	let webcam;
	let current;

	webcam = new Webcam$1({
			props: {
				root: /*root*/ ctx[8],
				mirror_webcam: /*mirror_webcam*/ ctx[6],
				streaming: /*streaming*/ ctx[5],
				mode: "image",
				include_audio: false,
				i18n: /*i18n*/ ctx[9]
			}
		});

	webcam.$on("capture", /*capture_handler*/ ctx[27]);
	webcam.$on("stream", /*stream_handler*/ ctx[28]);
	webcam.$on("error", /*error_handler_1*/ ctx[29]);
	webcam.$on("drag", /*drag_handler*/ ctx[30]);
	webcam.$on("upload", /*upload_handler*/ ctx[31]);

	return {
		c() {
			create_component(webcam.$$.fragment);
		},
		m(target, anchor) {
			mount_component(webcam, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const webcam_changes = {};
			if (dirty[0] & /*root*/ 256) webcam_changes.root = /*root*/ ctx[8];
			if (dirty[0] & /*mirror_webcam*/ 64) webcam_changes.mirror_webcam = /*mirror_webcam*/ ctx[6];
			if (dirty[0] & /*streaming*/ 32) webcam_changes.streaming = /*streaming*/ ctx[5];
			if (dirty[0] & /*i18n*/ 512) webcam_changes.i18n = /*i18n*/ ctx[9];
			webcam.$set(webcam_changes);
		},
		i(local) {
			if (current) return;
			transition_in(webcam.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(webcam.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(webcam, detaching);
		}
	};
}

// (115:1) {#if sources.length > 1 || sources.includes("clipboard")}
function create_if_block(ctx) {
	let selectsource;
	let updating_active_source;
	let current;

	function selectsource_active_source_binding(value) {
		/*selectsource_active_source_binding*/ ctx[32](value);
	}

	let selectsource_props = {
		sources: /*sources*/ ctx[4],
		handle_clear: /*handle_clear*/ ctx[15],
		handle_select: /*handle_select_source*/ ctx[19]
	};

	if (/*active_source*/ ctx[0] !== void 0) {
		selectsource_props.active_source = /*active_source*/ ctx[0];
	}

	selectsource = new SelectSource({ props: selectsource_props });
	binding_callbacks.push(() => bind(selectsource, 'active_source', selectsource_active_source_binding));

	return {
		c() {
			create_component(selectsource.$$.fragment);
		},
		m(target, anchor) {
			mount_component(selectsource, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const selectsource_changes = {};
			if (dirty[0] & /*sources*/ 16) selectsource_changes.sources = /*sources*/ ctx[4];

			if (!updating_active_source && dirty[0] & /*active_source*/ 1) {
				updating_active_source = true;
				selectsource_changes.active_source = /*active_source*/ ctx[0];
				add_flush_callback(() => updating_active_source = false);
			}

			selectsource.$set(selectsource_changes);
		},
		i(local) {
			if (current) return;
			transition_in(selectsource.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(selectsource.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(selectsource, detaching);
		}
	};
}

function create_fragment(ctx) {
	let blocklabel;
	let t0;
	let div1;
	let t1;
	let div0;
	let upload_1;
	let updating_uploading;
	let updating_dragging;
	let t2;
	let current_block_type_index;
	let if_block1;
	let t3;
	let show_if = /*sources*/ ctx[4].length > 1 || /*sources*/ ctx[4].includes("clipboard");
	let current;

	blocklabel = new BlockLabel({
			props: {
				show_label: /*show_label*/ ctx[3],
				Icon: Image,
				label: /*label*/ ctx[2] || "Image"
			}
		});

	let if_block0 = /*value*/ ctx[1]?.url && !/*active_streaming*/ ctx[12] && create_if_block_4(ctx);

	function upload_1_uploading_binding(value) {
		/*upload_1_uploading_binding*/ ctx[24](value);
	}

	function upload_1_dragging_binding(value) {
		/*upload_1_dragging_binding*/ ctx[25](value);
	}

	let upload_1_props = {
		hidden: /*value*/ ctx[1] !== null || /*active_source*/ ctx[0] === "webcam",
		filetype: /*active_source*/ ctx[0] === "clipboard"
		? "clipboard"
		: "image/*",
		root: /*root*/ ctx[8],
		disable_click: !/*sources*/ ctx[4].includes("upload"),
		$$slots: { default: [create_default_slot] },
		$$scope: { ctx }
	};

	if (/*uploading*/ ctx[10] !== void 0) {
		upload_1_props.uploading = /*uploading*/ ctx[10];
	}

	if (/*dragging*/ ctx[11] !== void 0) {
		upload_1_props.dragging = /*dragging*/ ctx[11];
	}

	upload_1 = new Upload({ props: upload_1_props });
	/*upload_1_binding*/ ctx[23](upload_1);
	binding_callbacks.push(() => bind(upload_1, 'uploading', upload_1_uploading_binding));
	binding_callbacks.push(() => bind(upload_1, 'dragging', upload_1_dragging_binding));
	upload_1.$on("load", /*handle_upload*/ ctx[14]);
	upload_1.$on("error", /*error_handler*/ ctx[26]);
	const if_block_creators = [create_if_block_1, create_if_block_2];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*active_source*/ ctx[0] === "webcam" && (/*streaming*/ ctx[5] || !/*streaming*/ ctx[5] && !/*value*/ ctx[1])) return 0;
		if (/*value*/ ctx[1] !== null && !/*streaming*/ ctx[5]) return 1;
		return -1;
	}

	if (~(current_block_type_index = select_block_type(ctx))) {
		if_block1 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
	}

	let if_block2 = show_if && create_if_block(ctx);

	return {
		c() {
			create_component(blocklabel.$$.fragment);
			t0 = space();
			div1 = element("div");
			if (if_block0) if_block0.c();
			t1 = space();
			div0 = element("div");
			create_component(upload_1.$$.fragment);
			t2 = space();
			if (if_block1) if_block1.c();
			t3 = space();
			if (if_block2) if_block2.c();
			attr(div0, "class", "upload-container svelte-rrgd5g");
			attr(div1, "data-testid", "image");
			attr(div1, "class", "image-container svelte-rrgd5g");
		},
		m(target, anchor) {
			mount_component(blocklabel, target, anchor);
			insert(target, t0, anchor);
			insert(target, div1, anchor);
			if (if_block0) if_block0.m(div1, null);
			append(div1, t1);
			append(div1, div0);
			mount_component(upload_1, div0, null);
			append(div0, t2);

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].m(div0, null);
			}

			append(div1, t3);
			if (if_block2) if_block2.m(div1, null);
			current = true;
		},
		p(ctx, dirty) {
			const blocklabel_changes = {};
			if (dirty[0] & /*show_label*/ 8) blocklabel_changes.show_label = /*show_label*/ ctx[3];
			if (dirty[0] & /*label*/ 4) blocklabel_changes.label = /*label*/ ctx[2] || "Image";
			blocklabel.$set(blocklabel_changes);

			if (/*value*/ ctx[1]?.url && !/*active_streaming*/ ctx[12]) {
				if (if_block0) {
					if_block0.p(ctx, dirty);

					if (dirty[0] & /*value, active_streaming*/ 4098) {
						transition_in(if_block0, 1);
					}
				} else {
					if_block0 = create_if_block_4(ctx);
					if_block0.c();
					transition_in(if_block0, 1);
					if_block0.m(div1, t1);
				}
			} else if (if_block0) {
				group_outros();

				transition_out(if_block0, 1, 1, () => {
					if_block0 = null;
				});

				check_outros();
			}

			const upload_1_changes = {};
			if (dirty[0] & /*value, active_source*/ 3) upload_1_changes.hidden = /*value*/ ctx[1] !== null || /*active_source*/ ctx[0] === "webcam";

			if (dirty[0] & /*active_source*/ 1) upload_1_changes.filetype = /*active_source*/ ctx[0] === "clipboard"
			? "clipboard"
			: "image/*";

			if (dirty[0] & /*root*/ 256) upload_1_changes.root = /*root*/ ctx[8];
			if (dirty[0] & /*sources*/ 16) upload_1_changes.disable_click = !/*sources*/ ctx[4].includes("upload");

			if (dirty[0] & /*value*/ 2 | dirty[1] & /*$$scope*/ 4) {
				upload_1_changes.$$scope = { dirty, ctx };
			}

			if (!updating_uploading && dirty[0] & /*uploading*/ 1024) {
				updating_uploading = true;
				upload_1_changes.uploading = /*uploading*/ ctx[10];
				add_flush_callback(() => updating_uploading = false);
			}

			if (!updating_dragging && dirty[0] & /*dragging*/ 2048) {
				updating_dragging = true;
				upload_1_changes.dragging = /*dragging*/ ctx[11];
				add_flush_callback(() => updating_dragging = false);
			}

			upload_1.$set(upload_1_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if (~current_block_type_index) {
					if_blocks[current_block_type_index].p(ctx, dirty);
				}
			} else {
				if (if_block1) {
					group_outros();

					transition_out(if_blocks[previous_block_index], 1, 1, () => {
						if_blocks[previous_block_index] = null;
					});

					check_outros();
				}

				if (~current_block_type_index) {
					if_block1 = if_blocks[current_block_type_index];

					if (!if_block1) {
						if_block1 = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
						if_block1.c();
					} else {
						if_block1.p(ctx, dirty);
					}

					transition_in(if_block1, 1);
					if_block1.m(div0, null);
				} else {
					if_block1 = null;
				}
			}

			if (dirty[0] & /*sources*/ 16) show_if = /*sources*/ ctx[4].length > 1 || /*sources*/ ctx[4].includes("clipboard");

			if (show_if) {
				if (if_block2) {
					if_block2.p(ctx, dirty);

					if (dirty[0] & /*sources*/ 16) {
						transition_in(if_block2, 1);
					}
				} else {
					if_block2 = create_if_block(ctx);
					if_block2.c();
					transition_in(if_block2, 1);
					if_block2.m(div1, null);
				}
			} else if (if_block2) {
				group_outros();

				transition_out(if_block2, 1, 1, () => {
					if_block2 = null;
				});

				check_outros();
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocklabel.$$.fragment, local);
			transition_in(if_block0);
			transition_in(upload_1.$$.fragment, local);
			transition_in(if_block1);
			transition_in(if_block2);
			current = true;
		},
		o(local) {
			transition_out(blocklabel.$$.fragment, local);
			transition_out(if_block0);
			transition_out(upload_1.$$.fragment, local);
			transition_out(if_block1);
			transition_out(if_block2);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(t0);
				detach(div1);
			}

			destroy_component(blocklabel, detaching);
			if (if_block0) if_block0.d();
			/*upload_1_binding*/ ctx[23](null);
			destroy_component(upload_1);

			if (~current_block_type_index) {
				if_blocks[current_block_type_index].d();
			}

			if (if_block2) if_block2.d();
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let active_streaming;
	let { $$slots: slots = {}, $$scope } = $$props;
	let { value } = $$props;
	let { label = undefined } = $$props;
	let { show_label } = $$props;
	let { sources = ["upload", "clipboard", "webcam"] } = $$props;
	let { streaming = false } = $$props;
	let { pending = false } = $$props;
	let { mirror_webcam } = $$props;
	let { selectable = false } = $$props;
	let { root } = $$props;
	let { i18n } = $$props;
	let upload;
	let uploading = false;
	let { active_source = null } = $$props;

	function handle_upload({ detail }) {
		$$invalidate(1, value = detail);
		dispatch("upload");
	}

	function handle_clear() {
		$$invalidate(1, value = null);
		dispatch("clear");
		dispatch("change", null);
	}

	async function handle_save(img_blob) {
		$$invalidate(20, pending = true);
		const f = await upload.load_files([new File([img_blob], `webcam.png`)]);
		$$invalidate(1, value = f?.[0] || null);
		await tick();
		dispatch(streaming ? "stream" : "change");
		$$invalidate(20, pending = false);
	}

	const dispatch = createEventDispatcher();
	let dragging = false;

	function handle_click(evt) {
		let coordinates = get_coordinates_of_clicked_image(evt);

		if (coordinates) {
			dispatch("select", { index: coordinates, value: null });
		}
	}

	async function handle_select_source(source) {
		switch (source) {
			case "clipboard":
				upload.paste_clipboard();
				break;
		}
	}

	const remove_image_handler = () => {
		$$invalidate(1, value = null);
		dispatch("clear");
	};

	function upload_1_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			upload = $$value;
			$$invalidate(13, upload);
		});
	}

	function upload_1_uploading_binding(value) {
		uploading = value;
		$$invalidate(10, uploading);
	}

	function upload_1_dragging_binding(value) {
		dragging = value;
		$$invalidate(11, dragging);
	}

	function error_handler(event) {
		bubble.call(this, $$self, event);
	}

	const capture_handler = e => handle_save(e.detail);
	const stream_handler = e => handle_save(e.detail);

	function error_handler_1(event) {
		bubble.call(this, $$self, event);
	}

	function drag_handler(event) {
		bubble.call(this, $$self, event);
	}

	const upload_handler = e => handle_save(e.detail);

	function selectsource_active_source_binding(value) {
		active_source = value;
		($$invalidate(0, active_source), $$invalidate(4, sources));
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(1, value = $$props.value);
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(3, show_label = $$props.show_label);
		if ('sources' in $$props) $$invalidate(4, sources = $$props.sources);
		if ('streaming' in $$props) $$invalidate(5, streaming = $$props.streaming);
		if ('pending' in $$props) $$invalidate(20, pending = $$props.pending);
		if ('mirror_webcam' in $$props) $$invalidate(6, mirror_webcam = $$props.mirror_webcam);
		if ('selectable' in $$props) $$invalidate(7, selectable = $$props.selectable);
		if ('root' in $$props) $$invalidate(8, root = $$props.root);
		if ('i18n' in $$props) $$invalidate(9, i18n = $$props.i18n);
		if ('active_source' in $$props) $$invalidate(0, active_source = $$props.active_source);
		if ('$$scope' in $$props) $$invalidate(33, $$scope = $$props.$$scope);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*active_source, sources*/ 17) {
			if (!active_source && sources) {
				$$invalidate(0, active_source = sources[0]);
			}
		}

		if ($$self.$$.dirty[0] & /*streaming, active_source*/ 33) {
			$$invalidate(12, active_streaming = streaming && active_source === "webcam");
		}

		if ($$self.$$.dirty[0] & /*uploading, active_streaming*/ 5120) {
			if (uploading && !active_streaming) $$invalidate(1, value = null);
		}

		if ($$self.$$.dirty[0] & /*dragging*/ 2048) {
			dispatch("drag", dragging);
		}
	};

	return [
		active_source,
		value,
		label,
		show_label,
		sources,
		streaming,
		mirror_webcam,
		selectable,
		root,
		i18n,
		uploading,
		dragging,
		active_streaming,
		upload,
		handle_upload,
		handle_clear,
		handle_save,
		dispatch,
		handle_click,
		handle_select_source,
		pending,
		slots,
		remove_image_handler,
		upload_1_binding,
		upload_1_uploading_binding,
		upload_1_dragging_binding,
		error_handler,
		capture_handler,
		stream_handler,
		error_handler_1,
		drag_handler,
		upload_handler,
		selectsource_active_source_binding,
		$$scope
	];
}

class ImageUploader extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance,
			create_fragment,
			safe_not_equal,
			{
				value: 1,
				label: 2,
				show_label: 3,
				sources: 4,
				streaming: 5,
				pending: 20,
				mirror_webcam: 6,
				selectable: 7,
				root: 8,
				i18n: 9,
				active_source: 0
			},
			null,
			[-1, -1]
		);
	}
}

const ImageUploader$1 = ImageUploader;

export { ImageUploader$1 as I, StaticImage as S, Webcam$1 as W };
//# sourceMappingURL=ImageUploader-d498cfc3.js.map
