import { B as Block } from './Button-cca92c6b.js';
import { B as BlockTitle } from './BlockTitle-41004e81.js';
import { C as Clear } from './Clear-9760deed.js';
import { S as Static } from './Index-3b1865e7.js';
import { F as File } from './File-e96cd7d6.js';
import { M as Music } from './Music-3a56b469.js';
import { V as Video } from './Video-3f84d9ec.js';
import { U as Upload } from './ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js';
import { I as Image } from './Image-21f57ab7.js';
export { default as BaseExample } from './Example-2a61eb0c.js';
import './index-ec890757.js';
import './svelte/svelte.js';
import './Info-954040b2.js';
import './file-url-fbb30a3f.js';

const { tick: tick$1 } = window.__gradio__svelte__internal;async function resize(target, lines, max_lines) {
  await tick$1();
  if (lines === max_lines)
    return;
  let max = max_lines === void 0 ? false : max_lines === void 0 ? 21 * 11 : 21 * (max_lines + 1);
  let min = 21 * (lines + 1);
  target.style.height = "1px";
  let scroll_height;
  if (max && target.scrollHeight > max) {
    scroll_height = max;
  } else if (target.scrollHeight < min) {
    scroll_height = min;
  } else {
    scroll_height = target.scrollHeight;
  }
  target.style.height = `${scroll_height}px`;
}
function text_area_resize(_el, _value) {
  if (_value.lines === _value.max_lines)
    return;
  _el.style.overflowY = "scroll";
  _el.addEventListener(
    "input",
    (event) => resize(event.target, _value.lines, _value.max_lines)
  );
  if (!_value.text.trim())
    return;
  resize(_el, _value.lines, _value.max_lines);
  return {
    destroy: () => _el.removeEventListener(
      "input",
      (e) => resize(e.target, _value.lines, _value.max_lines)
    )
  };
}

const MultimodalTextbox_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/multimodaltextbox/shared/MultimodalTextbox.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$1,
	action_destroyer,
	add_flush_callback: add_flush_callback$1,
	append,
	attr,
	bind: bind$1,
	binding_callbacks: binding_callbacks$1,
	bubble,
	check_outros: check_outros$1,
	create_component: create_component$1,
	destroy_component: destroy_component$1,
	destroy_each,
	detach: detach$1,
	element,
	ensure_array_like,
	group_outros: group_outros$1,
	init: init$1,
	insert: insert$1,
	is_function,
	listen,
	mount_component: mount_component$1,
	noop,
	run_all,
	safe_not_equal: safe_not_equal$1,
	set_data,
	set_input_value,
	set_style,
	space: space$1,
	text,
	toggle_class,
	transition_in: transition_in$1,
	transition_out: transition_out$1
} = window.__gradio__svelte__internal;
const { beforeUpdate, afterUpdate, createEventDispatcher, tick } = window.__gradio__svelte__internal;
function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[42] = list[i];
	child_ctx[44] = i;
	return child_ctx;
}

// (148:1) <BlockTitle {show_label} {info}>
function create_default_slot_1(ctx) {
	let t;

	return {
		c() {
			t = text(/*label*/ ctx[4]);
		},
		m(target, anchor) {
			insert$1(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*label*/ 16) set_data(t, /*label*/ ctx[4]);
		},
		d(detaching) {
			if (detaching) {
				detach$1(t);
			}
		}
	};
}

// (158:3) {#if submit_btn}
function create_if_block_4(ctx) {
	let button;
	let t;
	let mounted;
	let dispose;

	return {
		c() {
			button = element("button");
			t = text(/*submit_btn*/ ctx[9]);
			attr(button, "class", "submit-button svelte-1e5yfkl");
			toggle_class(button, "disabled", /*disabled*/ ctx[3]);
		},
		m(target, anchor) {
			insert$1(target, button, anchor);
			append(button, t);

			if (!mounted) {
				dispose = listen(button, "click", /*handle_submit*/ ctx[24]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty[0] & /*submit_btn*/ 512) set_data(t, /*submit_btn*/ ctx[9]);

			if (dirty[0] & /*disabled*/ 8) {
				toggle_class(button, "disabled", /*disabled*/ ctx[3]);
			}
		},
		d(detaching) {
			if (detaching) {
				detach$1(button);
			}

			mounted = false;
			dispose();
		}
	};
}

// (166:3) {#if value.files.length > 0}
function create_if_block$1(ctx) {
	let div;
	let current;
	let each_value = ensure_array_like(/*value*/ ctx[0].files);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	const out = i => transition_out$1(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			div = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(div, "class", "thumbnails scroll-hide svelte-1e5yfkl");
			attr(div, "data-testid", "container_el");
			set_style(div, "display", /*value*/ ctx[0].files.length > 0 ? 'flex' : 'none');
		},
		m(target, anchor) {
			insert$1(target, div, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(div, null);
				}
			}

			current = true;
		},
		p(ctx, dirty) {
			if (dirty[0] & /*value, disabled, remove_thumbnail*/ 4194313) {
				each_value = ensure_array_like(/*value*/ ctx[0].files);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in$1(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						transition_in$1(each_blocks[i], 1);
						each_blocks[i].m(div, null);
					}
				}

				group_outros$1();

				for (i = each_value.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros$1();
			}

			if (!current || dirty[0] & /*value*/ 1) {
				set_style(div, "display", /*value*/ ctx[0].files.length > 0 ? 'flex' : 'none');
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in$1(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out$1(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(div);
			}

			destroy_each(each_blocks, detaching);
		}
	};
}

// (192:7) {:else}
function create_else_block(ctx) {
	let file_1;
	let current;
	file_1 = new File({});

	return {
		c() {
			create_component$1(file_1.$$.fragment);
		},
		m(target, anchor) {
			mount_component$1(file_1, target, anchor);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in$1(file_1.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(file_1.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$1(file_1, detaching);
		}
	};
}

// (190:68) 
function create_if_block_3(ctx) {
	let video;
	let current;
	video = new Video({});

	return {
		c() {
			create_component$1(video.$$.fragment);
		},
		m(target, anchor) {
			mount_component$1(video, target, anchor);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in$1(video.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(video.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$1(video, detaching);
		}
	};
}

// (188:68) 
function create_if_block_2(ctx) {
	let music;
	let current;
	music = new Music({});

	return {
		c() {
			create_component$1(music.$$.fragment);
		},
		m(target, anchor) {
			mount_component$1(music, target, anchor);
			current = true;
		},
		p: noop,
		i(local) {
			if (current) return;
			transition_in$1(music.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(music.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$1(music, detaching);
		}
	};
}

// (180:7) {#if file.mime_type && file.mime_type.includes("image")}
function create_if_block_1(ctx) {
	let image;
	let current;

	image = new Image({
			props: {
				src: /*file*/ ctx[42].url,
				title: null,
				alt: "",
				loading: "lazy",
				class: "thumbnail-image"
			}
		});

	return {
		c() {
			create_component$1(image.$$.fragment);
		},
		m(target, anchor) {
			mount_component$1(image, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const image_changes = {};
			if (dirty[0] & /*value*/ 1) image_changes.src = /*file*/ ctx[42].url;
			image.$set(image_changes);
		},
		i(local) {
			if (current) return;
			transition_in$1(image.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(image.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component$1(image, detaching);
		}
	};
}

// (172:5) {#each value.files as file, index}
function create_each_block(ctx) {
	let button1;
	let button0;
	let clear;
	let t0;
	let show_if;
	let show_if_1;
	let show_if_2;
	let current_block_type_index;
	let if_block;
	let t1;
	let current;
	let mounted;
	let dispose;
	clear = new Clear({});

	function click_handler(...args) {
		return /*click_handler*/ ctx[31](/*index*/ ctx[44], ...args);
	}

	const if_block_creators = [create_if_block_1, create_if_block_2, create_if_block_3, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (dirty[0] & /*value*/ 1) show_if = null;
		if (dirty[0] & /*value*/ 1) show_if_1 = null;
		if (dirty[0] & /*value*/ 1) show_if_2 = null;
		if (show_if == null) show_if = !!(/*file*/ ctx[42].mime_type && /*file*/ ctx[42].mime_type.includes("image"));
		if (show_if) return 0;
		if (show_if_1 == null) show_if_1 = !!(/*file*/ ctx[42].mime_type && /*file*/ ctx[42].mime_type.includes("audio"));
		if (show_if_1) return 1;
		if (show_if_2 == null) show_if_2 = !!(/*file*/ ctx[42].mime_type && /*file*/ ctx[42].mime_type.includes("video"));
		if (show_if_2) return 2;
		return 3;
	}

	current_block_type_index = select_block_type(ctx, [-1, -1]);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			button1 = element("button");
			button0 = element("button");
			create_component$1(clear.$$.fragment);
			t0 = space$1();
			if_block.c();
			t1 = space$1();
			attr(button0, "class", "delete-button svelte-1e5yfkl");
			toggle_class(button0, "disabled", /*disabled*/ ctx[3]);
			attr(button1, "class", "thumbnail-item thumbnail-small svelte-1e5yfkl");
		},
		m(target, anchor) {
			insert$1(target, button1, anchor);
			append(button1, button0);
			mount_component$1(clear, button0, null);
			append(button1, t0);
			if_blocks[current_block_type_index].m(button1, null);
			append(button1, t1);
			current = true;

			if (!mounted) {
				dispose = listen(button0, "click", click_handler);
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (!current || dirty[0] & /*disabled*/ 8) {
				toggle_class(button0, "disabled", /*disabled*/ ctx[3]);
			}

			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx, dirty);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros$1();

				transition_out$1(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros$1();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in$1(if_block, 1);
				if_block.m(button1, t1);
			}
		},
		i(local) {
			if (current) return;
			transition_in$1(clear.$$.fragment, local);
			transition_in$1(if_block);
			current = true;
		},
		o(local) {
			transition_out$1(clear.$$.fragment, local);
			transition_out$1(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(button1);
			}

			destroy_component$1(clear);
			if_blocks[current_block_type_index].d();
			mounted = false;
			dispose();
		}
	};
}

// (150:2) <Upload    on:load={handle_upload}    filetype={accept_file_types}    {root}    bind:dragging    disable_click={true}    bind:hidden_upload   >
function create_default_slot$1(ctx) {
	let t0;
	let button;
	let t2;
	let t3;
	let textarea;
	let textarea_dir_value;
	let textarea_style_value;
	let text_area_resize_action;
	let current;
	let mounted;
	let dispose;
	let if_block0 = /*submit_btn*/ ctx[9] && create_if_block_4(ctx);
	let if_block1 = /*value*/ ctx[0].files.length > 0 && create_if_block$1(ctx);

	return {
		c() {
			if (if_block0) if_block0.c();
			t0 = space$1();
			button = element("button");
			button.textContent = "+";
			t2 = space$1();
			if (if_block1) if_block1.c();
			t3 = space$1();
			textarea = element("textarea");
			attr(button, "class", "plus-button svelte-1e5yfkl");
			toggle_class(button, "disabled", /*disabled*/ ctx[3]);
			attr(textarea, "data-testid", "textbox");
			attr(textarea, "class", "scroll-hide svelte-1e5yfkl");
			attr(textarea, "dir", textarea_dir_value = /*rtl*/ ctx[10] ? "rtl" : "ltr");
			attr(textarea, "placeholder", /*placeholder*/ ctx[2]);
			attr(textarea, "rows", /*lines*/ ctx[1]);
			textarea.disabled = /*disabled*/ ctx[3];
			textarea.autofocus = /*autofocus*/ ctx[11];

			attr(textarea, "style", textarea_style_value = /*text_align*/ ctx[12]
			? "text-align: " + /*text_align*/ ctx[12]
			: "");
		},
		m(target, anchor) {
			if (if_block0) if_block0.m(target, anchor);
			insert$1(target, t0, anchor);
			insert$1(target, button, anchor);
			insert$1(target, t2, anchor);
			if (if_block1) if_block1.m(target, anchor);
			insert$1(target, t3, anchor);
			insert$1(target, textarea, anchor);
			set_input_value(textarea, /*value*/ ctx[0].text);
			/*textarea_binding*/ ctx[33](textarea);
			current = true;
			if (/*autofocus*/ ctx[11]) textarea.focus();

			if (!mounted) {
				dispose = [
					listen(button, "click", /*handle_upload_click*/ ctx[23]),
					action_destroyer(text_area_resize_action = text_area_resize.call(null, textarea, {
						text: /*value*/ ctx[0].text,
						lines: /*lines*/ ctx[1],
						max_lines: /*max_lines*/ ctx[8]
					})),
					listen(textarea, "input", /*textarea_input_handler*/ ctx[32]),
					listen(textarea, "keypress", /*handle_keypress*/ ctx[19]),
					listen(textarea, "blur", /*blur_handler*/ ctx[29]),
					listen(textarea, "select", /*handle_select*/ ctx[18]),
					listen(textarea, "focus", /*focus_handler*/ ctx[30]),
					listen(textarea, "scroll", /*handle_scroll*/ ctx[20])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (/*submit_btn*/ ctx[9]) {
				if (if_block0) {
					if_block0.p(ctx, dirty);
				} else {
					if_block0 = create_if_block_4(ctx);
					if_block0.c();
					if_block0.m(t0.parentNode, t0);
				}
			} else if (if_block0) {
				if_block0.d(1);
				if_block0 = null;
			}

			if (!current || dirty[0] & /*disabled*/ 8) {
				toggle_class(button, "disabled", /*disabled*/ ctx[3]);
			}

			if (/*value*/ ctx[0].files.length > 0) {
				if (if_block1) {
					if_block1.p(ctx, dirty);

					if (dirty[0] & /*value*/ 1) {
						transition_in$1(if_block1, 1);
					}
				} else {
					if_block1 = create_if_block$1(ctx);
					if_block1.c();
					transition_in$1(if_block1, 1);
					if_block1.m(t3.parentNode, t3);
				}
			} else if (if_block1) {
				group_outros$1();

				transition_out$1(if_block1, 1, 1, () => {
					if_block1 = null;
				});

				check_outros$1();
			}

			if (!current || dirty[0] & /*rtl*/ 1024 && textarea_dir_value !== (textarea_dir_value = /*rtl*/ ctx[10] ? "rtl" : "ltr")) {
				attr(textarea, "dir", textarea_dir_value);
			}

			if (!current || dirty[0] & /*placeholder*/ 4) {
				attr(textarea, "placeholder", /*placeholder*/ ctx[2]);
			}

			if (!current || dirty[0] & /*lines*/ 2) {
				attr(textarea, "rows", /*lines*/ ctx[1]);
			}

			if (!current || dirty[0] & /*disabled*/ 8) {
				textarea.disabled = /*disabled*/ ctx[3];
			}

			if (!current || dirty[0] & /*autofocus*/ 2048) {
				textarea.autofocus = /*autofocus*/ ctx[11];
			}

			if (!current || dirty[0] & /*text_align*/ 4096 && textarea_style_value !== (textarea_style_value = /*text_align*/ ctx[12]
			? "text-align: " + /*text_align*/ ctx[12]
			: "")) {
				attr(textarea, "style", textarea_style_value);
			}

			if (text_area_resize_action && is_function(text_area_resize_action.update) && dirty[0] & /*value, lines, max_lines*/ 259) text_area_resize_action.update.call(null, {
				text: /*value*/ ctx[0].text,
				lines: /*lines*/ ctx[1],
				max_lines: /*max_lines*/ ctx[8]
			});

			if (dirty[0] & /*value*/ 1) {
				set_input_value(textarea, /*value*/ ctx[0].text);
			}
		},
		i(local) {
			if (current) return;
			transition_in$1(if_block1);
			current = true;
		},
		o(local) {
			transition_out$1(if_block1);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(t0);
				detach$1(button);
				detach$1(t2);
				detach$1(t3);
				detach$1(textarea);
			}

			if (if_block0) if_block0.d(detaching);
			if (if_block1) if_block1.d(detaching);
			/*textarea_binding*/ ctx[33](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

function create_fragment$1(ctx) {
	let label_1;
	let blocktitle;
	let t;
	let div;
	let upload;
	let updating_dragging;
	let updating_hidden_upload;
	let current;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[6],
				info: /*info*/ ctx[5],
				$$slots: { default: [create_default_slot_1] },
				$$scope: { ctx }
			}
		});

	function upload_dragging_binding(value) {
		/*upload_dragging_binding*/ ctx[34](value);
	}

	function upload_hidden_upload_binding(value) {
		/*upload_hidden_upload_binding*/ ctx[35](value);
	}

	let upload_props = {
		filetype: /*accept_file_types*/ ctx[16],
		root: /*root*/ ctx[13],
		disable_click: true,
		$$slots: { default: [create_default_slot$1] },
		$$scope: { ctx }
	};

	if (/*dragging*/ ctx[15] !== void 0) {
		upload_props.dragging = /*dragging*/ ctx[15];
	}

	if (/*hidden_upload*/ ctx[17] !== void 0) {
		upload_props.hidden_upload = /*hidden_upload*/ ctx[17];
	}

	upload = new Upload({ props: upload_props });
	binding_callbacks$1.push(() => bind$1(upload, 'dragging', upload_dragging_binding));
	binding_callbacks$1.push(() => bind$1(upload, 'hidden_upload', upload_hidden_upload_binding));
	upload.$on("load", /*handle_upload*/ ctx[21]);

	return {
		c() {
			label_1 = element("label");
			create_component$1(blocktitle.$$.fragment);
			t = space$1();
			div = element("div");
			create_component$1(upload.$$.fragment);
			attr(div, "class", "input-container svelte-1e5yfkl");
			toggle_class(label_1, "container", /*container*/ ctx[7]);
		},
		m(target, anchor) {
			insert$1(target, label_1, anchor);
			mount_component$1(blocktitle, label_1, null);
			append(label_1, t);
			append(label_1, div);
			mount_component$1(upload, div, null);
			current = true;
		},
		p(ctx, dirty) {
			const blocktitle_changes = {};
			if (dirty[0] & /*show_label*/ 64) blocktitle_changes.show_label = /*show_label*/ ctx[6];
			if (dirty[0] & /*info*/ 32) blocktitle_changes.info = /*info*/ ctx[5];

			if (dirty[0] & /*label*/ 16 | dirty[1] & /*$$scope*/ 16384) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);
			const upload_changes = {};
			if (dirty[0] & /*accept_file_types*/ 65536) upload_changes.filetype = /*accept_file_types*/ ctx[16];
			if (dirty[0] & /*root*/ 8192) upload_changes.root = /*root*/ ctx[13];

			if (dirty[0] & /*rtl, placeholder, lines, disabled, autofocus, text_align, value, el, max_lines, submit_btn*/ 24335 | dirty[1] & /*$$scope*/ 16384) {
				upload_changes.$$scope = { dirty, ctx };
			}

			if (!updating_dragging && dirty[0] & /*dragging*/ 32768) {
				updating_dragging = true;
				upload_changes.dragging = /*dragging*/ ctx[15];
				add_flush_callback$1(() => updating_dragging = false);
			}

			if (!updating_hidden_upload && dirty[0] & /*hidden_upload*/ 131072) {
				updating_hidden_upload = true;
				upload_changes.hidden_upload = /*hidden_upload*/ ctx[17];
				add_flush_callback$1(() => updating_hidden_upload = false);
			}

			upload.$set(upload_changes);

			if (!current || dirty[0] & /*container*/ 128) {
				toggle_class(label_1, "container", /*container*/ ctx[7]);
			}
		},
		i(local) {
			if (current) return;
			transition_in$1(blocktitle.$$.fragment, local);
			transition_in$1(upload.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(blocktitle.$$.fragment, local);
			transition_out$1(upload.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(label_1);
			}

			destroy_component$1(blocktitle);
			destroy_component$1(upload);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { value = { text: "", files: [] } } = $$props;
	let { value_is_output = false } = $$props;
	let { lines = 1 } = $$props;
	let { placeholder = "Type here..." } = $$props;
	let { disabled = false } = $$props;
	let { label } = $$props;
	let { info = undefined } = $$props;
	let { show_label = true } = $$props;
	let { container = true } = $$props;
	let { max_lines } = $$props;
	let { submit_btn = "⌲" } = $$props;
	let { rtl = false } = $$props;
	let { autofocus = false } = $$props;
	let { text_align = undefined } = $$props;
	let { autoscroll = true } = $$props;
	let { root } = $$props;
	let { file_types = null } = $$props;
	let el;
	let can_scroll;
	let previous_scroll_top = 0;
	let user_has_scrolled_up = false;
	let dragging = false;
	let oldValue = value.text;
	let accept_file_types;

	if (file_types == null) {
		accept_file_types = null;
	} else {
		file_types = file_types.map(x => {
			if (x.startsWith(".")) {
				return x;
			}

			return x + "/*";
		});

		accept_file_types = file_types.join(", ");
	}

	const dispatch = createEventDispatcher();

	beforeUpdate(() => {
		can_scroll = el && el.offsetHeight + el.scrollTop > el.scrollHeight - 100;
	});

	const scroll = () => {
		if (can_scroll && autoscroll && !user_has_scrolled_up) {
			el.scrollTo(0, el.scrollHeight);
		}
	};

	async function handle_change() {
		dispatch("change", value);

		if (!value_is_output) {
			dispatch("input");
		}
	}

	afterUpdate(() => {
		if (autofocus && el !== null) {
			el.focus();
		}

		if (can_scroll && autoscroll) {
			scroll();
		}

		$$invalidate(25, value_is_output = false);
	});

	function handle_select(event) {
		const target = event.target;
		const text = target.value;
		const index = [target.selectionStart, target.selectionEnd];
		dispatch("select", { value: text.substring(...index), index });
	}

	async function handle_keypress(e) {
		await tick();

		if (e.key === "Enter" && e.shiftKey && lines > 1) {
			e.preventDefault();
			dispatch("submit");
		} else if (e.key === "Enter" && !e.shiftKey && lines === 1 && max_lines >= 1) {
			e.preventDefault();
			dispatch("submit");
		}
	}

	function handle_scroll(event) {
		const target = event.target;
		const current_scroll_top = target.scrollTop;

		if (current_scroll_top < previous_scroll_top) {
			user_has_scrolled_up = true;
		}

		previous_scroll_top = current_scroll_top;
		const max_scroll_top = target.scrollHeight - target.clientHeight;
		const user_has_scrolled_to_bottom = current_scroll_top >= max_scroll_top;

		if (user_has_scrolled_to_bottom) {
			user_has_scrolled_up = false;
		}
	}

	async function handle_upload({ detail }) {
		handle_change();

		if (Array.isArray(detail)) {
			for (let file of detail) {
				value.files.push(file);
			}
		} else {
			value.files.push(detail);
			$$invalidate(0, value);
		}

		await tick();
		dispatch("change", value);
		dispatch("upload", detail);
	}

	function remove_thumbnail(event, index) {
		handle_change();
		event.stopPropagation();
		value.files.splice(index, 1);
		$$invalidate(0, value);
	}

	let hidden_upload;

	function handle_upload_click() {
		if (hidden_upload) {
			hidden_upload.click();
		}
	}

	async function handle_submit() {
		dispatch("submit");
	}

	function blur_handler(event) {
		bubble.call(this, $$self, event);
	}

	function focus_handler(event) {
		bubble.call(this, $$self, event);
	}

	const click_handler = (index, event) => remove_thumbnail(event, index);

	function textarea_input_handler() {
		value.text = this.value;
		$$invalidate(0, value);
	}

	function textarea_binding($$value) {
		binding_callbacks$1[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(14, el);
		});
	}

	function upload_dragging_binding(value) {
		dragging = value;
		$$invalidate(15, dragging);
	}

	function upload_hidden_upload_binding(value) {
		hidden_upload = value;
		$$invalidate(17, hidden_upload);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('value_is_output' in $$props) $$invalidate(25, value_is_output = $$props.value_is_output);
		if ('lines' in $$props) $$invalidate(1, lines = $$props.lines);
		if ('placeholder' in $$props) $$invalidate(2, placeholder = $$props.placeholder);
		if ('disabled' in $$props) $$invalidate(3, disabled = $$props.disabled);
		if ('label' in $$props) $$invalidate(4, label = $$props.label);
		if ('info' in $$props) $$invalidate(5, info = $$props.info);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
		if ('container' in $$props) $$invalidate(7, container = $$props.container);
		if ('max_lines' in $$props) $$invalidate(8, max_lines = $$props.max_lines);
		if ('submit_btn' in $$props) $$invalidate(9, submit_btn = $$props.submit_btn);
		if ('rtl' in $$props) $$invalidate(10, rtl = $$props.rtl);
		if ('autofocus' in $$props) $$invalidate(11, autofocus = $$props.autofocus);
		if ('text_align' in $$props) $$invalidate(12, text_align = $$props.text_align);
		if ('autoscroll' in $$props) $$invalidate(27, autoscroll = $$props.autoscroll);
		if ('root' in $$props) $$invalidate(13, root = $$props.root);
		if ('file_types' in $$props) $$invalidate(26, file_types = $$props.file_types);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*dragging*/ 32768) {
			dispatch("drag", dragging);
		}

		if ($$self.$$.dirty[0] & /*value*/ 1) {
			if (value === null) $$invalidate(0, value = { text: "", files: [] });
		}

		if ($$self.$$.dirty[0] & /*oldValue, value*/ 268435457) {
			if (oldValue !== value.text) {
				dispatch("change", value);
				$$invalidate(28, oldValue = value.text);
			}
		}

		if ($$self.$$.dirty[0] & /*value, el, lines, max_lines*/ 16643) {
			(el && lines !== max_lines && resize(el, lines, max_lines));
		}
	};

	return [
		value,
		lines,
		placeholder,
		disabled,
		label,
		info,
		show_label,
		container,
		max_lines,
		submit_btn,
		rtl,
		autofocus,
		text_align,
		root,
		el,
		dragging,
		accept_file_types,
		hidden_upload,
		handle_select,
		handle_keypress,
		handle_scroll,
		handle_upload,
		remove_thumbnail,
		handle_upload_click,
		handle_submit,
		value_is_output,
		file_types,
		autoscroll,
		oldValue,
		blur_handler,
		focus_handler,
		click_handler,
		textarea_input_handler,
		textarea_binding,
		upload_dragging_binding,
		upload_hidden_upload_binding
	];
}

class MultimodalTextbox extends SvelteComponent$1 {
	constructor(options) {
		super();

		init$1(
			this,
			options,
			instance$1,
			create_fragment$1,
			safe_not_equal$1,
			{
				value: 0,
				value_is_output: 25,
				lines: 1,
				placeholder: 2,
				disabled: 3,
				label: 4,
				info: 5,
				show_label: 6,
				container: 7,
				max_lines: 8,
				submit_btn: 9,
				rtl: 10,
				autofocus: 11,
				text_align: 12,
				autoscroll: 27,
				root: 13,
				file_types: 26
			},
			null,
			[-1, -1]
		);
	}
}

const MultimodalTextbox$1 = MultimodalTextbox;

/* home/runner/work/gradio/gradio/js/multimodaltextbox/Index.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent,
	add_flush_callback,
	assign,
	bind,
	binding_callbacks,
	check_outros,
	create_component,
	destroy_component,
	detach,
	flush,
	get_spread_object,
	get_spread_update,
	group_outros,
	init,
	insert,
	mount_component,
	safe_not_equal,
	space,
	transition_in,
	transition_out
} = window.__gradio__svelte__internal;
function create_if_block(ctx) {
	let statustracker;
	let current;

	const statustracker_spread_levels = [
		{ autoscroll: /*gradio*/ ctx[2].autoscroll },
		{ i18n: /*gradio*/ ctx[2].i18n },
		/*loading_status*/ ctx[17]
	];

	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new Static({ props: statustracker_props });

	return {
		c() {
			create_component(statustracker.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty[0] & /*gradio, loading_status*/ 131076)
			? get_spread_update(statustracker_spread_levels, [
					dirty[0] & /*gradio*/ 4 && { autoscroll: /*gradio*/ ctx[2].autoscroll },
					dirty[0] & /*gradio*/ 4 && { i18n: /*gradio*/ ctx[2].i18n },
					dirty[0] & /*loading_status*/ 131072 && get_spread_object(/*loading_status*/ ctx[17])
				])
			: {};

			statustracker.$set(statustracker_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
		}
	};
}

// (39:0) <Block  {visible}  {elem_id}  {elem_classes}  {scale}  {min_width}  allow_overflow={false}  padding={container} >
function create_default_slot(ctx) {
	let t;
	let multimodaltextbox;
	let updating_value;
	let updating_value_is_output;
	let current;
	let if_block = /*loading_status*/ ctx[17] && create_if_block(ctx);

	function multimodaltextbox_value_binding(value) {
		/*multimodaltextbox_value_binding*/ ctx[24](value);
	}

	function multimodaltextbox_value_is_output_binding(value) {
		/*multimodaltextbox_value_is_output_binding*/ ctx[25](value);
	}

	let multimodaltextbox_props = {
		file_types: /*file_types*/ ctx[6],
		root: /*root*/ ctx[23],
		label: /*label*/ ctx[9],
		info: /*info*/ ctx[10],
		show_label: /*show_label*/ ctx[11],
		lines: /*lines*/ ctx[7],
		rtl: /*rtl*/ ctx[18],
		text_align: /*text_align*/ ctx[19],
		max_lines: !/*max_lines*/ ctx[12]
		? /*lines*/ ctx[7] + 1
		: /*max_lines*/ ctx[12],
		placeholder: /*placeholder*/ ctx[8],
		submit_btn: /*submit_btn*/ ctx[16],
		autofocus: /*autofocus*/ ctx[20],
		container: /*container*/ ctx[13],
		autoscroll: /*autoscroll*/ ctx[21],
		disabled: !/*interactive*/ ctx[22]
	};

	if (/*value*/ ctx[0] !== void 0) {
		multimodaltextbox_props.value = /*value*/ ctx[0];
	}

	if (/*value_is_output*/ ctx[1] !== void 0) {
		multimodaltextbox_props.value_is_output = /*value_is_output*/ ctx[1];
	}

	multimodaltextbox = new MultimodalTextbox$1({ props: multimodaltextbox_props });
	binding_callbacks.push(() => bind(multimodaltextbox, 'value', multimodaltextbox_value_binding));
	binding_callbacks.push(() => bind(multimodaltextbox, 'value_is_output', multimodaltextbox_value_is_output_binding));
	multimodaltextbox.$on("change", /*change_handler*/ ctx[26]);
	multimodaltextbox.$on("input", /*input_handler*/ ctx[27]);
	multimodaltextbox.$on("submit", /*submit_handler*/ ctx[28]);
	multimodaltextbox.$on("blur", /*blur_handler*/ ctx[29]);
	multimodaltextbox.$on("select", /*select_handler*/ ctx[30]);
	multimodaltextbox.$on("focus", /*focus_handler*/ ctx[31]);

	return {
		c() {
			if (if_block) if_block.c();
			t = space();
			create_component(multimodaltextbox.$$.fragment);
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert(target, t, anchor);
			mount_component(multimodaltextbox, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (/*loading_status*/ ctx[17]) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty[0] & /*loading_status*/ 131072) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(t.parentNode, t);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			const multimodaltextbox_changes = {};
			if (dirty[0] & /*file_types*/ 64) multimodaltextbox_changes.file_types = /*file_types*/ ctx[6];
			if (dirty[0] & /*root*/ 8388608) multimodaltextbox_changes.root = /*root*/ ctx[23];
			if (dirty[0] & /*label*/ 512) multimodaltextbox_changes.label = /*label*/ ctx[9];
			if (dirty[0] & /*info*/ 1024) multimodaltextbox_changes.info = /*info*/ ctx[10];
			if (dirty[0] & /*show_label*/ 2048) multimodaltextbox_changes.show_label = /*show_label*/ ctx[11];
			if (dirty[0] & /*lines*/ 128) multimodaltextbox_changes.lines = /*lines*/ ctx[7];
			if (dirty[0] & /*rtl*/ 262144) multimodaltextbox_changes.rtl = /*rtl*/ ctx[18];
			if (dirty[0] & /*text_align*/ 524288) multimodaltextbox_changes.text_align = /*text_align*/ ctx[19];

			if (dirty[0] & /*max_lines, lines*/ 4224) multimodaltextbox_changes.max_lines = !/*max_lines*/ ctx[12]
			? /*lines*/ ctx[7] + 1
			: /*max_lines*/ ctx[12];

			if (dirty[0] & /*placeholder*/ 256) multimodaltextbox_changes.placeholder = /*placeholder*/ ctx[8];
			if (dirty[0] & /*submit_btn*/ 65536) multimodaltextbox_changes.submit_btn = /*submit_btn*/ ctx[16];
			if (dirty[0] & /*autofocus*/ 1048576) multimodaltextbox_changes.autofocus = /*autofocus*/ ctx[20];
			if (dirty[0] & /*container*/ 8192) multimodaltextbox_changes.container = /*container*/ ctx[13];
			if (dirty[0] & /*autoscroll*/ 2097152) multimodaltextbox_changes.autoscroll = /*autoscroll*/ ctx[21];
			if (dirty[0] & /*interactive*/ 4194304) multimodaltextbox_changes.disabled = !/*interactive*/ ctx[22];

			if (!updating_value && dirty[0] & /*value*/ 1) {
				updating_value = true;
				multimodaltextbox_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			if (!updating_value_is_output && dirty[0] & /*value_is_output*/ 2) {
				updating_value_is_output = true;
				multimodaltextbox_changes.value_is_output = /*value_is_output*/ ctx[1];
				add_flush_callback(() => updating_value_is_output = false);
			}

			multimodaltextbox.$set(multimodaltextbox_changes);
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			transition_in(multimodaltextbox.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			transition_out(multimodaltextbox.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(t);
			}

			if (if_block) if_block.d(detaching);
			destroy_component(multimodaltextbox, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[5],
				elem_id: /*elem_id*/ ctx[3],
				elem_classes: /*elem_classes*/ ctx[4],
				scale: /*scale*/ ctx[14],
				min_width: /*min_width*/ ctx[15],
				allow_overflow: false,
				padding: /*container*/ ctx[13],
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const block_changes = {};
			if (dirty[0] & /*visible*/ 32) block_changes.visible = /*visible*/ ctx[5];
			if (dirty[0] & /*elem_id*/ 8) block_changes.elem_id = /*elem_id*/ ctx[3];
			if (dirty[0] & /*elem_classes*/ 16) block_changes.elem_classes = /*elem_classes*/ ctx[4];
			if (dirty[0] & /*scale*/ 16384) block_changes.scale = /*scale*/ ctx[14];
			if (dirty[0] & /*min_width*/ 32768) block_changes.min_width = /*min_width*/ ctx[15];
			if (dirty[0] & /*container*/ 8192) block_changes.padding = /*container*/ ctx[13];

			if (dirty[0] & /*file_types, root, label, info, show_label, lines, rtl, text_align, max_lines, placeholder, submit_btn, autofocus, container, autoscroll, interactive, value, value_is_output, gradio, loading_status*/ 16728007 | dirty[1] & /*$$scope*/ 2) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { gradio } = $$props;
	let { elem_id = "" } = $$props;
	let { elem_classes = [] } = $$props;
	let { visible = true } = $$props;
	let { value = { text: "", files: [] } } = $$props;
	let { file_types = null } = $$props;
	let { lines } = $$props;
	let { placeholder = "" } = $$props;
	let { label = "MultimodalTextbox" } = $$props;
	let { info = undefined } = $$props;
	let { show_label } = $$props;
	let { max_lines } = $$props;
	let { container = true } = $$props;
	let { scale = null } = $$props;
	let { min_width = undefined } = $$props;
	let { submit_btn = "⌲" } = $$props;
	let { loading_status = undefined } = $$props;
	let { value_is_output = false } = $$props;
	let { rtl = false } = $$props;
	let { text_align = undefined } = $$props;
	let { autofocus = false } = $$props;
	let { autoscroll = true } = $$props;
	let { interactive } = $$props;
	let { root } = $$props;

	function multimodaltextbox_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function multimodaltextbox_value_is_output_binding(value) {
		value_is_output = value;
		$$invalidate(1, value_is_output);
	}

	const change_handler = () => gradio.dispatch("change", value);
	const input_handler = () => gradio.dispatch("input");
	const submit_handler = () => gradio.dispatch("submit");
	const blur_handler = () => gradio.dispatch("blur");
	const select_handler = e => gradio.dispatch("select", e.detail);
	const focus_handler = () => gradio.dispatch("focus");

	$$self.$$set = $$props => {
		if ('gradio' in $$props) $$invalidate(2, gradio = $$props.gradio);
		if ('elem_id' in $$props) $$invalidate(3, elem_id = $$props.elem_id);
		if ('elem_classes' in $$props) $$invalidate(4, elem_classes = $$props.elem_classes);
		if ('visible' in $$props) $$invalidate(5, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('file_types' in $$props) $$invalidate(6, file_types = $$props.file_types);
		if ('lines' in $$props) $$invalidate(7, lines = $$props.lines);
		if ('placeholder' in $$props) $$invalidate(8, placeholder = $$props.placeholder);
		if ('label' in $$props) $$invalidate(9, label = $$props.label);
		if ('info' in $$props) $$invalidate(10, info = $$props.info);
		if ('show_label' in $$props) $$invalidate(11, show_label = $$props.show_label);
		if ('max_lines' in $$props) $$invalidate(12, max_lines = $$props.max_lines);
		if ('container' in $$props) $$invalidate(13, container = $$props.container);
		if ('scale' in $$props) $$invalidate(14, scale = $$props.scale);
		if ('min_width' in $$props) $$invalidate(15, min_width = $$props.min_width);
		if ('submit_btn' in $$props) $$invalidate(16, submit_btn = $$props.submit_btn);
		if ('loading_status' in $$props) $$invalidate(17, loading_status = $$props.loading_status);
		if ('value_is_output' in $$props) $$invalidate(1, value_is_output = $$props.value_is_output);
		if ('rtl' in $$props) $$invalidate(18, rtl = $$props.rtl);
		if ('text_align' in $$props) $$invalidate(19, text_align = $$props.text_align);
		if ('autofocus' in $$props) $$invalidate(20, autofocus = $$props.autofocus);
		if ('autoscroll' in $$props) $$invalidate(21, autoscroll = $$props.autoscroll);
		if ('interactive' in $$props) $$invalidate(22, interactive = $$props.interactive);
		if ('root' in $$props) $$invalidate(23, root = $$props.root);
	};

	return [
		value,
		value_is_output,
		gradio,
		elem_id,
		elem_classes,
		visible,
		file_types,
		lines,
		placeholder,
		label,
		info,
		show_label,
		max_lines,
		container,
		scale,
		min_width,
		submit_btn,
		loading_status,
		rtl,
		text_align,
		autofocus,
		autoscroll,
		interactive,
		root,
		multimodaltextbox_value_binding,
		multimodaltextbox_value_is_output_binding,
		change_handler,
		input_handler,
		submit_handler,
		blur_handler,
		select_handler,
		focus_handler
	];
}

class Index extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance,
			create_fragment,
			safe_not_equal,
			{
				gradio: 2,
				elem_id: 3,
				elem_classes: 4,
				visible: 5,
				value: 0,
				file_types: 6,
				lines: 7,
				placeholder: 8,
				label: 9,
				info: 10,
				show_label: 11,
				max_lines: 12,
				container: 13,
				scale: 14,
				min_width: 15,
				submit_btn: 16,
				loading_status: 17,
				value_is_output: 1,
				rtl: 18,
				text_align: 19,
				autofocus: 20,
				autoscroll: 21,
				interactive: 22,
				root: 23
			},
			null,
			[-1, -1]
		);
	}

	get gradio() {
		return this.$$.ctx[2];
	}

	set gradio(gradio) {
		this.$$set({ gradio });
		flush();
	}

	get elem_id() {
		return this.$$.ctx[3];
	}

	set elem_id(elem_id) {
		this.$$set({ elem_id });
		flush();
	}

	get elem_classes() {
		return this.$$.ctx[4];
	}

	set elem_classes(elem_classes) {
		this.$$set({ elem_classes });
		flush();
	}

	get visible() {
		return this.$$.ctx[5];
	}

	set visible(visible) {
		this.$$set({ visible });
		flush();
	}

	get value() {
		return this.$$.ctx[0];
	}

	set value(value) {
		this.$$set({ value });
		flush();
	}

	get file_types() {
		return this.$$.ctx[6];
	}

	set file_types(file_types) {
		this.$$set({ file_types });
		flush();
	}

	get lines() {
		return this.$$.ctx[7];
	}

	set lines(lines) {
		this.$$set({ lines });
		flush();
	}

	get placeholder() {
		return this.$$.ctx[8];
	}

	set placeholder(placeholder) {
		this.$$set({ placeholder });
		flush();
	}

	get label() {
		return this.$$.ctx[9];
	}

	set label(label) {
		this.$$set({ label });
		flush();
	}

	get info() {
		return this.$$.ctx[10];
	}

	set info(info) {
		this.$$set({ info });
		flush();
	}

	get show_label() {
		return this.$$.ctx[11];
	}

	set show_label(show_label) {
		this.$$set({ show_label });
		flush();
	}

	get max_lines() {
		return this.$$.ctx[12];
	}

	set max_lines(max_lines) {
		this.$$set({ max_lines });
		flush();
	}

	get container() {
		return this.$$.ctx[13];
	}

	set container(container) {
		this.$$set({ container });
		flush();
	}

	get scale() {
		return this.$$.ctx[14];
	}

	set scale(scale) {
		this.$$set({ scale });
		flush();
	}

	get min_width() {
		return this.$$.ctx[15];
	}

	set min_width(min_width) {
		this.$$set({ min_width });
		flush();
	}

	get submit_btn() {
		return this.$$.ctx[16];
	}

	set submit_btn(submit_btn) {
		this.$$set({ submit_btn });
		flush();
	}

	get loading_status() {
		return this.$$.ctx[17];
	}

	set loading_status(loading_status) {
		this.$$set({ loading_status });
		flush();
	}

	get value_is_output() {
		return this.$$.ctx[1];
	}

	set value_is_output(value_is_output) {
		this.$$set({ value_is_output });
		flush();
	}

	get rtl() {
		return this.$$.ctx[18];
	}

	set rtl(rtl) {
		this.$$set({ rtl });
		flush();
	}

	get text_align() {
		return this.$$.ctx[19];
	}

	set text_align(text_align) {
		this.$$set({ text_align });
		flush();
	}

	get autofocus() {
		return this.$$.ctx[20];
	}

	set autofocus(autofocus) {
		this.$$set({ autofocus });
		flush();
	}

	get autoscroll() {
		return this.$$.ctx[21];
	}

	set autoscroll(autoscroll) {
		this.$$set({ autoscroll });
		flush();
	}

	get interactive() {
		return this.$$.ctx[22];
	}

	set interactive(interactive) {
		this.$$set({ interactive });
		flush();
	}

	get root() {
		return this.$$.ctx[23];
	}

	set root(root) {
		this.$$set({ root });
		flush();
	}
}

export { MultimodalTextbox$1 as BaseMultimodalTextbox, Index as default };
//# sourceMappingURL=Index-2f742270.js.map
