import { S as Static } from './Index-3b1865e7.js';
import { b as fly, B as Block } from './Button-cca92c6b.js';
import { B as BlockTitle } from './BlockTitle-41004e81.js';
import { D as DropdownArrow } from './DropdownArrow-e7cb3811.js';
export { default as BaseExample } from './Example-84a3b179.js';
import './index-ec890757.js';
import './svelte/svelte.js';
import './Info-954040b2.js';

/* home/runner/work/gradio/gradio/js/icons/src/Remove.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$4,
	append: append$3,
	attr: attr$3,
	detach: detach$4,
	init: init$4,
	insert: insert$4,
	noop,
	safe_not_equal: safe_not_equal$4,
	svg_element
} = window.__gradio__svelte__internal;
function create_fragment$4(ctx) {
	let svg;
	let path;

	return {
		c() {
			svg = svg_element("svg");
			path = svg_element("path");
			attr$3(path, "d", "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z");
			attr$3(svg, "xmlns", "http://www.w3.org/2000/svg");
			attr$3(svg, "viewBox", "0 0 24 24");
		},
		m(target, anchor) {
			insert$4(target, svg, anchor);
			append$3(svg, path);
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) {
				detach$4(svg);
			}
		}
	};
}

class Remove extends SvelteComponent$4 {
	constructor(options) {
		super();
		init$4(this, options, null, create_fragment$4, safe_not_equal$4, {});
	}
}

const DropdownOptions_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/dropdown/shared/DropdownOptions.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$3,
	add_render_callback,
	append: append$2,
	attr: attr$2,
	binding_callbacks: binding_callbacks$3,
	check_outros: check_outros$3,
	create_bidirectional_transition,
	destroy_each: destroy_each$1,
	detach: detach$3,
	element: element$2,
	empty: empty$1,
	ensure_array_like: ensure_array_like$1,
	group_outros: group_outros$3,
	init: init$3,
	insert: insert$3,
	listen: listen$2,
	prevent_default: prevent_default$1,
	run_all: run_all$2,
	safe_not_equal: safe_not_equal$3,
	set_data: set_data$2,
	set_style,
	space: space$3,
	text: text$2,
	toggle_class: toggle_class$2,
	transition_in: transition_in$3,
	transition_out: transition_out$3
} = window.__gradio__svelte__internal;const { createEventDispatcher: createEventDispatcher$2 } = window.__gradio__svelte__internal;
function get_each_context$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[24] = list[i];
	return child_ctx;
}

// (68:0) {#if show_options && !disabled}
function create_if_block$3(ctx) {
	let ul;
	let ul_transition;
	let current;
	let mounted;
	let dispose;
	let each_value = ensure_array_like$1(/*filtered_indices*/ ctx[1]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$1(get_each_context$1(ctx, each_value, i));
	}

	return {
		c() {
			ul = element$2("ul");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr$2(ul, "class", "options svelte-1aonegi");
			attr$2(ul, "role", "listbox");
			set_style(ul, "top", /*top*/ ctx[9]);
			set_style(ul, "bottom", /*bottom*/ ctx[10]);
			set_style(ul, "max-height", `calc(${/*max_height*/ ctx[11]}px - var(--window-padding))`);
			set_style(ul, "width", /*input_width*/ ctx[8] + "px");
		},
		m(target, anchor) {
			insert$3(target, ul, anchor);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(ul, null);
				}
			}

			/*ul_binding*/ ctx[21](ul);
			current = true;

			if (!mounted) {
				dispose = listen$2(ul, "mousedown", prevent_default$1(/*mousedown_handler*/ ctx[20]));
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (dirty & /*filtered_indices, choices, selected_indices, active_index*/ 51) {
				each_value = ensure_array_like$1(/*filtered_indices*/ ctx[1]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$1(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(ul, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (dirty & /*top*/ 512) {
				set_style(ul, "top", /*top*/ ctx[9]);
			}

			if (dirty & /*bottom*/ 1024) {
				set_style(ul, "bottom", /*bottom*/ ctx[10]);
			}

			if (dirty & /*max_height*/ 2048) {
				set_style(ul, "max-height", `calc(${/*max_height*/ ctx[11]}px - var(--window-padding))`);
			}

			if (dirty & /*input_width*/ 256) {
				set_style(ul, "width", /*input_width*/ ctx[8] + "px");
			}
		},
		i(local) {
			if (current) return;

			if (local) {
				add_render_callback(() => {
					if (!current) return;
					if (!ul_transition) ul_transition = create_bidirectional_transition(ul, fly, { duration: 200, y: 5 }, true);
					ul_transition.run(1);
				});
			}

			current = true;
		},
		o(local) {
			if (local) {
				if (!ul_transition) ul_transition = create_bidirectional_transition(ul, fly, { duration: 200, y: 5 }, false);
				ul_transition.run(0);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$3(ul);
			}

			destroy_each$1(each_blocks, detaching);
			/*ul_binding*/ ctx[21](null);
			if (detaching && ul_transition) ul_transition.end();
			mounted = false;
			dispose();
		}
	};
}

// (80:2) {#each filtered_indices as index}
function create_each_block$1(ctx) {
	let li;
	let span;
	let t1;
	let t2_value = /*choices*/ ctx[0][/*index*/ ctx[24]][0] + "";
	let t2;
	let t3;
	let li_data_index_value;
	let li_aria_label_value;
	let li_aria_selected_value;

	return {
		c() {
			li = element$2("li");
			span = element$2("span");
			span.textContent = "✓";
			t1 = space$3();
			t2 = text$2(t2_value);
			t3 = space$3();
			attr$2(span, "class", "inner-item svelte-1aonegi");
			toggle_class$2(span, "hide", !/*selected_indices*/ ctx[4].includes(/*index*/ ctx[24]));
			attr$2(li, "class", "item svelte-1aonegi");
			attr$2(li, "data-index", li_data_index_value = /*index*/ ctx[24]);
			attr$2(li, "aria-label", li_aria_label_value = /*choices*/ ctx[0][/*index*/ ctx[24]][0]);
			attr$2(li, "data-testid", "dropdown-option");
			attr$2(li, "role", "option");
			attr$2(li, "aria-selected", li_aria_selected_value = /*selected_indices*/ ctx[4].includes(/*index*/ ctx[24]));
			toggle_class$2(li, "selected", /*selected_indices*/ ctx[4].includes(/*index*/ ctx[24]));
			toggle_class$2(li, "active", /*index*/ ctx[24] === /*active_index*/ ctx[5]);
			toggle_class$2(li, "bg-gray-100", /*index*/ ctx[24] === /*active_index*/ ctx[5]);
			toggle_class$2(li, "dark:bg-gray-600", /*index*/ ctx[24] === /*active_index*/ ctx[5]);
		},
		m(target, anchor) {
			insert$3(target, li, anchor);
			append$2(li, span);
			append$2(li, t1);
			append$2(li, t2);
			append$2(li, t3);
		},
		p(ctx, dirty) {
			if (dirty & /*selected_indices, filtered_indices*/ 18) {
				toggle_class$2(span, "hide", !/*selected_indices*/ ctx[4].includes(/*index*/ ctx[24]));
			}

			if (dirty & /*choices, filtered_indices*/ 3 && t2_value !== (t2_value = /*choices*/ ctx[0][/*index*/ ctx[24]][0] + "")) set_data$2(t2, t2_value);

			if (dirty & /*filtered_indices*/ 2 && li_data_index_value !== (li_data_index_value = /*index*/ ctx[24])) {
				attr$2(li, "data-index", li_data_index_value);
			}

			if (dirty & /*choices, filtered_indices*/ 3 && li_aria_label_value !== (li_aria_label_value = /*choices*/ ctx[0][/*index*/ ctx[24]][0])) {
				attr$2(li, "aria-label", li_aria_label_value);
			}

			if (dirty & /*selected_indices, filtered_indices*/ 18 && li_aria_selected_value !== (li_aria_selected_value = /*selected_indices*/ ctx[4].includes(/*index*/ ctx[24]))) {
				attr$2(li, "aria-selected", li_aria_selected_value);
			}

			if (dirty & /*selected_indices, filtered_indices*/ 18) {
				toggle_class$2(li, "selected", /*selected_indices*/ ctx[4].includes(/*index*/ ctx[24]));
			}

			if (dirty & /*filtered_indices, active_index*/ 34) {
				toggle_class$2(li, "active", /*index*/ ctx[24] === /*active_index*/ ctx[5]);
			}

			if (dirty & /*filtered_indices, active_index*/ 34) {
				toggle_class$2(li, "bg-gray-100", /*index*/ ctx[24] === /*active_index*/ ctx[5]);
			}

			if (dirty & /*filtered_indices, active_index*/ 34) {
				toggle_class$2(li, "dark:bg-gray-600", /*index*/ ctx[24] === /*active_index*/ ctx[5]);
			}
		},
		d(detaching) {
			if (detaching) {
				detach$3(li);
			}
		}
	};
}

function create_fragment$3(ctx) {
	let div;
	let t;
	let if_block_anchor;
	let mounted;
	let dispose;
	add_render_callback(/*onwindowresize*/ ctx[18]);
	let if_block = /*show_options*/ ctx[2] && !/*disabled*/ ctx[3] && create_if_block$3(ctx);

	return {
		c() {
			div = element$2("div");
			t = space$3();
			if (if_block) if_block.c();
			if_block_anchor = empty$1();
			attr$2(div, "class", "reference");
		},
		m(target, anchor) {
			insert$3(target, div, anchor);
			/*div_binding*/ ctx[19](div);
			insert$3(target, t, anchor);
			if (if_block) if_block.m(target, anchor);
			insert$3(target, if_block_anchor, anchor);

			if (!mounted) {
				dispose = [
					listen$2(window, "scroll", /*scroll_listener*/ ctx[13]),
					listen$2(window, "resize", /*onwindowresize*/ ctx[18])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (/*show_options*/ ctx[2] && !/*disabled*/ ctx[3]) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*show_options, disabled*/ 12) {
						transition_in$3(if_block, 1);
					}
				} else {
					if_block = create_if_block$3(ctx);
					if_block.c();
					transition_in$3(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				group_outros$3();

				transition_out$3(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros$3();
			}
		},
		i(local) {
			transition_in$3(if_block);
		},
		o(local) {
			transition_out$3(if_block);
		},
		d(detaching) {
			if (detaching) {
				detach$3(div);
				detach$3(t);
				detach$3(if_block_anchor);
			}

			/*div_binding*/ ctx[19](null);
			if (if_block) if_block.d(detaching);
			mounted = false;
			run_all$2(dispose);
		}
	};
}

function instance$3($$self, $$props, $$invalidate) {
	let { choices } = $$props;
	let { filtered_indices } = $$props;
	let { show_options = false } = $$props;
	let { disabled = false } = $$props;
	let { selected_indices = [] } = $$props;
	let { active_index = null } = $$props;
	let distance_from_top;
	let distance_from_bottom;
	let input_height;
	let input_width;
	let refElement;
	let listElement;
	let top, bottom, max_height;
	let innerHeight;

	function calculate_window_distance() {
		const { top: ref_top, bottom: ref_bottom } = refElement.getBoundingClientRect();
		$$invalidate(15, distance_from_top = ref_top);
		$$invalidate(16, distance_from_bottom = innerHeight - ref_bottom);
	}

	let scroll_timeout = null;

	function scroll_listener() {
		if (!show_options) return;

		if (scroll_timeout !== null) {
			clearTimeout(scroll_timeout);
		}

		scroll_timeout = setTimeout(
			() => {
				calculate_window_distance();
				scroll_timeout = null;
			},
			10
		);
	}

	const dispatch = createEventDispatcher$2();

	function onwindowresize() {
		$$invalidate(12, innerHeight = window.innerHeight);
	}

	function div_binding($$value) {
		binding_callbacks$3[$$value ? 'unshift' : 'push'](() => {
			refElement = $$value;
			$$invalidate(6, refElement);
		});
	}

	const mousedown_handler = e => dispatch("change", e);

	function ul_binding($$value) {
		binding_callbacks$3[$$value ? 'unshift' : 'push'](() => {
			listElement = $$value;
			$$invalidate(7, listElement);
		});
	}

	$$self.$$set = $$props => {
		if ('choices' in $$props) $$invalidate(0, choices = $$props.choices);
		if ('filtered_indices' in $$props) $$invalidate(1, filtered_indices = $$props.filtered_indices);
		if ('show_options' in $$props) $$invalidate(2, show_options = $$props.show_options);
		if ('disabled' in $$props) $$invalidate(3, disabled = $$props.disabled);
		if ('selected_indices' in $$props) $$invalidate(4, selected_indices = $$props.selected_indices);
		if ('active_index' in $$props) $$invalidate(5, active_index = $$props.active_index);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*show_options, refElement, listElement, selected_indices, distance_from_bottom, distance_from_top, input_height*/ 229588) {
			{
				if (show_options && refElement) {
					if (listElement && selected_indices.length > 0) {
						let elements = listElement.querySelectorAll("li");

						for (const element of Array.from(elements)) {
							if (element.getAttribute("data-index") === selected_indices[0].toString()) {
								listElement?.scrollTo?.(0, element.offsetTop);
								break;
							}
						}
					}

					calculate_window_distance();
					const rect = refElement.parentElement?.getBoundingClientRect();
					$$invalidate(17, input_height = rect?.height || 0);
					$$invalidate(8, input_width = rect?.width || 0);
				}

				if (distance_from_bottom > distance_from_top) {
					$$invalidate(9, top = `${distance_from_top}px`);
					$$invalidate(11, max_height = distance_from_bottom);
					$$invalidate(10, bottom = null);
				} else {
					$$invalidate(10, bottom = `${distance_from_bottom + input_height}px`);
					$$invalidate(11, max_height = distance_from_top - input_height);
					$$invalidate(9, top = null);
				}
			}
		}
	};

	return [
		choices,
		filtered_indices,
		show_options,
		disabled,
		selected_indices,
		active_index,
		refElement,
		listElement,
		input_width,
		top,
		bottom,
		max_height,
		innerHeight,
		scroll_listener,
		dispatch,
		distance_from_top,
		distance_from_bottom,
		input_height,
		onwindowresize,
		div_binding,
		mousedown_handler,
		ul_binding
	];
}

class DropdownOptions extends SvelteComponent$3 {
	constructor(options) {
		super();

		init$3(this, options, instance$3, create_fragment$3, safe_not_equal$3, {
			choices: 0,
			filtered_indices: 1,
			show_options: 2,
			disabled: 3,
			selected_indices: 4,
			active_index: 5
		});
	}
}

function positive_mod(n, m) {
  return (n % m + m) % m;
}
function handle_filter(choices, input_text) {
  return choices.reduce((filtered_indices, o, index) => {
    if (input_text ? o[0].toLowerCase().includes(input_text.toLowerCase()) : true) {
      filtered_indices.push(index);
    }
    return filtered_indices;
  }, []);
}
function handle_change(dispatch, value, value_is_output) {
  dispatch("change", value);
  if (!value_is_output) {
    dispatch("input");
  }
}
function handle_shared_keys(e, active_index, filtered_indices) {
  if (e.key === "Escape") {
    return [false, active_index];
  }
  if (e.key === "ArrowDown" || e.key === "ArrowUp") {
    if (filtered_indices.length >= 0) {
      if (active_index === null) {
        active_index = e.key === "ArrowDown" ? filtered_indices[0] : filtered_indices[filtered_indices.length - 1];
      } else {
        const index_in_filtered = filtered_indices.indexOf(active_index);
        const increment = e.key === "ArrowUp" ? -1 : 1;
        active_index = filtered_indices[positive_mod(index_in_filtered + increment, filtered_indices.length)];
      }
    }
  }
  return [true, active_index];
}

const Multiselect_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/dropdown/shared/Multiselect.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$2,
	append: append$1,
	attr: attr$1,
	binding_callbacks: binding_callbacks$2,
	check_outros: check_outros$2,
	create_component: create_component$2,
	destroy_component: destroy_component$2,
	destroy_each,
	detach: detach$2,
	element: element$1,
	ensure_array_like,
	group_outros: group_outros$2,
	init: init$2,
	insert: insert$2,
	listen: listen$1,
	mount_component: mount_component$2,
	prevent_default,
	run_all: run_all$1,
	safe_not_equal: safe_not_equal$2,
	set_data: set_data$1,
	set_input_value: set_input_value$1,
	space: space$2,
	text: text$1,
	toggle_class: toggle_class$1,
	transition_in: transition_in$2,
	transition_out: transition_out$2
} = window.__gradio__svelte__internal;
const { afterUpdate: afterUpdate$1, createEventDispatcher: createEventDispatcher$1 } = window.__gradio__svelte__internal;
function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[40] = list[i];
	return child_ctx;
}

// (184:1) <BlockTitle {show_label} {info}>
function create_default_slot$2(ctx) {
	let t;

	return {
		c() {
			t = text$1(/*label*/ ctx[0]);
		},
		m(target, anchor) {
			insert$2(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*label*/ 1) set_data$1(t, /*label*/ ctx[0]);
		},
		d(detaching) {
			if (detaching) {
				detach$2(t);
			}
		}
	};
}

// (193:6) {:else}
function create_else_block$1(ctx) {
	let t_value = /*s*/ ctx[40] + "";
	let t;

	return {
		c() {
			t = text$1(t_value);
		},
		m(target, anchor) {
			insert$2(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*selected_indices*/ 4096 && t_value !== (t_value = /*s*/ ctx[40] + "")) set_data$1(t, t_value);
		},
		d(detaching) {
			if (detaching) {
				detach$2(t);
			}
		}
	};
}

// (191:6) {#if typeof s === "number"}
function create_if_block_3(ctx) {
	let t_value = /*choices_names*/ ctx[15][/*s*/ ctx[40]] + "";
	let t;

	return {
		c() {
			t = text$1(t_value);
		},
		m(target, anchor) {
			insert$2(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*choices_names, selected_indices*/ 36864 && t_value !== (t_value = /*choices_names*/ ctx[15][/*s*/ ctx[40]] + "")) set_data$1(t, t_value);
		},
		d(detaching) {
			if (detaching) {
				detach$2(t);
			}
		}
	};
}

// (197:5) {#if !disabled}
function create_if_block_2(ctx) {
	let div;
	let remove;
	let div_title_value;
	let current;
	let mounted;
	let dispose;
	remove = new Remove({});

	function click_handler() {
		return /*click_handler*/ ctx[31](/*s*/ ctx[40]);
	}

	function keydown_handler(...args) {
		return /*keydown_handler*/ ctx[32](/*s*/ ctx[40], ...args);
	}

	return {
		c() {
			div = element$1("div");
			create_component$2(remove.$$.fragment);
			attr$1(div, "class", "token-remove svelte-j8ht98");
			attr$1(div, "role", "button");
			attr$1(div, "tabindex", "0");
			attr$1(div, "title", div_title_value = /*i18n*/ ctx[9]("common.remove") + " " + /*s*/ ctx[40]);
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			mount_component$2(remove, div, null);
			current = true;

			if (!mounted) {
				dispose = [
					listen$1(div, "click", prevent_default(click_handler)),
					listen$1(div, "keydown", prevent_default(keydown_handler))
				];

				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (!current || dirty[0] & /*i18n, selected_indices*/ 4608 && div_title_value !== (div_title_value = /*i18n*/ ctx[9]("common.remove") + " " + /*s*/ ctx[40])) {
				attr$1(div, "title", div_title_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(remove.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(remove.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
			}

			destroy_component$2(remove);
			mounted = false;
			run_all$1(dispose);
		}
	};
}

// (188:3) {#each selected_indices as s}
function create_each_block(ctx) {
	let div;
	let span;
	let t;
	let current;

	function select_block_type(ctx, dirty) {
		if (typeof /*s*/ ctx[40] === "number") return create_if_block_3;
		return create_else_block$1;
	}

	let current_block_type = select_block_type(ctx);
	let if_block0 = current_block_type(ctx);
	let if_block1 = !/*disabled*/ ctx[4] && create_if_block_2(ctx);

	return {
		c() {
			div = element$1("div");
			span = element$1("span");
			if_block0.c();
			t = space$2();
			if (if_block1) if_block1.c();
			attr$1(span, "class", "svelte-j8ht98");
			attr$1(div, "class", "token svelte-j8ht98");
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			append$1(div, span);
			if_block0.m(span, null);
			append$1(div, t);
			if (if_block1) if_block1.m(div, null);
			current = true;
		},
		p(ctx, dirty) {
			if (current_block_type === (current_block_type = select_block_type(ctx)) && if_block0) {
				if_block0.p(ctx, dirty);
			} else {
				if_block0.d(1);
				if_block0 = current_block_type(ctx);

				if (if_block0) {
					if_block0.c();
					if_block0.m(span, null);
				}
			}

			if (!/*disabled*/ ctx[4]) {
				if (if_block1) {
					if_block1.p(ctx, dirty);

					if (dirty[0] & /*disabled*/ 16) {
						transition_in$2(if_block1, 1);
					}
				} else {
					if_block1 = create_if_block_2(ctx);
					if_block1.c();
					transition_in$2(if_block1, 1);
					if_block1.m(div, null);
				}
			} else if (if_block1) {
				group_outros$2();

				transition_out$2(if_block1, 1, 1, () => {
					if_block1 = null;
				});

				check_outros$2();
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(if_block1);
			current = true;
		},
		o(local) {
			transition_out$2(if_block1);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
			}

			if_block0.d();
			if (if_block1) if_block1.d();
		}
	};
}

// (236:4) {#if !disabled}
function create_if_block$2(ctx) {
	let t;
	let span;
	let dropdownarrow;
	let current;
	let if_block = /*selected_indices*/ ctx[12].length > 0 && create_if_block_1(ctx);
	dropdownarrow = new DropdownArrow({});

	return {
		c() {
			if (if_block) if_block.c();
			t = space$2();
			span = element$1("span");
			create_component$2(dropdownarrow.$$.fragment);
			attr$1(span, "class", "icon-wrap svelte-j8ht98");
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert$2(target, t, anchor);
			insert$2(target, span, anchor);
			mount_component$2(dropdownarrow, span, null);
			current = true;
		},
		p(ctx, dirty) {
			if (/*selected_indices*/ ctx[12].length > 0) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty[0] & /*selected_indices*/ 4096) {
						transition_in$2(if_block, 1);
					}
				} else {
					if_block = create_if_block_1(ctx);
					if_block.c();
					transition_in$2(if_block, 1);
					if_block.m(t.parentNode, t);
				}
			} else if (if_block) {
				group_outros$2();

				transition_out$2(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros$2();
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(if_block);
			transition_in$2(dropdownarrow.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(if_block);
			transition_out$2(dropdownarrow.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(t);
				detach$2(span);
			}

			if (if_block) if_block.d(detaching);
			destroy_component$2(dropdownarrow);
		}
	};
}

// (237:5) {#if selected_indices.length > 0}
function create_if_block_1(ctx) {
	let div;
	let remove;
	let div_title_value;
	let current;
	let mounted;
	let dispose;
	remove = new Remove({});

	return {
		c() {
			div = element$1("div");
			create_component$2(remove.$$.fragment);
			attr$1(div, "role", "button");
			attr$1(div, "tabindex", "0");
			attr$1(div, "class", "token-remove remove-all svelte-j8ht98");
			attr$1(div, "title", div_title_value = /*i18n*/ ctx[9]("common.clear"));
		},
		m(target, anchor) {
			insert$2(target, div, anchor);
			mount_component$2(remove, div, null);
			current = true;

			if (!mounted) {
				dispose = [
					listen$1(div, "click", /*remove_all*/ ctx[21]),
					listen$1(div, "keydown", /*keydown_handler_1*/ ctx[36])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (!current || dirty[0] & /*i18n*/ 512 && div_title_value !== (div_title_value = /*i18n*/ ctx[9]("common.clear"))) {
				attr$1(div, "title", div_title_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(remove.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(remove.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(div);
			}

			destroy_component$2(remove);
			mounted = false;
			run_all$1(dispose);
		}
	};
}

function create_fragment$2(ctx) {
	let label_1;
	let blocktitle;
	let t0;
	let div2;
	let div1;
	let t1;
	let div0;
	let input;
	let input_readonly_value;
	let t2;
	let t3;
	let dropdownoptions;
	let current;
	let mounted;
	let dispose;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[5],
				info: /*info*/ ctx[1],
				$$slots: { default: [create_default_slot$2] },
				$$scope: { ctx }
			}
		});

	let each_value = ensure_array_like(/*selected_indices*/ ctx[12]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	const out = i => transition_out$2(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	let if_block = !/*disabled*/ ctx[4] && create_if_block$2(ctx);

	dropdownoptions = new DropdownOptions({
			props: {
				show_options: /*show_options*/ ctx[14],
				choices: /*choices*/ ctx[3],
				filtered_indices: /*filtered_indices*/ ctx[11],
				disabled: /*disabled*/ ctx[4],
				selected_indices: /*selected_indices*/ ctx[12],
				active_index: /*active_index*/ ctx[16]
			}
		});

	dropdownoptions.$on("change", /*handle_option_selected*/ ctx[20]);

	return {
		c() {
			label_1 = element$1("label");
			create_component$2(blocktitle.$$.fragment);
			t0 = space$2();
			div2 = element$1("div");
			div1 = element$1("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t1 = space$2();
			div0 = element$1("div");
			input = element$1("input");
			t2 = space$2();
			if (if_block) if_block.c();
			t3 = space$2();
			create_component$2(dropdownoptions.$$.fragment);
			attr$1(input, "class", "border-none svelte-j8ht98");
			input.disabled = /*disabled*/ ctx[4];
			attr$1(input, "autocomplete", "off");
			input.readOnly = input_readonly_value = !/*filterable*/ ctx[8];
			toggle_class$1(input, "subdued", !/*choices_names*/ ctx[15].includes(/*input_text*/ ctx[10]) && !/*allow_custom_value*/ ctx[7] || /*selected_indices*/ ctx[12].length === /*max_choices*/ ctx[2]);
			attr$1(div0, "class", "secondary-wrap svelte-j8ht98");
			attr$1(div1, "class", "wrap-inner svelte-j8ht98");
			toggle_class$1(div1, "show_options", /*show_options*/ ctx[14]);
			attr$1(div2, "class", "wrap svelte-j8ht98");
			attr$1(label_1, "class", "svelte-j8ht98");
			toggle_class$1(label_1, "container", /*container*/ ctx[6]);
		},
		m(target, anchor) {
			insert$2(target, label_1, anchor);
			mount_component$2(blocktitle, label_1, null);
			append$1(label_1, t0);
			append$1(label_1, div2);
			append$1(div2, div1);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(div1, null);
				}
			}

			append$1(div1, t1);
			append$1(div1, div0);
			append$1(div0, input);
			set_input_value$1(input, /*input_text*/ ctx[10]);
			/*input_binding*/ ctx[34](input);
			append$1(div0, t2);
			if (if_block) if_block.m(div0, null);
			append$1(div2, t3);
			mount_component$2(dropdownoptions, div2, null);
			current = true;

			if (!mounted) {
				dispose = [
					listen$1(input, "input", /*input_input_handler*/ ctx[33]),
					listen$1(input, "keydown", /*handle_key_down*/ ctx[23]),
					listen$1(input, "keyup", /*keyup_handler*/ ctx[35]),
					listen$1(input, "blur", /*handle_blur*/ ctx[18]),
					listen$1(input, "focus", /*handle_focus*/ ctx[22])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			const blocktitle_changes = {};
			if (dirty[0] & /*show_label*/ 32) blocktitle_changes.show_label = /*show_label*/ ctx[5];
			if (dirty[0] & /*info*/ 2) blocktitle_changes.info = /*info*/ ctx[1];

			if (dirty[0] & /*label*/ 1 | dirty[1] & /*$$scope*/ 4096) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);

			if (dirty[0] & /*i18n, selected_indices, remove_selected_choice, disabled, choices_names*/ 561680) {
				each_value = ensure_array_like(/*selected_indices*/ ctx[12]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in$2(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						transition_in$2(each_blocks[i], 1);
						each_blocks[i].m(div1, t1);
					}
				}

				group_outros$2();

				for (i = each_value.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros$2();
			}

			if (!current || dirty[0] & /*disabled*/ 16) {
				input.disabled = /*disabled*/ ctx[4];
			}

			if (!current || dirty[0] & /*filterable*/ 256 && input_readonly_value !== (input_readonly_value = !/*filterable*/ ctx[8])) {
				input.readOnly = input_readonly_value;
			}

			if (dirty[0] & /*input_text*/ 1024 && input.value !== /*input_text*/ ctx[10]) {
				set_input_value$1(input, /*input_text*/ ctx[10]);
			}

			if (!current || dirty[0] & /*choices_names, input_text, allow_custom_value, selected_indices, max_choices*/ 38020) {
				toggle_class$1(input, "subdued", !/*choices_names*/ ctx[15].includes(/*input_text*/ ctx[10]) && !/*allow_custom_value*/ ctx[7] || /*selected_indices*/ ctx[12].length === /*max_choices*/ ctx[2]);
			}

			if (!/*disabled*/ ctx[4]) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty[0] & /*disabled*/ 16) {
						transition_in$2(if_block, 1);
					}
				} else {
					if_block = create_if_block$2(ctx);
					if_block.c();
					transition_in$2(if_block, 1);
					if_block.m(div0, null);
				}
			} else if (if_block) {
				group_outros$2();

				transition_out$2(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros$2();
			}

			if (!current || dirty[0] & /*show_options*/ 16384) {
				toggle_class$1(div1, "show_options", /*show_options*/ ctx[14]);
			}

			const dropdownoptions_changes = {};
			if (dirty[0] & /*show_options*/ 16384) dropdownoptions_changes.show_options = /*show_options*/ ctx[14];
			if (dirty[0] & /*choices*/ 8) dropdownoptions_changes.choices = /*choices*/ ctx[3];
			if (dirty[0] & /*filtered_indices*/ 2048) dropdownoptions_changes.filtered_indices = /*filtered_indices*/ ctx[11];
			if (dirty[0] & /*disabled*/ 16) dropdownoptions_changes.disabled = /*disabled*/ ctx[4];
			if (dirty[0] & /*selected_indices*/ 4096) dropdownoptions_changes.selected_indices = /*selected_indices*/ ctx[12];
			if (dirty[0] & /*active_index*/ 65536) dropdownoptions_changes.active_index = /*active_index*/ ctx[16];
			dropdownoptions.$set(dropdownoptions_changes);

			if (!current || dirty[0] & /*container*/ 64) {
				toggle_class$1(label_1, "container", /*container*/ ctx[6]);
			}
		},
		i(local) {
			if (current) return;
			transition_in$2(blocktitle.$$.fragment, local);

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in$2(each_blocks[i]);
			}

			transition_in$2(if_block);
			transition_in$2(dropdownoptions.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$2(blocktitle.$$.fragment, local);
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out$2(each_blocks[i]);
			}

			transition_out$2(if_block);
			transition_out$2(dropdownoptions.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$2(label_1);
			}

			destroy_component$2(blocktitle);
			destroy_each(each_blocks, detaching);
			/*input_binding*/ ctx[34](null);
			if (if_block) if_block.d();
			destroy_component$2(dropdownoptions);
			mounted = false;
			run_all$1(dispose);
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let { label } = $$props;
	let { info = undefined } = $$props;
	let { value = [] } = $$props;
	let old_value = [];
	let { value_is_output = false } = $$props;
	let { max_choices = null } = $$props;
	let { choices } = $$props;
	let old_choices;
	let { disabled = false } = $$props;
	let { show_label } = $$props;
	let { container = true } = $$props;
	let { allow_custom_value = false } = $$props;
	let { filterable = true } = $$props;
	let { i18n } = $$props;
	let filter_input;
	let input_text = "";
	let old_input_text = "";
	let show_options = false;
	let choices_names;
	let choices_values;

	// All of these are indices with respect to the choices array
	let filtered_indices = [];

	let active_index = null;

	// selected_index consists of indices from choices or strings if allow_custom_value is true and user types in a custom value
	let selected_indices = [];

	let old_selected_index = [];
	const dispatch = createEventDispatcher$1();

	// Setting the initial value of the multiselect dropdown
	if (Array.isArray(value)) {
		value.forEach(element => {
			const index = choices.map(c => c[1]).indexOf(element);

			if (index !== -1) {
				selected_indices.push(index);
			} else {
				selected_indices.push(element);
			}
		});
	}

	function handle_blur() {
		if (!allow_custom_value) {
			$$invalidate(10, input_text = "");
		}

		if (allow_custom_value && input_text !== "") {
			add_selected_choice(input_text);
			$$invalidate(10, input_text = "");
		}

		$$invalidate(14, show_options = false);
		$$invalidate(16, active_index = null);
		dispatch("blur");
	}

	function remove_selected_choice(option_index) {
		$$invalidate(12, selected_indices = selected_indices.filter(v => v !== option_index));

		dispatch("select", {
			index: typeof option_index === "number" ? option_index : -1,
			value: typeof option_index === "number"
			? choices_values[option_index]
			: option_index,
			selected: false
		});
	}

	function add_selected_choice(option_index) {
		if (max_choices === null || selected_indices.length < max_choices) {
			$$invalidate(12, selected_indices = [...selected_indices, option_index]);

			dispatch("select", {
				index: typeof option_index === "number" ? option_index : -1,
				value: typeof option_index === "number"
				? choices_values[option_index]
				: option_index,
				selected: true
			});
		}

		if (selected_indices.length === max_choices) {
			$$invalidate(14, show_options = false);
			$$invalidate(16, active_index = null);
			filter_input.blur();
		}
	}

	function handle_option_selected(e) {
		const option_index = parseInt(e.detail.target.dataset.index);
		add_or_remove_index(option_index);
	}

	function add_or_remove_index(option_index) {
		if (selected_indices.includes(option_index)) {
			remove_selected_choice(option_index);
		} else {
			add_selected_choice(option_index);
		}

		$$invalidate(10, input_text = "");
	}

	function remove_all(e) {
		$$invalidate(12, selected_indices = []);
		$$invalidate(10, input_text = "");
		e.preventDefault();
	}

	function handle_focus(e) {
		$$invalidate(11, filtered_indices = choices.map((_, i) => i));

		if (max_choices === null || selected_indices.length < max_choices) {
			$$invalidate(14, show_options = true);
		}

		dispatch("focus");
	}

	function handle_key_down(e) {
		$$invalidate(14, [show_options, active_index] = handle_shared_keys(e, active_index, filtered_indices), show_options, (((((($$invalidate(16, active_index), $$invalidate(3, choices)), $$invalidate(27, old_choices)), $$invalidate(10, input_text)), $$invalidate(28, old_input_text)), $$invalidate(7, allow_custom_value)), $$invalidate(11, filtered_indices)));

		if (e.key === "Enter") {
			if (active_index !== null) {
				add_or_remove_index(active_index);
			} else {
				if (allow_custom_value) {
					add_selected_choice(input_text);
					$$invalidate(10, input_text = "");
				}
			}
		}

		if (e.key === "Backspace" && input_text === "") {
			$$invalidate(12, selected_indices = [...selected_indices.slice(0, -1)]);
		}

		if (selected_indices.length === max_choices) {
			$$invalidate(14, show_options = false);
			$$invalidate(16, active_index = null);
		}
	}

	function set_selected_indices() {
		if (value === undefined) {
			$$invalidate(12, selected_indices = []);
		} else if (Array.isArray(value)) {
			$$invalidate(12, selected_indices = value.map(v => {
				const index = choices_values.indexOf(v);

				if (index !== -1) {
					return index;
				}

				if (allow_custom_value) {
					return v;
				}

				// Instead of returning null, skip this iteration
				return undefined;
			}).filter(val => val !== undefined));
		}
	}

	afterUpdate$1(() => {
		$$invalidate(25, value_is_output = false);
	});

	const click_handler = s => remove_selected_choice(s);

	const keydown_handler = (s, event) => {
		if (event.key === "Enter") {
			remove_selected_choice(s);
		}
	};

	function input_input_handler() {
		input_text = this.value;
		$$invalidate(10, input_text);
	}

	function input_binding($$value) {
		binding_callbacks$2[$$value ? 'unshift' : 'push'](() => {
			filter_input = $$value;
			$$invalidate(13, filter_input);
		});
	}

	const keyup_handler = e => dispatch("key_up", { key: e.key, input_value: input_text });

	const keydown_handler_1 = event => {
		if (event.key === "Enter") {
			remove_all(event);
		}
	};

	$$self.$$set = $$props => {
		if ('label' in $$props) $$invalidate(0, label = $$props.label);
		if ('info' in $$props) $$invalidate(1, info = $$props.info);
		if ('value' in $$props) $$invalidate(24, value = $$props.value);
		if ('value_is_output' in $$props) $$invalidate(25, value_is_output = $$props.value_is_output);
		if ('max_choices' in $$props) $$invalidate(2, max_choices = $$props.max_choices);
		if ('choices' in $$props) $$invalidate(3, choices = $$props.choices);
		if ('disabled' in $$props) $$invalidate(4, disabled = $$props.disabled);
		if ('show_label' in $$props) $$invalidate(5, show_label = $$props.show_label);
		if ('container' in $$props) $$invalidate(6, container = $$props.container);
		if ('allow_custom_value' in $$props) $$invalidate(7, allow_custom_value = $$props.allow_custom_value);
		if ('filterable' in $$props) $$invalidate(8, filterable = $$props.filterable);
		if ('i18n' in $$props) $$invalidate(9, i18n = $$props.i18n);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*choices*/ 8) {
			{
				$$invalidate(15, choices_names = choices.map(c => c[0]));
				$$invalidate(29, choices_values = choices.map(c => c[1]));
			}
		}

		if ($$self.$$.dirty[0] & /*choices, old_choices, input_text, old_input_text, allow_custom_value, filtered_indices*/ 402656392) {
			{
				if (choices !== old_choices || input_text !== old_input_text) {
					$$invalidate(11, filtered_indices = handle_filter(choices, input_text));
					$$invalidate(27, old_choices = choices);
					$$invalidate(28, old_input_text = input_text);

					if (!allow_custom_value) {
						$$invalidate(16, active_index = filtered_indices[0]);
					}
				}
			}
		}

		if ($$self.$$.dirty[0] & /*selected_indices, old_selected_index, choices_values*/ 1610616832) {
			{
				if (JSON.stringify(selected_indices) != JSON.stringify(old_selected_index)) {
					$$invalidate(24, value = selected_indices.map(index => typeof index === "number"
					? choices_values[index]
					: index));

					$$invalidate(30, old_selected_index = selected_indices.slice());
				}
			}
		}

		if ($$self.$$.dirty[0] & /*value, old_value, value_is_output*/ 117440512) {
			{
				if (JSON.stringify(value) != JSON.stringify(old_value)) {
					handle_change(dispatch, value, value_is_output);
					$$invalidate(26, old_value = Array.isArray(value) ? value.slice() : value);
				}
			}
		}

		if ($$self.$$.dirty[0] & /*value*/ 16777216) {
			(set_selected_indices());
		}
	};

	return [
		label,
		info,
		max_choices,
		choices,
		disabled,
		show_label,
		container,
		allow_custom_value,
		filterable,
		i18n,
		input_text,
		filtered_indices,
		selected_indices,
		filter_input,
		show_options,
		choices_names,
		active_index,
		dispatch,
		handle_blur,
		remove_selected_choice,
		handle_option_selected,
		remove_all,
		handle_focus,
		handle_key_down,
		value,
		value_is_output,
		old_value,
		old_choices,
		old_input_text,
		choices_values,
		old_selected_index,
		click_handler,
		keydown_handler,
		input_input_handler,
		input_binding,
		keyup_handler,
		keydown_handler_1
	];
}

class Multiselect extends SvelteComponent$2 {
	constructor(options) {
		super();

		init$2(
			this,
			options,
			instance$2,
			create_fragment$2,
			safe_not_equal$2,
			{
				label: 0,
				info: 1,
				value: 24,
				value_is_output: 25,
				max_choices: 2,
				choices: 3,
				disabled: 4,
				show_label: 5,
				container: 6,
				allow_custom_value: 7,
				filterable: 8,
				i18n: 9
			},
			null,
			[-1, -1]
		);
	}
}

const Multiselect$1 = Multiselect;

const Dropdown_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/dropdown/shared/Dropdown.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$1,
	append,
	attr,
	binding_callbacks: binding_callbacks$1,
	check_outros: check_outros$1,
	create_component: create_component$1,
	destroy_component: destroy_component$1,
	detach: detach$1,
	element,
	group_outros: group_outros$1,
	init: init$1,
	insert: insert$1,
	listen,
	mount_component: mount_component$1,
	run_all,
	safe_not_equal: safe_not_equal$1,
	set_data,
	set_input_value,
	space: space$1,
	text,
	toggle_class,
	transition_in: transition_in$1,
	transition_out: transition_out$1
} = window.__gradio__svelte__internal;const { createEventDispatcher, afterUpdate } = window.__gradio__svelte__internal;
function create_default_slot$1(ctx) {
	let t;

	return {
		c() {
			t = text(/*label*/ ctx[0]);
		},
		m(target, anchor) {
			insert$1(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty[0] & /*label*/ 1) set_data(t, /*label*/ ctx[0]);
		},
		d(detaching) {
			if (detaching) {
				detach$1(t);
			}
		}
	};
}

// (207:4) {#if !disabled}
function create_if_block$1(ctx) {
	let div;
	let dropdownarrow;
	let current;
	dropdownarrow = new DropdownArrow({});

	return {
		c() {
			div = element("div");
			create_component$1(dropdownarrow.$$.fragment);
			attr(div, "class", "icon-wrap svelte-vomtxz");
		},
		m(target, anchor) {
			insert$1(target, div, anchor);
			mount_component$1(dropdownarrow, div, null);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in$1(dropdownarrow.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(dropdownarrow.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(div);
			}

			destroy_component$1(dropdownarrow);
		}
	};
}

function create_fragment$1(ctx) {
	let div3;
	let blocktitle;
	let t0;
	let div2;
	let div1;
	let div0;
	let input;
	let input_readonly_value;
	let t1;
	let t2;
	let dropdownoptions;
	let current;
	let mounted;
	let dispose;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[4],
				info: /*info*/ ctx[1],
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			}
		});

	let if_block = !/*disabled*/ ctx[3] && create_if_block$1();

	dropdownoptions = new DropdownOptions({
			props: {
				show_options: /*show_options*/ ctx[12],
				choices: /*choices*/ ctx[2],
				filtered_indices: /*filtered_indices*/ ctx[10],
				disabled: /*disabled*/ ctx[3],
				selected_indices: /*selected_index*/ ctx[11] === null
				? []
				: [/*selected_index*/ ctx[11]],
				active_index: /*active_index*/ ctx[14]
			}
		});

	dropdownoptions.$on("change", /*handle_option_selected*/ ctx[16]);

	return {
		c() {
			div3 = element("div");
			create_component$1(blocktitle.$$.fragment);
			t0 = space$1();
			div2 = element("div");
			div1 = element("div");
			div0 = element("div");
			input = element("input");
			t1 = space$1();
			if (if_block) if_block.c();
			t2 = space$1();
			create_component$1(dropdownoptions.$$.fragment);
			attr(input, "role", "listbox");
			attr(input, "aria-controls", "dropdown-options");
			attr(input, "aria-expanded", /*show_options*/ ctx[12]);
			attr(input, "aria-label", /*label*/ ctx[0]);
			attr(input, "class", "border-none svelte-vomtxz");
			input.disabled = /*disabled*/ ctx[3];
			attr(input, "autocomplete", "off");
			input.readOnly = input_readonly_value = !/*filterable*/ ctx[7];
			toggle_class(input, "subdued", !/*choices_names*/ ctx[13].includes(/*input_text*/ ctx[9]) && !/*allow_custom_value*/ ctx[6]);
			attr(div0, "class", "secondary-wrap svelte-vomtxz");
			attr(div1, "class", "wrap-inner svelte-vomtxz");
			toggle_class(div1, "show_options", /*show_options*/ ctx[12]);
			attr(div2, "class", "wrap svelte-vomtxz");
			attr(div3, "class", "svelte-vomtxz");
			toggle_class(div3, "container", /*container*/ ctx[5]);
		},
		m(target, anchor) {
			insert$1(target, div3, anchor);
			mount_component$1(blocktitle, div3, null);
			append(div3, t0);
			append(div3, div2);
			append(div2, div1);
			append(div1, div0);
			append(div0, input);
			set_input_value(input, /*input_text*/ ctx[9]);
			/*input_binding*/ ctx[29](input);
			append(div0, t1);
			if (if_block) if_block.m(div0, null);
			append(div2, t2);
			mount_component$1(dropdownoptions, div2, null);
			current = true;

			if (!mounted) {
				dispose = [
					listen(input, "input", /*input_input_handler*/ ctx[28]),
					listen(input, "keydown", /*handle_key_down*/ ctx[19]),
					listen(input, "keyup", /*keyup_handler*/ ctx[30]),
					listen(input, "blur", /*handle_blur*/ ctx[18]),
					listen(input, "focus", /*handle_focus*/ ctx[17])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			const blocktitle_changes = {};
			if (dirty[0] & /*show_label*/ 16) blocktitle_changes.show_label = /*show_label*/ ctx[4];
			if (dirty[0] & /*info*/ 2) blocktitle_changes.info = /*info*/ ctx[1];

			if (dirty[0] & /*label*/ 1 | dirty[1] & /*$$scope*/ 4) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);

			if (!current || dirty[0] & /*show_options*/ 4096) {
				attr(input, "aria-expanded", /*show_options*/ ctx[12]);
			}

			if (!current || dirty[0] & /*label*/ 1) {
				attr(input, "aria-label", /*label*/ ctx[0]);
			}

			if (!current || dirty[0] & /*disabled*/ 8) {
				input.disabled = /*disabled*/ ctx[3];
			}

			if (!current || dirty[0] & /*filterable*/ 128 && input_readonly_value !== (input_readonly_value = !/*filterable*/ ctx[7])) {
				input.readOnly = input_readonly_value;
			}

			if (dirty[0] & /*input_text*/ 512 && input.value !== /*input_text*/ ctx[9]) {
				set_input_value(input, /*input_text*/ ctx[9]);
			}

			if (!current || dirty[0] & /*choices_names, input_text, allow_custom_value*/ 8768) {
				toggle_class(input, "subdued", !/*choices_names*/ ctx[13].includes(/*input_text*/ ctx[9]) && !/*allow_custom_value*/ ctx[6]);
			}

			if (!/*disabled*/ ctx[3]) {
				if (if_block) {
					if (dirty[0] & /*disabled*/ 8) {
						transition_in$1(if_block, 1);
					}
				} else {
					if_block = create_if_block$1();
					if_block.c();
					transition_in$1(if_block, 1);
					if_block.m(div0, null);
				}
			} else if (if_block) {
				group_outros$1();

				transition_out$1(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros$1();
			}

			if (!current || dirty[0] & /*show_options*/ 4096) {
				toggle_class(div1, "show_options", /*show_options*/ ctx[12]);
			}

			const dropdownoptions_changes = {};
			if (dirty[0] & /*show_options*/ 4096) dropdownoptions_changes.show_options = /*show_options*/ ctx[12];
			if (dirty[0] & /*choices*/ 4) dropdownoptions_changes.choices = /*choices*/ ctx[2];
			if (dirty[0] & /*filtered_indices*/ 1024) dropdownoptions_changes.filtered_indices = /*filtered_indices*/ ctx[10];
			if (dirty[0] & /*disabled*/ 8) dropdownoptions_changes.disabled = /*disabled*/ ctx[3];

			if (dirty[0] & /*selected_index*/ 2048) dropdownoptions_changes.selected_indices = /*selected_index*/ ctx[11] === null
			? []
			: [/*selected_index*/ ctx[11]];

			if (dirty[0] & /*active_index*/ 16384) dropdownoptions_changes.active_index = /*active_index*/ ctx[14];
			dropdownoptions.$set(dropdownoptions_changes);

			if (!current || dirty[0] & /*container*/ 32) {
				toggle_class(div3, "container", /*container*/ ctx[5]);
			}
		},
		i(local) {
			if (current) return;
			transition_in$1(blocktitle.$$.fragment, local);
			transition_in$1(if_block);
			transition_in$1(dropdownoptions.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out$1(blocktitle.$$.fragment, local);
			transition_out$1(if_block);
			transition_out$1(dropdownoptions.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach$1(div3);
			}

			destroy_component$1(blocktitle);
			/*input_binding*/ ctx[29](null);
			if (if_block) if_block.d();
			destroy_component$1(dropdownoptions);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let { label } = $$props;
	let { info = undefined } = $$props;
	let { value = [] } = $$props;
	let old_value = [];
	let { value_is_output = false } = $$props;
	let { choices } = $$props;
	let old_choices;
	let { disabled = false } = $$props;
	let { show_label } = $$props;
	let { container = true } = $$props;
	let { allow_custom_value = false } = $$props;
	let { filterable = true } = $$props;
	let filter_input;
	let show_options = false;
	let choices_names;
	let choices_values;
	let input_text = "";
	let old_input_text = "";
	let initialized = false;

	// All of these are indices with respect to the choices array
	let filtered_indices = [];

	let active_index = null;

	// selected_index is null if allow_custom_value is true and the input_text is not in choices_names
	let selected_index = null;

	let old_selected_index;
	const dispatch = createEventDispatcher();

	// Setting the initial value of the dropdown
	if (value) {
		old_selected_index = choices.map(c => c[1]).indexOf(value);
		selected_index = old_selected_index;

		if (selected_index === -1) {
			old_value = value;
			selected_index = null;
		} else {
			[input_text, old_value] = choices[selected_index];
			old_input_text = input_text;
		}

		set_input_text();
	} else if (choices.length > 0) {
		old_selected_index = 0;
		selected_index = 0;
		[input_text, value] = choices[selected_index];
		old_value = value;
		old_input_text = input_text;
	}

	function set_choice_names_values() {
		$$invalidate(13, choices_names = choices.map(c => c[0]));
		$$invalidate(24, choices_values = choices.map(c => c[1]));
	}

	function set_input_text() {
		set_choice_names_values();

		if (value === undefined || Array.isArray(value) && value.length === 0) {
			$$invalidate(9, input_text = "");
			$$invalidate(11, selected_index = null);
		} else if (choices_values.includes(value)) {
			$$invalidate(9, input_text = choices_names[choices_values.indexOf(value)]);
			$$invalidate(11, selected_index = choices_values.indexOf(value));
		} else if (allow_custom_value) {
			$$invalidate(9, input_text = value);
			$$invalidate(11, selected_index = null);
		} else {
			$$invalidate(9, input_text = "");
			$$invalidate(11, selected_index = null);
		}

		$$invalidate(27, old_selected_index = selected_index);
	}

	function handle_option_selected(e) {
		$$invalidate(11, selected_index = parseInt(e.detail.target.dataset.index));

		if (isNaN(selected_index)) {
			// This is the case when the user clicks on the scrollbar
			$$invalidate(11, selected_index = null);

			return;
		}

		$$invalidate(12, show_options = false);
		$$invalidate(14, active_index = null);
		filter_input.blur();
	}

	function handle_focus(e) {
		$$invalidate(10, filtered_indices = choices.map((_, i) => i));
		$$invalidate(12, show_options = true);
		dispatch("focus");
	}

	function handle_blur() {
		if (!allow_custom_value) {
			$$invalidate(9, input_text = choices_names[choices_values.indexOf(value)]);
		} else {
			$$invalidate(20, value = input_text);
		}

		$$invalidate(12, show_options = false);
		$$invalidate(14, active_index = null);
		dispatch("blur");
	}

	function handle_key_down(e) {
		$$invalidate(12, [show_options, active_index] = handle_shared_keys(e, active_index, filtered_indices), show_options, ((((((((((($$invalidate(14, active_index), $$invalidate(2, choices)), $$invalidate(23, old_choices)), $$invalidate(6, allow_custom_value)), $$invalidate(9, input_text)), $$invalidate(10, filtered_indices)), $$invalidate(8, filter_input)), $$invalidate(25, old_input_text)), $$invalidate(11, selected_index)), $$invalidate(27, old_selected_index)), $$invalidate(26, initialized)), $$invalidate(24, choices_values)));

		if (e.key === "Enter") {
			if (active_index !== null) {
				$$invalidate(11, selected_index = active_index);
				$$invalidate(12, show_options = false);
				filter_input.blur();
				$$invalidate(14, active_index = null);
			} else if (choices_names.includes(input_text)) {
				$$invalidate(11, selected_index = choices_names.indexOf(input_text));
				$$invalidate(12, show_options = false);
				$$invalidate(14, active_index = null);
				filter_input.blur();
			} else if (allow_custom_value) {
				$$invalidate(20, value = input_text);
				$$invalidate(11, selected_index = null);
				$$invalidate(12, show_options = false);
				$$invalidate(14, active_index = null);
				filter_input.blur();
			}
		}
	}

	afterUpdate(() => {
		$$invalidate(21, value_is_output = false);
		$$invalidate(26, initialized = true);
	});

	function input_input_handler() {
		input_text = this.value;
		((((($$invalidate(9, input_text), $$invalidate(11, selected_index)), $$invalidate(27, old_selected_index)), $$invalidate(26, initialized)), $$invalidate(2, choices)), $$invalidate(24, choices_values));
	}

	function input_binding($$value) {
		binding_callbacks$1[$$value ? 'unshift' : 'push'](() => {
			filter_input = $$value;
			$$invalidate(8, filter_input);
		});
	}

	const keyup_handler = e => dispatch("key_up", { key: e.key, input_value: input_text });

	$$self.$$set = $$props => {
		if ('label' in $$props) $$invalidate(0, label = $$props.label);
		if ('info' in $$props) $$invalidate(1, info = $$props.info);
		if ('value' in $$props) $$invalidate(20, value = $$props.value);
		if ('value_is_output' in $$props) $$invalidate(21, value_is_output = $$props.value_is_output);
		if ('choices' in $$props) $$invalidate(2, choices = $$props.choices);
		if ('disabled' in $$props) $$invalidate(3, disabled = $$props.disabled);
		if ('show_label' in $$props) $$invalidate(4, show_label = $$props.show_label);
		if ('container' in $$props) $$invalidate(5, container = $$props.container);
		if ('allow_custom_value' in $$props) $$invalidate(6, allow_custom_value = $$props.allow_custom_value);
		if ('filterable' in $$props) $$invalidate(7, filterable = $$props.filterable);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*selected_index, old_selected_index, initialized, choices, choices_values*/ 218105860) {
			{
				if (selected_index !== old_selected_index && selected_index !== null && initialized) {
					$$invalidate(9, [input_text, value] = choices[selected_index], input_text, ((((($$invalidate(20, value), $$invalidate(11, selected_index)), $$invalidate(27, old_selected_index)), $$invalidate(26, initialized)), $$invalidate(2, choices)), $$invalidate(24, choices_values)));
					$$invalidate(27, old_selected_index = selected_index);

					dispatch("select", {
						index: selected_index,
						value: choices_values[selected_index],
						selected: true
					});
				}
			}
		}

		if ($$self.$$.dirty[0] & /*value, old_value, value_is_output*/ 7340032) {
			{
				if (value != old_value) {
					set_input_text();
					handle_change(dispatch, value, value_is_output);
					$$invalidate(22, old_value = value);
				}
			}
		}

		if ($$self.$$.dirty[0] & /*choices*/ 4) {
			(set_choice_names_values());
		}

		if ($$self.$$.dirty[0] & /*choices, old_choices, allow_custom_value, input_text, filtered_indices, filter_input*/ 8390468) {
			{
				if (choices !== old_choices) {
					if (!allow_custom_value) {
						set_input_text();
					}

					$$invalidate(23, old_choices = choices);
					$$invalidate(10, filtered_indices = handle_filter(choices, input_text));

					if (!allow_custom_value && filtered_indices.length > 0) {
						$$invalidate(14, active_index = filtered_indices[0]);
					}

					if (filter_input == document.activeElement) {
						$$invalidate(12, show_options = true);
					}
				}
			}
		}

		if ($$self.$$.dirty[0] & /*input_text, old_input_text, choices, allow_custom_value, filtered_indices*/ 33556036) {
			{
				if (input_text !== old_input_text) {
					$$invalidate(10, filtered_indices = handle_filter(choices, input_text));
					$$invalidate(25, old_input_text = input_text);

					if (!allow_custom_value && filtered_indices.length > 0) {
						$$invalidate(14, active_index = filtered_indices[0]);
					}
				}
			}
		}
	};

	return [
		label,
		info,
		choices,
		disabled,
		show_label,
		container,
		allow_custom_value,
		filterable,
		filter_input,
		input_text,
		filtered_indices,
		selected_index,
		show_options,
		choices_names,
		active_index,
		dispatch,
		handle_option_selected,
		handle_focus,
		handle_blur,
		handle_key_down,
		value,
		value_is_output,
		old_value,
		old_choices,
		choices_values,
		old_input_text,
		initialized,
		old_selected_index,
		input_input_handler,
		input_binding,
		keyup_handler
	];
}

class Dropdown extends SvelteComponent$1 {
	constructor(options) {
		super();

		init$1(
			this,
			options,
			instance$1,
			create_fragment$1,
			safe_not_equal$1,
			{
				label: 0,
				info: 1,
				value: 20,
				value_is_output: 21,
				choices: 2,
				disabled: 3,
				show_label: 4,
				container: 5,
				allow_custom_value: 6,
				filterable: 7
			},
			null,
			[-1, -1]
		);
	}
}

const Dropdown$1 = Dropdown;

/* home/runner/work/gradio/gradio/js/dropdown/Index.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent,
	add_flush_callback,
	assign,
	bind,
	binding_callbacks,
	check_outros,
	create_component,
	destroy_component,
	detach,
	empty,
	get_spread_object,
	get_spread_update,
	group_outros,
	init,
	insert,
	mount_component,
	safe_not_equal,
	space,
	transition_in,
	transition_out
} = window.__gradio__svelte__internal;
function create_else_block(ctx) {
	let dropdown;
	let updating_value;
	let updating_value_is_output;
	let current;

	function dropdown_value_binding(value) {
		/*dropdown_value_binding*/ ctx[27](value);
	}

	function dropdown_value_is_output_binding(value) {
		/*dropdown_value_is_output_binding*/ ctx[28](value);
	}

	let dropdown_props = {
		choices: /*choices*/ ctx[9],
		label: /*label*/ ctx[2],
		info: /*info*/ ctx[3],
		show_label: /*show_label*/ ctx[10],
		filterable: /*filterable*/ ctx[11],
		allow_custom_value: /*allow_custom_value*/ ctx[16],
		container: /*container*/ ctx[12],
		disabled: !/*interactive*/ ctx[18]
	};

	if (/*value*/ ctx[0] !== void 0) {
		dropdown_props.value = /*value*/ ctx[0];
	}

	if (/*value_is_output*/ ctx[1] !== void 0) {
		dropdown_props.value_is_output = /*value_is_output*/ ctx[1];
	}

	dropdown = new Dropdown$1({ props: dropdown_props });
	binding_callbacks.push(() => bind(dropdown, 'value', dropdown_value_binding));
	binding_callbacks.push(() => bind(dropdown, 'value_is_output', dropdown_value_is_output_binding));
	dropdown.$on("change", /*change_handler_1*/ ctx[29]);
	dropdown.$on("input", /*input_handler_1*/ ctx[30]);
	dropdown.$on("select", /*select_handler_1*/ ctx[31]);
	dropdown.$on("blur", /*blur_handler_1*/ ctx[32]);
	dropdown.$on("focus", /*focus_handler_1*/ ctx[33]);
	dropdown.$on("key_up", /*key_up_handler_1*/ ctx[34]);

	return {
		c() {
			create_component(dropdown.$$.fragment);
		},
		m(target, anchor) {
			mount_component(dropdown, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const dropdown_changes = {};
			if (dirty[0] & /*choices*/ 512) dropdown_changes.choices = /*choices*/ ctx[9];
			if (dirty[0] & /*label*/ 4) dropdown_changes.label = /*label*/ ctx[2];
			if (dirty[0] & /*info*/ 8) dropdown_changes.info = /*info*/ ctx[3];
			if (dirty[0] & /*show_label*/ 1024) dropdown_changes.show_label = /*show_label*/ ctx[10];
			if (dirty[0] & /*filterable*/ 2048) dropdown_changes.filterable = /*filterable*/ ctx[11];
			if (dirty[0] & /*allow_custom_value*/ 65536) dropdown_changes.allow_custom_value = /*allow_custom_value*/ ctx[16];
			if (dirty[0] & /*container*/ 4096) dropdown_changes.container = /*container*/ ctx[12];
			if (dirty[0] & /*interactive*/ 262144) dropdown_changes.disabled = !/*interactive*/ ctx[18];

			if (!updating_value && dirty[0] & /*value*/ 1) {
				updating_value = true;
				dropdown_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			if (!updating_value_is_output && dirty[0] & /*value_is_output*/ 2) {
				updating_value_is_output = true;
				dropdown_changes.value_is_output = /*value_is_output*/ ctx[1];
				add_flush_callback(() => updating_value_is_output = false);
			}

			dropdown.$set(dropdown_changes);
		},
		i(local) {
			if (current) return;
			transition_in(dropdown.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(dropdown.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(dropdown, detaching);
		}
	};
}

// (46:1) {#if multiselect}
function create_if_block(ctx) {
	let multiselect_1;
	let updating_value;
	let updating_value_is_output;
	let current;

	function multiselect_1_value_binding(value) {
		/*multiselect_1_value_binding*/ ctx[19](value);
	}

	function multiselect_1_value_is_output_binding(value) {
		/*multiselect_1_value_is_output_binding*/ ctx[20](value);
	}

	let multiselect_1_props = {
		choices: /*choices*/ ctx[9],
		max_choices: /*max_choices*/ ctx[8],
		label: /*label*/ ctx[2],
		info: /*info*/ ctx[3],
		show_label: /*show_label*/ ctx[10],
		allow_custom_value: /*allow_custom_value*/ ctx[16],
		filterable: /*filterable*/ ctx[11],
		container: /*container*/ ctx[12],
		i18n: /*gradio*/ ctx[17].i18n,
		disabled: !/*interactive*/ ctx[18]
	};

	if (/*value*/ ctx[0] !== void 0) {
		multiselect_1_props.value = /*value*/ ctx[0];
	}

	if (/*value_is_output*/ ctx[1] !== void 0) {
		multiselect_1_props.value_is_output = /*value_is_output*/ ctx[1];
	}

	multiselect_1 = new Multiselect$1({ props: multiselect_1_props });
	binding_callbacks.push(() => bind(multiselect_1, 'value', multiselect_1_value_binding));
	binding_callbacks.push(() => bind(multiselect_1, 'value_is_output', multiselect_1_value_is_output_binding));
	multiselect_1.$on("change", /*change_handler*/ ctx[21]);
	multiselect_1.$on("input", /*input_handler*/ ctx[22]);
	multiselect_1.$on("select", /*select_handler*/ ctx[23]);
	multiselect_1.$on("blur", /*blur_handler*/ ctx[24]);
	multiselect_1.$on("focus", /*focus_handler*/ ctx[25]);
	multiselect_1.$on("key_up", /*key_up_handler*/ ctx[26]);

	return {
		c() {
			create_component(multiselect_1.$$.fragment);
		},
		m(target, anchor) {
			mount_component(multiselect_1, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const multiselect_1_changes = {};
			if (dirty[0] & /*choices*/ 512) multiselect_1_changes.choices = /*choices*/ ctx[9];
			if (dirty[0] & /*max_choices*/ 256) multiselect_1_changes.max_choices = /*max_choices*/ ctx[8];
			if (dirty[0] & /*label*/ 4) multiselect_1_changes.label = /*label*/ ctx[2];
			if (dirty[0] & /*info*/ 8) multiselect_1_changes.info = /*info*/ ctx[3];
			if (dirty[0] & /*show_label*/ 1024) multiselect_1_changes.show_label = /*show_label*/ ctx[10];
			if (dirty[0] & /*allow_custom_value*/ 65536) multiselect_1_changes.allow_custom_value = /*allow_custom_value*/ ctx[16];
			if (dirty[0] & /*filterable*/ 2048) multiselect_1_changes.filterable = /*filterable*/ ctx[11];
			if (dirty[0] & /*container*/ 4096) multiselect_1_changes.container = /*container*/ ctx[12];
			if (dirty[0] & /*gradio*/ 131072) multiselect_1_changes.i18n = /*gradio*/ ctx[17].i18n;
			if (dirty[0] & /*interactive*/ 262144) multiselect_1_changes.disabled = !/*interactive*/ ctx[18];

			if (!updating_value && dirty[0] & /*value*/ 1) {
				updating_value = true;
				multiselect_1_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			if (!updating_value_is_output && dirty[0] & /*value_is_output*/ 2) {
				updating_value_is_output = true;
				multiselect_1_changes.value_is_output = /*value_is_output*/ ctx[1];
				add_flush_callback(() => updating_value_is_output = false);
			}

			multiselect_1.$set(multiselect_1_changes);
		},
		i(local) {
			if (current) return;
			transition_in(multiselect_1.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(multiselect_1.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(multiselect_1, detaching);
		}
	};
}

// (31:0) <Block  {visible}  {elem_id}  {elem_classes}  padding={container}  allow_overflow={false}  {scale}  {min_width} >
function create_default_slot(ctx) {
	let statustracker;
	let t;
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;

	const statustracker_spread_levels = [
		{
			autoscroll: /*gradio*/ ctx[17].autoscroll
		},
		{ i18n: /*gradio*/ ctx[17].i18n },
		/*loading_status*/ ctx[15]
	];

	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new Static({ props: statustracker_props });
	const if_block_creators = [create_if_block, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*multiselect*/ ctx[7]) return 0;
		return 1;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty[0] & /*gradio, loading_status*/ 163840)
			? get_spread_update(statustracker_spread_levels, [
					dirty[0] & /*gradio*/ 131072 && {
						autoscroll: /*gradio*/ ctx[17].autoscroll
					},
					dirty[0] & /*gradio*/ 131072 && { i18n: /*gradio*/ ctx[17].i18n },
					dirty[0] & /*loading_status*/ 32768 && get_spread_object(/*loading_status*/ ctx[15])
				])
			: {};

			statustracker.$set(statustracker_changes);
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(t);
				detach(if_block_anchor);
			}

			destroy_component(statustracker, detaching);
			if_blocks[current_block_type_index].d(detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[6],
				elem_id: /*elem_id*/ ctx[4],
				elem_classes: /*elem_classes*/ ctx[5],
				padding: /*container*/ ctx[12],
				allow_overflow: false,
				scale: /*scale*/ ctx[13],
				min_width: /*min_width*/ ctx[14],
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const block_changes = {};
			if (dirty[0] & /*visible*/ 64) block_changes.visible = /*visible*/ ctx[6];
			if (dirty[0] & /*elem_id*/ 16) block_changes.elem_id = /*elem_id*/ ctx[4];
			if (dirty[0] & /*elem_classes*/ 32) block_changes.elem_classes = /*elem_classes*/ ctx[5];
			if (dirty[0] & /*container*/ 4096) block_changes.padding = /*container*/ ctx[12];
			if (dirty[0] & /*scale*/ 8192) block_changes.scale = /*scale*/ ctx[13];
			if (dirty[0] & /*min_width*/ 16384) block_changes.min_width = /*min_width*/ ctx[14];

			if (dirty[0] & /*choices, max_choices, label, info, show_label, allow_custom_value, filterable, container, gradio, interactive, value, value_is_output, multiselect, loading_status*/ 499599 | dirty[1] & /*$$scope*/ 16) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { label = "Dropdown" } = $$props;
	let { info = undefined } = $$props;
	let { elem_id = "" } = $$props;
	let { elem_classes = [] } = $$props;
	let { visible = true } = $$props;
	let { value = undefined } = $$props;
	let { value_is_output = false } = $$props;
	let { multiselect = false } = $$props;
	let { max_choices = null } = $$props;
	let { choices } = $$props;
	let { show_label } = $$props;
	let { filterable } = $$props;
	let { container = true } = $$props;
	let { scale = null } = $$props;
	let { min_width = undefined } = $$props;
	let { loading_status } = $$props;
	let { allow_custom_value = false } = $$props;
	let { gradio } = $$props;
	let { interactive } = $$props;

	function multiselect_1_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function multiselect_1_value_is_output_binding(value) {
		value_is_output = value;
		$$invalidate(1, value_is_output);
	}

	const change_handler = () => gradio.dispatch("change");
	const input_handler = () => gradio.dispatch("input");
	const select_handler = e => gradio.dispatch("select", e.detail);
	const blur_handler = () => gradio.dispatch("blur");
	const focus_handler = () => gradio.dispatch("focus");
	const key_up_handler = () => gradio.dispatch("key_up");

	function dropdown_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function dropdown_value_is_output_binding(value) {
		value_is_output = value;
		$$invalidate(1, value_is_output);
	}

	const change_handler_1 = () => gradio.dispatch("change");
	const input_handler_1 = () => gradio.dispatch("input");
	const select_handler_1 = e => gradio.dispatch("select", e.detail);
	const blur_handler_1 = () => gradio.dispatch("blur");
	const focus_handler_1 = () => gradio.dispatch("focus");
	const key_up_handler_1 = e => gradio.dispatch("key_up", e.detail);

	$$self.$$set = $$props => {
		if ('label' in $$props) $$invalidate(2, label = $$props.label);
		if ('info' in $$props) $$invalidate(3, info = $$props.info);
		if ('elem_id' in $$props) $$invalidate(4, elem_id = $$props.elem_id);
		if ('elem_classes' in $$props) $$invalidate(5, elem_classes = $$props.elem_classes);
		if ('visible' in $$props) $$invalidate(6, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('value_is_output' in $$props) $$invalidate(1, value_is_output = $$props.value_is_output);
		if ('multiselect' in $$props) $$invalidate(7, multiselect = $$props.multiselect);
		if ('max_choices' in $$props) $$invalidate(8, max_choices = $$props.max_choices);
		if ('choices' in $$props) $$invalidate(9, choices = $$props.choices);
		if ('show_label' in $$props) $$invalidate(10, show_label = $$props.show_label);
		if ('filterable' in $$props) $$invalidate(11, filterable = $$props.filterable);
		if ('container' in $$props) $$invalidate(12, container = $$props.container);
		if ('scale' in $$props) $$invalidate(13, scale = $$props.scale);
		if ('min_width' in $$props) $$invalidate(14, min_width = $$props.min_width);
		if ('loading_status' in $$props) $$invalidate(15, loading_status = $$props.loading_status);
		if ('allow_custom_value' in $$props) $$invalidate(16, allow_custom_value = $$props.allow_custom_value);
		if ('gradio' in $$props) $$invalidate(17, gradio = $$props.gradio);
		if ('interactive' in $$props) $$invalidate(18, interactive = $$props.interactive);
	};

	return [
		value,
		value_is_output,
		label,
		info,
		elem_id,
		elem_classes,
		visible,
		multiselect,
		max_choices,
		choices,
		show_label,
		filterable,
		container,
		scale,
		min_width,
		loading_status,
		allow_custom_value,
		gradio,
		interactive,
		multiselect_1_value_binding,
		multiselect_1_value_is_output_binding,
		change_handler,
		input_handler,
		select_handler,
		blur_handler,
		focus_handler,
		key_up_handler,
		dropdown_value_binding,
		dropdown_value_is_output_binding,
		change_handler_1,
		input_handler_1,
		select_handler_1,
		blur_handler_1,
		focus_handler_1,
		key_up_handler_1
	];
}

class Index extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance,
			create_fragment,
			safe_not_equal,
			{
				label: 2,
				info: 3,
				elem_id: 4,
				elem_classes: 5,
				visible: 6,
				value: 0,
				value_is_output: 1,
				multiselect: 7,
				max_choices: 8,
				choices: 9,
				show_label: 10,
				filterable: 11,
				container: 12,
				scale: 13,
				min_width: 14,
				loading_status: 15,
				allow_custom_value: 16,
				gradio: 17,
				interactive: 18
			},
			null,
			[-1, -1]
		);
	}
}

export { Dropdown$1 as BaseDropdown, Multiselect$1 as BaseMultiselect, Index as default };
//# sourceMappingURL=Index-4d155ca6.js.map
