import { p as prepare_files, u as upload } from './index-ec890757.js';
import './Index-3b1865e7.js';

const UploadProgress_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/upload/src/UploadProgress.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent: SvelteComponent$1,
	append: append$1,
	attr: attr$1,
	detach: detach$1,
	element: element$1,
	init: init$1,
	insert: insert$1,
	noop,
	safe_not_equal: safe_not_equal$1,
	set_data,
	set_style: set_style$1,
	space: space$1,
	text,
	toggle_class: toggle_class$1
} = window.__gradio__svelte__internal;const { onMount, createEventDispatcher: createEventDispatcher$1, getContext: getContext$1 } = window.__gradio__svelte__internal;
function create_if_block$1(ctx) {
	let div1;
	let span0;
	let div0;
	let progress_1;
	let t0_value = getProgress(/*file_to_display*/ ctx[2]) + "";
	let t0;
	let progress_1_value_value;
	let t1;
	let span1;
	let t2_value = /*file_to_display*/ ctx[2].orig_name + "";
	let t2;

	return {
		c() {
			div1 = element$1("div");
			span0 = element$1("span");
			div0 = element$1("div");
			progress_1 = element$1("progress");
			t0 = text(t0_value);
			t1 = space$1();
			span1 = element$1("span");
			t2 = text(t2_value);
			set_style$1(progress_1, "visibility", "hidden");
			set_style$1(progress_1, "height", "0");
			set_style$1(progress_1, "width", "0");
			progress_1.value = progress_1_value_value = getProgress(/*file_to_display*/ ctx[2]);
			attr$1(progress_1, "max", "100");
			attr$1(progress_1, "class", "svelte-1vsfomn");
			attr$1(div0, "class", "progress-bar svelte-1vsfomn");
			attr$1(span1, "class", "file-name svelte-1vsfomn");
			attr$1(div1, "class", "file svelte-1vsfomn");
		},
		m(target, anchor) {
			insert$1(target, div1, anchor);
			append$1(div1, span0);
			append$1(span0, div0);
			append$1(div0, progress_1);
			append$1(progress_1, t0);
			append$1(div1, t1);
			append$1(div1, span1);
			append$1(span1, t2);
		},
		p(ctx, dirty) {
			if (dirty & /*file_to_display*/ 4 && t0_value !== (t0_value = getProgress(/*file_to_display*/ ctx[2]) + "")) set_data(t0, t0_value);

			if (dirty & /*file_to_display*/ 4 && progress_1_value_value !== (progress_1_value_value = getProgress(/*file_to_display*/ ctx[2]))) {
				progress_1.value = progress_1_value_value;
			}

			if (dirty & /*file_to_display*/ 4 && t2_value !== (t2_value = /*file_to_display*/ ctx[2].orig_name + "")) set_data(t2, t2_value);
		},
		d(detaching) {
			if (detaching) {
				detach$1(div1);
			}
		}
	};
}

function create_fragment$1(ctx) {
	let div;
	let span;
	let t0;
	let t1_value = /*files_with_progress*/ ctx[0].length + "";
	let t1;
	let t2;

	let t3_value = (/*files_with_progress*/ ctx[0].length > 1
	? "files"
	: "file") + "";

	let t3;
	let t4;
	let t5;
	let if_block = /*file_to_display*/ ctx[2] && create_if_block$1(ctx);

	return {
		c() {
			div = element$1("div");
			span = element$1("span");
			t0 = text("Uploading ");
			t1 = text(t1_value);
			t2 = space$1();
			t3 = text(t3_value);
			t4 = text("...");
			t5 = space$1();
			if (if_block) if_block.c();
			attr$1(span, "class", "uploading svelte-1vsfomn");
			attr$1(div, "class", "wrap svelte-1vsfomn");
			toggle_class$1(div, "progress", /*progress*/ ctx[1]);
		},
		m(target, anchor) {
			insert$1(target, div, anchor);
			append$1(div, span);
			append$1(span, t0);
			append$1(span, t1);
			append$1(span, t2);
			append$1(span, t3);
			append$1(span, t4);
			append$1(div, t5);
			if (if_block) if_block.m(div, null);
		},
		p(ctx, [dirty]) {
			if (dirty & /*files_with_progress*/ 1 && t1_value !== (t1_value = /*files_with_progress*/ ctx[0].length + "")) set_data(t1, t1_value);

			if (dirty & /*files_with_progress*/ 1 && t3_value !== (t3_value = (/*files_with_progress*/ ctx[0].length > 1
			? "files"
			: "file") + "")) set_data(t3, t3_value);

			if (/*file_to_display*/ ctx[2]) {
				if (if_block) {
					if_block.p(ctx, dirty);
				} else {
					if_block = create_if_block$1(ctx);
					if_block.c();
					if_block.m(div, null);
				}
			} else if (if_block) {
				if_block.d(1);
				if_block = null;
			}

			if (dirty & /*progress*/ 2) {
				toggle_class$1(div, "progress", /*progress*/ ctx[1]);
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) {
				detach$1(div);
			}

			if (if_block) if_block.d();
		}
	};
}

function getProgress(file) {
	return file.progress * 100 / (file.size || 0) || 0;
}

function calculateTotalProgress(files) {
	let totalProgress = 0;

	files.forEach(file => {
		totalProgress += getProgress(file);
	});

	document.documentElement.style.setProperty("--upload-progress-width", (totalProgress / files.length).toFixed(2) + "%");
	return totalProgress / files.length;
}

function instance$1($$self, $$props, $$invalidate) {
	let { upload_id } = $$props;
	let { root } = $$props;
	let { files } = $$props;
	let event_source;
	let progress = false;
	let current_file_upload;
	let file_to_display;

	let files_with_progress = files.map(file => {
		return { ...file, progress: 0 };
	});

	const dispatch = createEventDispatcher$1();

	function handleProgress(filename, chunk_size) {
		// Find the corresponding file in the array and update its progress
		$$invalidate(0, files_with_progress = files_with_progress.map(file => {
			if (file.orig_name === filename) {
				file.progress += chunk_size;
			}

			return file;
		}));
	}

	const EventSource_factory = getContext$1("EventSource_factory");

	onMount(() => {
		event_source = EventSource_factory(new URL(`${root}/upload_progress?upload_id=${upload_id}`));

		// Event listener for progress updates
		event_source.onmessage = async function (event) {
			const _data = JSON.parse(event.data);
			if (!progress) $$invalidate(1, progress = true);

			if (_data.msg === "done") {
				event_source.close();
				dispatch("done");
			} else {
				$$invalidate(6, current_file_upload = _data);
				handleProgress(_data.orig_name, _data.chunk_size);
			}
		};
	});

	$$self.$$set = $$props => {
		if ('upload_id' in $$props) $$invalidate(3, upload_id = $$props.upload_id);
		if ('root' in $$props) $$invalidate(4, root = $$props.root);
		if ('files' in $$props) $$invalidate(5, files = $$props.files);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*files_with_progress*/ 1) {
			calculateTotalProgress(files_with_progress);
		}

		if ($$self.$$.dirty & /*current_file_upload, files_with_progress*/ 65) {
			$$invalidate(2, file_to_display = current_file_upload || files_with_progress[0]);
		}
	};

	return [
		files_with_progress,
		progress,
		file_to_display,
		upload_id,
		root,
		files,
		current_file_upload
	];
}

class UploadProgress extends SvelteComponent$1 {
	constructor(options) {
		super();
		init$1(this, options, instance$1, create_fragment$1, safe_not_equal$1, { upload_id: 3, root: 4, files: 5 });
	}
}

const Upload_svelte_svelte_type_style_lang = '';

/* home/runner/work/gradio/gradio/js/upload/src/Upload.svelte generated by Svelte v4.2.2 */
const {
	SvelteComponent,
	append,
	attr,
	binding_callbacks,
	bubble,
	check_outros,
	create_component,
	create_slot,
	destroy_component,
	detach,
	element,
	empty,
	get_all_dirty_from_scope,
	get_slot_changes,
	group_outros,
	init,
	insert,
	listen,
	mount_component,
	prevent_default,
	run_all,
	safe_not_equal,
	set_style,
	space,
	stop_propagation,
	toggle_class,
	transition_in,
	transition_out,
	update_slot_base
} = window.__gradio__svelte__internal;
const { createEventDispatcher, tick, getContext } = window.__gradio__svelte__internal;
function create_else_block(ctx) {
	let button;
	let t;
	let input;
	let input_accept_value;
	let input_multiple_value;
	let input_webkitdirectory_value;
	let input_mozdirectory_value;
	let button_tabindex_value;
	let current;
	let mounted;
	let dispose;
	const default_slot_template = /*#slots*/ ctx[22].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[21], null);

	return {
		c() {
			button = element("button");
			if (default_slot) default_slot.c();
			t = space();
			input = element("input");
			attr(input, "aria-label", "file upload");
			attr(input, "data-testid", "file-upload");
			attr(input, "type", "file");
			attr(input, "accept", input_accept_value = /*accept_file_types*/ ctx[14] || undefined);
			input.multiple = input_multiple_value = /*file_count*/ ctx[6] === "multiple" || undefined;
			attr(input, "webkitdirectory", input_webkitdirectory_value = /*file_count*/ ctx[6] === "directory" || undefined);
			attr(input, "mozdirectory", input_mozdirectory_value = /*file_count*/ ctx[6] === "directory" || undefined);
			attr(input, "class", "svelte-j5bxrl");
			attr(button, "tabindex", button_tabindex_value = /*hidden*/ ctx[9] ? -1 : 0);
			attr(button, "class", "svelte-j5bxrl");
			toggle_class(button, "hidden", /*hidden*/ ctx[9]);
			toggle_class(button, "center", /*center*/ ctx[4]);
			toggle_class(button, "boundedheight", /*boundedheight*/ ctx[3]);
			toggle_class(button, "flex", /*flex*/ ctx[5]);
			toggle_class(button, "disable_click", /*disable_click*/ ctx[7]);
			set_style(button, "height", `100%`);
		},
		m(target, anchor) {
			insert(target, button, anchor);

			if (default_slot) {
				default_slot.m(button, null);
			}

			append(button, t);
			append(button, input);
			/*input_binding*/ ctx[30](input);
			current = true;

			if (!mounted) {
				dispose = [
					listen(input, "change", /*load_files_from_upload*/ ctx[16]),
					listen(button, "drag", stop_propagation(prevent_default(/*drag_handler*/ ctx[23]))),
					listen(button, "dragstart", stop_propagation(prevent_default(/*dragstart_handler*/ ctx[24]))),
					listen(button, "dragend", stop_propagation(prevent_default(/*dragend_handler*/ ctx[25]))),
					listen(button, "dragover", stop_propagation(prevent_default(/*dragover_handler*/ ctx[26]))),
					listen(button, "dragenter", stop_propagation(prevent_default(/*dragenter_handler*/ ctx[27]))),
					listen(button, "dragleave", stop_propagation(prevent_default(/*dragleave_handler*/ ctx[28]))),
					listen(button, "drop", stop_propagation(prevent_default(/*drop_handler*/ ctx[29]))),
					listen(button, "click", /*open_file_upload*/ ctx[11]),
					listen(button, "drop", /*loadFilesFromDrop*/ ctx[17]),
					listen(button, "dragenter", /*updateDragging*/ ctx[15]),
					listen(button, "dragleave", /*updateDragging*/ ctx[15])
				];

				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (default_slot) {
				if (default_slot.p && (!current || dirty[0] & /*$$scope*/ 2097152)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[21],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[21])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[21], dirty, null),
						null
					);
				}
			}

			if (!current || dirty[0] & /*accept_file_types*/ 16384 && input_accept_value !== (input_accept_value = /*accept_file_types*/ ctx[14] || undefined)) {
				attr(input, "accept", input_accept_value);
			}

			if (!current || dirty[0] & /*file_count*/ 64 && input_multiple_value !== (input_multiple_value = /*file_count*/ ctx[6] === "multiple" || undefined)) {
				input.multiple = input_multiple_value;
			}

			if (!current || dirty[0] & /*file_count*/ 64 && input_webkitdirectory_value !== (input_webkitdirectory_value = /*file_count*/ ctx[6] === "directory" || undefined)) {
				attr(input, "webkitdirectory", input_webkitdirectory_value);
			}

			if (!current || dirty[0] & /*file_count*/ 64 && input_mozdirectory_value !== (input_mozdirectory_value = /*file_count*/ ctx[6] === "directory" || undefined)) {
				attr(input, "mozdirectory", input_mozdirectory_value);
			}

			if (!current || dirty[0] & /*hidden*/ 512 && button_tabindex_value !== (button_tabindex_value = /*hidden*/ ctx[9] ? -1 : 0)) {
				attr(button, "tabindex", button_tabindex_value);
			}

			if (!current || dirty[0] & /*hidden*/ 512) {
				toggle_class(button, "hidden", /*hidden*/ ctx[9]);
			}

			if (!current || dirty[0] & /*center*/ 16) {
				toggle_class(button, "center", /*center*/ ctx[4]);
			}

			if (!current || dirty[0] & /*boundedheight*/ 8) {
				toggle_class(button, "boundedheight", /*boundedheight*/ ctx[3]);
			}

			if (!current || dirty[0] & /*flex*/ 32) {
				toggle_class(button, "flex", /*flex*/ ctx[5]);
			}

			if (!current || dirty[0] & /*disable_click*/ 128) {
				toggle_class(button, "disable_click", /*disable_click*/ ctx[7]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(button);
			}

			if (default_slot) default_slot.d(detaching);
			/*input_binding*/ ctx[30](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

// (158:20) 
function create_if_block_1(ctx) {
	let if_block_anchor;
	let current;
	let if_block = !/*hidden*/ ctx[9] && create_if_block_2(ctx);

	return {
		c() {
			if (if_block) if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if (if_block) if_block.m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (!/*hidden*/ ctx[9]) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty[0] & /*hidden*/ 512) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block_2(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(if_block_anchor.parentNode, if_block_anchor);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(if_block_anchor);
			}

			if (if_block) if_block.d(detaching);
		}
	};
}

// (146:0) {#if filetype === "clipboard"}
function create_if_block(ctx) {
	let button;
	let button_tabindex_value;
	let current;
	let mounted;
	let dispose;
	const default_slot_template = /*#slots*/ ctx[22].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[21], null);

	return {
		c() {
			button = element("button");
			if (default_slot) default_slot.c();
			attr(button, "tabindex", button_tabindex_value = /*hidden*/ ctx[9] ? -1 : 0);
			attr(button, "class", "svelte-j5bxrl");
			toggle_class(button, "hidden", /*hidden*/ ctx[9]);
			toggle_class(button, "center", /*center*/ ctx[4]);
			toggle_class(button, "boundedheight", /*boundedheight*/ ctx[3]);
			toggle_class(button, "flex", /*flex*/ ctx[5]);
			set_style(button, "height", `100%`);
		},
		m(target, anchor) {
			insert(target, button, anchor);

			if (default_slot) {
				default_slot.m(button, null);
			}

			current = true;

			if (!mounted) {
				dispose = listen(button, "click", /*paste_clipboard*/ ctx[10]);
				mounted = true;
			}
		},
		p(ctx, dirty) {
			if (default_slot) {
				if (default_slot.p && (!current || dirty[0] & /*$$scope*/ 2097152)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[21],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[21])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[21], dirty, null),
						null
					);
				}
			}

			if (!current || dirty[0] & /*hidden*/ 512 && button_tabindex_value !== (button_tabindex_value = /*hidden*/ ctx[9] ? -1 : 0)) {
				attr(button, "tabindex", button_tabindex_value);
			}

			if (!current || dirty[0] & /*hidden*/ 512) {
				toggle_class(button, "hidden", /*hidden*/ ctx[9]);
			}

			if (!current || dirty[0] & /*center*/ 16) {
				toggle_class(button, "center", /*center*/ ctx[4]);
			}

			if (!current || dirty[0] & /*boundedheight*/ 8) {
				toggle_class(button, "boundedheight", /*boundedheight*/ ctx[3]);
			}

			if (!current || dirty[0] & /*flex*/ 32) {
				toggle_class(button, "flex", /*flex*/ ctx[5]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(button);
			}

			if (default_slot) default_slot.d(detaching);
			mounted = false;
			dispose();
		}
	};
}

// (159:1) {#if !hidden}
function create_if_block_2(ctx) {
	let uploadprogress;
	let current;

	uploadprogress = new UploadProgress({
			props: {
				root: /*root*/ ctx[8],
				upload_id: /*upload_id*/ ctx[12],
				files: /*file_data*/ ctx[13]
			}
		});

	return {
		c() {
			create_component(uploadprogress.$$.fragment);
		},
		m(target, anchor) {
			mount_component(uploadprogress, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const uploadprogress_changes = {};
			if (dirty[0] & /*root*/ 256) uploadprogress_changes.root = /*root*/ ctx[8];
			if (dirty[0] & /*upload_id*/ 4096) uploadprogress_changes.upload_id = /*upload_id*/ ctx[12];
			if (dirty[0] & /*file_data*/ 8192) uploadprogress_changes.files = /*file_data*/ ctx[13];
			uploadprogress.$set(uploadprogress_changes);
		},
		i(local) {
			if (current) return;
			transition_in(uploadprogress.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(uploadprogress.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(uploadprogress, detaching);
		}
	};
}

function create_fragment(ctx) {
	let current_block_type_index;
	let if_block;
	let if_block_anchor;
	let current;
	const if_block_creators = [create_if_block, create_if_block_1, create_else_block];
	const if_blocks = [];

	function select_block_type(ctx, dirty) {
		if (/*filetype*/ ctx[0] === "clipboard") return 0;
		if (/*uploading*/ ctx[1]) return 1;
		return 2;
	}

	current_block_type_index = select_block_type(ctx);
	if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);

	return {
		c() {
			if_block.c();
			if_block_anchor = empty();
		},
		m(target, anchor) {
			if_blocks[current_block_type_index].m(target, anchor);
			insert(target, if_block_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			let previous_block_index = current_block_type_index;
			current_block_type_index = select_block_type(ctx);

			if (current_block_type_index === previous_block_index) {
				if_blocks[current_block_type_index].p(ctx, dirty);
			} else {
				group_outros();

				transition_out(if_blocks[previous_block_index], 1, 1, () => {
					if_blocks[previous_block_index] = null;
				});

				check_outros();
				if_block = if_blocks[current_block_type_index];

				if (!if_block) {
					if_block = if_blocks[current_block_type_index] = if_block_creators[current_block_type_index](ctx);
					if_block.c();
				} else {
					if_block.p(ctx, dirty);
				}

				transition_in(if_block, 1);
				if_block.m(if_block_anchor.parentNode, if_block_anchor);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);
			current = true;
		},
		o(local) {
			transition_out(if_block);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(if_block_anchor);
			}

			if_blocks[current_block_type_index].d(detaching);
		}
	};
}

function is_valid_mimetype(file_accept, uploaded_file_extension, uploaded_file_type) {
	if (!file_accept || file_accept === "*" || file_accept === "file/*" || Array.isArray(file_accept) && file_accept.some(accept => accept === "*" || accept === "file/*")) {
		return true;
	}

	let acceptArray;

	if (typeof file_accept === "string") {
		acceptArray = file_accept.split(",").map(s => s.trim());
	} else if (Array.isArray(file_accept)) {
		acceptArray = file_accept;
	} else {
		return false;
	}

	return acceptArray.includes(uploaded_file_extension) || acceptArray.some(type => {
		const [category] = type.split("/").map(s => s.trim());
		return type.endsWith("/*") && uploaded_file_type.startsWith(category + "/");
	});
}

function instance($$self, $$props, $$invalidate) {
	let { $$slots: slots = {}, $$scope } = $$props;
	let { filetype = null } = $$props;
	let { dragging = false } = $$props;
	let { boundedheight = true } = $$props;
	let { center = true } = $$props;
	let { flex = true } = $$props;
	let { file_count = "single" } = $$props;
	let { disable_click = false } = $$props;
	let { root } = $$props;
	let { hidden = false } = $$props;
	let { format = "file" } = $$props;
	let { uploading = false } = $$props;
	let { hidden_upload = null } = $$props;
	let upload_id;
	let file_data;
	let accept_file_types;

	// Needed for wasm support
	const upload_fn = getContext("upload_files");

	const dispatch = createEventDispatcher();
	const validFileTypes = ["image", "video", "audio", "text", "file"];

	const processFileType = type => {
		if (type.startsWith(".") || type.endsWith("/*")) {
			return type;
		}

		if (validFileTypes.includes(type)) {
			return type + "/*";
		}

		return "." + type;
	};

	function updateDragging() {
		$$invalidate(18, dragging = !dragging);
	}

	function paste_clipboard() {
		navigator.clipboard.read().then(async items => {
			for (let i = 0; i < items.length; i++) {
				const type = items[i].types.find(t => t.startsWith("image/"));

				if (type) {
					items[i].getType(type).then(async blob => {
						const file = new File([blob], `clipboard.${type.replace("image/", "")}`);
						await load_files([file]);
					});

					break;
				}
			}
		});
	}

	function open_file_upload() {
		if (disable_click) return;

		if (hidden_upload) {
			$$invalidate(2, hidden_upload.value = "", hidden_upload);
			hidden_upload.click();
		}
	}

	async function handle_upload(file_data) {
		await tick();
		$$invalidate(12, upload_id = Math.random().toString(36).substring(2, 15));
		$$invalidate(1, uploading = true);
		const _file_data = await upload(file_data, root, upload_id, upload_fn);
		dispatch("load", file_count === "single" ? _file_data?.[0] : _file_data);
		$$invalidate(1, uploading = false);
		return _file_data || [];
	}

	async function load_files(files) {
		if (!files.length) {
			return;
		}

		let _files = files.map(f => new File([f], f.name, { type: f.type }));
		$$invalidate(13, file_data = await prepare_files(_files));
		return await handle_upload(file_data);
	}

	async function load_files_from_upload(e) {
		const target = e.target;
		if (!target.files) return;

		if (format != "blob") {
			await load_files(Array.from(target.files));
		} else {
			if (file_count === "single") {
				dispatch("load", target.files[0]);
				return;
			}

			dispatch("load", target.files);
		}
	}

	async function loadFilesFromDrop(e) {
		$$invalidate(18, dragging = false);
		if (!e.dataTransfer?.files) return;

		const files_to_load = Array.from(e.dataTransfer.files).filter(file => {
			const file_extension = "." + file.name.split(".").pop();

			if (file_extension && is_valid_mimetype(accept_file_types, file_extension, file.type)) {
				return true;
			}

			if (file_extension && Array.isArray(filetype)
			? filetype.includes(file_extension)
			: file_extension === filetype) {
				return true;
			}

			dispatch("error", `Invalid file type only ${filetype} allowed.`);
			return false;
		});

		await load_files(files_to_load);
	}

	function drag_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragstart_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragend_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragover_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragenter_handler(event) {
		bubble.call(this, $$self, event);
	}

	function dragleave_handler(event) {
		bubble.call(this, $$self, event);
	}

	function drop_handler(event) {
		bubble.call(this, $$self, event);
	}

	function input_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			hidden_upload = $$value;
			$$invalidate(2, hidden_upload);
		});
	}

	$$self.$$set = $$props => {
		if ('filetype' in $$props) $$invalidate(0, filetype = $$props.filetype);
		if ('dragging' in $$props) $$invalidate(18, dragging = $$props.dragging);
		if ('boundedheight' in $$props) $$invalidate(3, boundedheight = $$props.boundedheight);
		if ('center' in $$props) $$invalidate(4, center = $$props.center);
		if ('flex' in $$props) $$invalidate(5, flex = $$props.flex);
		if ('file_count' in $$props) $$invalidate(6, file_count = $$props.file_count);
		if ('disable_click' in $$props) $$invalidate(7, disable_click = $$props.disable_click);
		if ('root' in $$props) $$invalidate(8, root = $$props.root);
		if ('hidden' in $$props) $$invalidate(9, hidden = $$props.hidden);
		if ('format' in $$props) $$invalidate(19, format = $$props.format);
		if ('uploading' in $$props) $$invalidate(1, uploading = $$props.uploading);
		if ('hidden_upload' in $$props) $$invalidate(2, hidden_upload = $$props.hidden_upload);
		if ('$$scope' in $$props) $$invalidate(21, $$scope = $$props.$$scope);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*filetype*/ 1) {
			if (filetype == null) {
				$$invalidate(14, accept_file_types = null);
			} else if (typeof filetype === "string") {
				$$invalidate(14, accept_file_types = processFileType(filetype));
			} else {
				$$invalidate(0, filetype = filetype.map(processFileType));
				$$invalidate(14, accept_file_types = filetype.join(", "));
			}
		}
	};

	return [
		filetype,
		uploading,
		hidden_upload,
		boundedheight,
		center,
		flex,
		file_count,
		disable_click,
		root,
		hidden,
		paste_clipboard,
		open_file_upload,
		upload_id,
		file_data,
		accept_file_types,
		updateDragging,
		load_files_from_upload,
		loadFilesFromDrop,
		dragging,
		format,
		load_files,
		$$scope,
		slots,
		drag_handler,
		dragstart_handler,
		dragend_handler,
		dragover_handler,
		dragenter_handler,
		dragleave_handler,
		drop_handler,
		input_binding
	];
}

class Upload extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance,
			create_fragment,
			safe_not_equal,
			{
				filetype: 0,
				dragging: 18,
				boundedheight: 3,
				center: 4,
				flex: 5,
				file_count: 6,
				disable_click: 7,
				root: 8,
				hidden: 9,
				format: 19,
				uploading: 1,
				hidden_upload: 2,
				paste_clipboard: 10,
				open_file_upload: 11,
				load_files: 20
			},
			null,
			[-1, -1]
		);
	}

	get paste_clipboard() {
		return this.$$.ctx[10];
	}

	get open_file_upload() {
		return this.$$.ctx[11];
	}

	get load_files() {
		return this.$$.ctx[20];
	}
}

const ModifyUpload_svelte_svelte_type_style_lang = '';

export { Upload as U };
//# sourceMappingURL=ModifyUpload.svelte_svelte_type_style_lang-7a67d238.js.map
