
#SubLevel10 Technologies 2024
#quick and dirty (wanted to get rid of imagemagik)
#Make a png thumbnail (-t   &  -tsize)
#Convert input image to png and save in temp folder for processing (-prepost) (same size as original if -tsize = ""  )
#when using for after processing, makes thumnail and copy temp output to real location and convert to real type
#and write a text file with all old and new dimensions

#python.exe 1d.py  --convert -prepost "post" -i "www.png" -o "image.png" -isize "" -t "thumb.png" -tsize "170"  -txt "x_thumb_info"

import argparse
from PIL import Image

parser = argparse.ArgumentParser(description="A simple CLI program")

# arguments
parser.add_argument("-i", type=str, help="Original Image In") #C:\Users\xxx\Desktop\UXs\Zoe Depth\ZoeDepth_UX\test\image.jpg
parser.add_argument("-o", type=str, help="Image out") #C:\Users\xxx\Desktop\UXs\Zoe Depth\ZoeDepth_UX\test\thumb.jpg
parser.add_argument("-t", type=str, help="Thumbnail out") #C:\Users\xxx\Desktop\UXs\Zoe Depth\ZoeDepth_UX\test\thumb.jpg
parser.add_argument("-prepost", type=str, help="sending code b4 processing or after") #pre / post
parser.add_argument("-isize", type=int, help="New Resized Image size  if -isize="" then no size change") #1200 ... the largest you want the width or height .. the biggest number will be this
parser.add_argument("-tsize", type=int, help="Thumbnail output size") #170 .. samesies
parser.add_argument("-txt", type=str, help="Text file to save all size info") #C:\Users\xxx\Desktop\UXs\Zoe Depth\ZoeDepth_UX\test
parser.add_argument("--convert", action="store_true", help="Greet the user")

args = parser.parse_args()

if args.convert:

	#if input image is png add .convert('RGB') to save as another type
	convert_out = args.o
	thumb_out = args.t
	prepost = args.prepost
	image = Image.open(args.i)#.convert('RGB')  Open the image
	txtfile = args.txt	#if need to write info to text file
	new_isize = args.isize
	new_tsize = args.tsize

	if prepost == "post": #input is temp image png with no transparency .. makes thumbnail and moves image to true output location and file type
		image = Image.open(args.i).convert('RGB')

	if prepost == "pre": #makes a png thumbnail and moves image to temp folder as a png
		image = Image.open(args.i)
	
	#get orig size
	width, height = image.size
	old_W = image.width
	old_H = image.height
	bigger = max(old_W, old_H)

	if  old_W == old_H:
		bigger = old_W

	if bigger == old_W:
		tratio = new_tsize/old_W
		iratio = new_isize/old_W
		biggest = "w"
			

	if bigger == old_H:
		tratio = new_tsize/old_H
		iratio = new_isize/old_H
		biggest = "h"
			
##################   for thumbnails  ##################################
	
	if thumb_out != "":
		if bigger == old_W:
			new_thumb_W = new_tsize	#new size for Thumb
			new_thumb_H = round(tratio*old_H, 0)	

		if bigger == old_H:
			new_thumb_H = new_tsize	#new size for Thumb
			new_thumb_W = round(tratio*old_W, 0)
		
		thumb_sized = (int(new_thumb_W), int(new_thumb_H))# new sizes		
		resized_thumb = image.resize(thumb_sized)#resize em		
		resized_thumb.save(thumb_out)#save em


######################    for images    #################################
	
	if new_isize == 0:
		image.save(convert_out) #save input image same size as orig
		new_W = old_W #for text file only
		new_H = old_H #for text file only

	if new_isize != 0:
		if bigger == old_W:
			new_W = new_isize	#new size for Large image
			new_H = round(iratio*old_H, 0)

		if bigger == old_H:
			new_H = new_isize	#new size for Large image
			new_W = round(iratio*old_W, 0)

		
		large_sized = (int(new_W), int(new_H))# new sizes		
		resized_image = image.resize(large_sized)#resize em
		resized_image.save(convert_out)#save em

##################################################################
	#write info to text file
	filewh = open(txtfile, "w")			 # w-overwrite  a-append
	filewh.write("{oldW=\"" + str(old_W) + "\", oldH=\"" + str(old_H) + "\", newImageW=\"" + str(new_W) + "\", newImageH=\"" + str(new_H) + "\", thumbW=\"" + str(new_thumb_W) + "\", thumbH=\"" + str(new_thumb_H) + "\", larger=\"" + str(biggest) + "\"}  \r\n" + str(old_W) + "\r\n" + str(old_H) + "\r\n" + str(new_W) + "\r\n" + str(new_H) + "\r\n" + str(new_thumb_W) + "\r\n" + str(new_thumb_H) + "\r\n" + str(biggest) + "")
	filewh.close
